/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.fitnesse.FitnessePage;

public class FitnesseReportMojo
extends AbstractMavenReport {
    private MavenProject project;
    private File xmlOutputDirectory;
    private File outputDirectory;
    private File fitnesseOutputDirectory;
    private File workingDir;
    private Renderer siteRenderer;

    protected void executeReport(Locale pArg0) throws MavenReportException {
        this.getLog().info((CharSequence)("outputDirectory=" + this.outputDirectory));
        this.outputDirectory.mkdirs();
        this.xmlOutputDirectory.mkdirs();
        this.checkReport();
        this.createReport();
        this.createIndex();
        FitnesseReportMojo.copyAllResources(this.outputDirectory, this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
        this.getLog().info((CharSequence)"Fitnesse report finished");
    }

    public static void copyAllResources(File pToDir, Log pLog, ClassLoader pLoader) throws MavenReportException {
        FitnesseReportMojo.copyResource(pToDir, "fitnesse.js", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "fitnesse_base.css", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "fitnesse_print.css", pLog, pLoader);
        new File(pToDir + "/images").mkdir();
        FitnesseReportMojo.copyResource(pToDir, "images/collapsableClosed.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/collapsableOpen.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/FitNesseLogo.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/FitNesseLogoMedium.jpg", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/folder.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/importedPage.jpg", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/virtualPage.jpg", pLog, pLoader);
        new File(pToDir + "/images/executionStatus").mkdir();
        FitnesseReportMojo.copyResource(pToDir, "images/executionStatus/error.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/executionStatus/ok.gif", pLog, pLoader);
        FitnesseReportMojo.copyResource(pToDir, "images/executionStatus/output.gif", pLog, pLoader);
    }

    private static void copyResource(File pToDir, String pFileName, Log pLog, ClassLoader pLoader) throws MavenReportException {
        File tDest = new File(pToDir + "/" + pFileName);
        FitnesseReportMojo.copyFile(pLog, pLoader.getResourceAsStream("fitnesse_resources/" + pFileName), tDest);
    }

    private void createReport() throws MavenReportException {
        File[] tFileArray = this.getFitnesseReportDir().listFiles();
        for (int i = 0; i < tFileArray.length; ++i) {
            File curFile = tFileArray[i];
            if (!curFile.exists()) {
                throw new MavenReportException("Unable to find Fitnesse report for server " + curFile);
            }
            if (!curFile.getName().startsWith("fitnesseResult")) continue;
            File tDestFile = new File(this.outputDirectory + "/" + curFile.getName());
            try {
                FitnesseReportMojo.copyFile(this.getLog(), new FileInputStream(curFile), tDestFile);
                continue;
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to create File [" + curFile.getAbsolutePath() + "].", (Exception)e);
            }
        }
    }

    void checkReport() throws MavenReportException {
        if (this.getFitnesseReportDir().listFiles().length == 0) {
            this.getLog().error((CharSequence)"Your should configure at least one Fitnesse server. Check your Fitnesse plugin configuration.");
            throw new MavenReportException("Your should configure at least one Fitnesse server. Check your Fitnesse plugin configuration.");
        }
    }

    static void copyFile(Log pLogger, InputStream pIn, File pDestFile) throws MavenReportException {
        FileOutputStream tOut = null;
        try {
            if (!pDestFile.exists()) {
                pDestFile.createNewFile();
            }
            tOut = new FileOutputStream(pDestFile);
            byte[] tBuff = new byte[100];
            int tRead = pIn.read(tBuff);
            while (tRead >= 0) {
                tOut.write(tBuff, 0, tRead);
                tRead = pIn.read(tBuff);
            }
            pLogger.debug((CharSequence)("File copied to " + pDestFile));
            pLogger.debug((CharSequence)("File exist " + pDestFile.exists()));
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("File doesn't exist", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write into file...", (Exception)e);
        }
        finally {
            try {
                if (tOut != null) {
                    tOut.close();
                }
                if (pIn != null) {
                    pIn.close();
                }
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to close report file report...", (Exception)e);
            }
        }
    }

    File getFitnesseReportDir() throws MavenReportException {
        File tExecutionFile;
        if (this.fitnesseOutputDirectory != null) {
            this.getLog().info((CharSequence)("Using the specified fitnesse outpout directory " + this.fitnesseOutputDirectory));
            tExecutionFile = this.fitnesseOutputDirectory;
        } else {
            this.getLog().debug((CharSequence)"Trying to find the fitnesse default dir...");
            tExecutionFile = new File(this.workingDir + "/fitnesse");
            if (!tExecutionFile.exists()) {
                this.getLog().info((CharSequence)("Fitnesse default report not found, " + tExecutionFile));
                this.getLog().debug((CharSequence)"Trying to find the fitnesse with clover dir...");
                tExecutionFile = new File(this.workingDir + "/clover/fitnesse");
            }
        }
        FilenameFilter filterSvnDirectory = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.equals(".svn");
            }
        };
        if (!tExecutionFile.exists() || !tExecutionFile.isDirectory() || tExecutionFile.list(filterSvnDirectory).length == 0) {
            String tError = "Can't find any report in the following folder: [" + this.fitnesseOutputDirectory.getAbsolutePath() + "], [" + new File(this.workingDir + "/fitnesse").getAbsolutePath() + "] or [" + tExecutionFile.getAbsolutePath() + "]";
            throw new MavenReportException(tError);
        }
        return tExecutionFile;
    }

    void createIndex() throws MavenReportException {
        if (this.outputDirectory.listFiles().length > 1) {
            File tIndex = new File(this.xmlOutputDirectory + "/index.xml");
            OutputStreamWriter tWriter = null;
            int tNbPage = 0;
            try {
                tIndex.createNewFile();
                tWriter = new FileWriter(tIndex);
                tWriter.write("<document>\n");
                tWriter.write(" <properties>\n");
                tWriter.write("   <title>maven-fitnesse-plugin - execution report</title>\n");
                tWriter.write(" </properties>\n");
                tWriter.write(" <body>\n");
                tWriter.write("<section name=\"List of the Fitnesse Pages:\">\n");
                tWriter.write("<ul>\n");
                File[] tFileArray = this.outputDirectory.listFiles();
                for (int i = 0; i < tFileArray.length; ++i) {
                    FitnessePage curChil = new FitnessePage(tFileArray[i]);
                    if (!curChil.isFitnessePageResult()) continue;
                    tWriter.write("<li><a href=\"" + curChil.getName() + "\">" + curChil.getFitnessePageName() + ".html</a></li>\n");
                    ++tNbPage;
                }
                tWriter.write("</ul>\n");
                tWriter.write("</section>\n");
                tWriter.write("</body>\n");
                tWriter.write("</document>\n");
                tWriter.flush();
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to create index file " + tIndex.getAbsolutePath(), (Exception)e);
            }
            finally {
                if (tWriter != null) {
                    try {
                        tWriter.close();
                    }
                    catch (IOException e) {
                        throw new MavenReportException("Unable to close index file " + tIndex.getAbsolutePath(), (Exception)e);
                    }
                }
            }
            if (tNbPage == 1) {
                tIndex.delete();
            }
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return "Fitnesse report";
    }

    public String getName(Locale locale) {
        return "Fitnesse report";
    }

    public String getOutputName() {
        FitnessePage curChild = null;
        FitnessePage tGoodFile = null;
        try {
            File tDir = this.getFitnesseReportDir();
            String[] tChildren = tDir.list();
            int tNbPage = 0;
            for (int i = 0; i < tChildren.length; ++i) {
                curChild = new FitnessePage(new File(tChildren[i]));
                if (!curChild.isFitnessePageResult()) continue;
                ++tNbPage;
                tGoodFile = curChild;
            }
            if (tNbPage == 1) {
                return "fitnesse/fitnesseResult_" + tGoodFile.getFitnessePageName();
            }
            return "fitnesse/index";
        }
        catch (MavenReportException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isExternalReport() {
        return true;
    }

    void setWorkingDir(File pWorkingDir) {
        this.workingDir = pWorkingDir;
    }

    void setFitnesseOutputDirectory(File pFitnesseOutputDirectory) {
        this.fitnesseOutputDirectory = pFitnesseOutputDirectory;
    }

    void setOutputDirectory(File pOutputDirectory) {
        this.outputDirectory = pOutputDirectory;
    }

    public void setXmlOutputDirectory(File xmlOutputDirectory) {
        this.xmlOutputDirectory = xmlOutputDirectory;
    }
}

