/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.AbstractResolveDependencies;
import org.codehaus.mojo.enforcer.Dependency;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanDuplicateClasses
extends AbstractResolveDependencies {
    private static final String[] DEFAULT_CLASSES_IGNORES = new String[]{"module-info", "META-INF/versions/*/module-info"};
    private String message;
    private String[] ignoreClasses;
    private boolean findAllDuplicates;
    private List<Dependency> dependencies;
    private List<String> scopes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        ArrayList<AbstractResolveDependencies.IgnorableDependency> ignorableDependencies = new ArrayList<AbstractResolveDependencies.IgnorableDependency>();
        AbstractResolveDependencies.IgnorableDependency ignoreableClasses = new AbstractResolveDependencies.IgnorableDependency(this);
        ignoreableClasses.applyIgnoreClasses(DEFAULT_CLASSES_IGNORES, false);
        if (this.ignoreClasses != null) {
            ignoreableClasses.applyIgnoreClasses(this.ignoreClasses, false);
        }
        ignorableDependencies.add(ignoreableClasses);
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                this.getLog().info((CharSequence)("Adding ignorable dependency: " + dependency));
                AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency(this);
                if (dependency.getGroupId() != null) {
                    ignorableDependency.groupId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getGroupId()));
                }
                if (dependency.getArtifactId() != null) {
                    ignorableDependency.artifactId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getArtifactId()));
                }
                if (dependency.getType() != null) {
                    ignorableDependency.type = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getType()));
                }
                if (dependency.getClassifier() != null) {
                    ignorableDependency.classifier = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getClassifier()));
                }
                ignorableDependency.applyIgnoreClasses(dependency.getIgnoreClasses(), true);
                ignorableDependencies.add(ignorableDependency);
            }
        }
        HashMap<String, Artifact> classNames = new HashMap<String, Artifact>();
        HashMap<String, Set<Artifact>> duplicates = new HashMap<String, Set<Artifact>>();
        for (Artifact artifact : artifacts) {
            if (this.scopes != null && !this.scopes.contains(artifact.getScope())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping " + artifact.toString() + " due to scope"));
                continue;
            }
            File file = artifact.getFile();
            this.getLog().debug((CharSequence)("Searching for duplicate classes in " + file));
            if (file == null || !file.exists()) {
                this.getLog().warn((CharSequence)("Could not find " + artifact + " at " + file));
                continue;
            }
            if (file.isDirectory()) {
                try {
                    for (String name : FileUtils.getFileNames((File)file, null, null, (boolean)false)) {
                        this.getLog().debug((CharSequence)("  " + name));
                        this.checkAndAddName(artifact, name, classNames, duplicates, ignorableDependencies);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Unable to process dependency " + artifact.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (!file.isFile() || !"jar".equals(artifact.getType())) continue;
            try {
                JarFile jar = new JarFile(file);
                try {
                    for (JarEntry entry : Collections.list(jar.entries())) {
                        this.checkAndAddName(artifact, entry.getName(), classNames, duplicates, ignorableDependencies);
                    }
                }
                finally {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                throw new EnforcerRuleException("Unable to process dependency " + artifact.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
            }
        }
        if (!duplicates.isEmpty()) {
            HashMap inverted = new HashMap();
            for (Map.Entry entry : duplicates.entrySet()) {
                ArrayList s = (ArrayList)inverted.get(entry.getValue());
                if (s == null) {
                    s = new ArrayList();
                }
                s.add(entry.getKey());
                inverted.put(entry.getValue(), s);
            }
            StringBuilder stringBuilder = new StringBuilder(this.message == null ? "Duplicate classes found:" : this.message);
            stringBuilder.append('\n');
            for (Map.Entry entry : inverted.entrySet()) {
                stringBuilder.append("\n  Found in:");
                for (Artifact a : (Set)entry.getKey()) {
                    stringBuilder.append("\n    ");
                    stringBuilder.append(a);
                }
                stringBuilder.append("\n  Duplicate classes:");
                for (String className : (List)entry.getValue()) {
                    stringBuilder.append("\n    ");
                    stringBuilder.append(className);
                }
                stringBuilder.append('\n');
            }
            throw new EnforcerRuleException(stringBuilder.toString());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void checkAndAddName(Artifact artifact, String name, Map<String, Artifact> classNames, Map<String, Set<Artifact>> duplicates, Collection<AbstractResolveDependencies.IgnorableDependency> ignores) throws EnforcerRuleException {
        if (!name.endsWith(".class")) {
            return;
        }
        for (AbstractResolveDependencies.IgnorableDependency ignorableDependency : ignores) {
            if (!ignorableDependency.matchesArtifact(artifact) || !ignorableDependency.matches(name)) continue;
            if (!classNames.containsKey(name)) return;
            this.getLog().debug((CharSequence)("Ignoring excluded class " + name));
            return;
        }
        if (!classNames.containsKey(name)) {
            classNames.put(name, artifact);
            return;
        }
        Artifact dup = classNames.put(name, artifact);
        if (!this.findAllDuplicates || !duplicates.containsKey(name)) {
            for (AbstractResolveDependencies.IgnorableDependency c : ignores) {
                if (!c.matchesArtifact(artifact) || !c.matches(name)) continue;
                this.getLog().debug((CharSequence)("Ignoring duplicate class " + name));
                return;
            }
        }
        if (this.findAllDuplicates) {
            void var7_12;
            Set<Artifact> set = duplicates.get(name);
            if (set == null) {
                LinkedHashSet<Artifact> linkedHashSet = new LinkedHashSet<Artifact>();
                linkedHashSet.add(dup);
            }
            var7_12.add(artifact);
            duplicates.put(name, (Set<Artifact>)var7_12);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.message == null ? "Duplicate class found:" : this.message);
        stringBuilder.append('\n');
        stringBuilder.append("\n  Found in:");
        stringBuilder.append("\n    ");
        stringBuilder.append(dup);
        stringBuilder.append("\n    ");
        stringBuilder.append(artifact);
        stringBuilder.append("\n  Duplicate classes:");
        stringBuilder.append("\n    ");
        stringBuilder.append(name);
        stringBuilder.append('\n');
        stringBuilder.append("There may be others but <findAllDuplicates> was set to false, so failing fast");
        throw new EnforcerRuleException(stringBuilder.toString());
    }
}

