/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.castor;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.exolab.castor.tools.MappingTool;

public abstract class AbstractMappingMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean force;
    private File outputDirectory;
    private ClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.outputDirectory.mkdirs();
            this.getLog().info((CharSequence)("Generate mapping " + this.getMappingName() + " for class " + this.getClassName()));
            ClassLoader cl = this.getProjectClassLoader();
            MappingTool tool = new MappingTool();
            try {
                Class<?> internalContextClass = Class.forName("org.castor.xml.InternalContext");
                Class<?> backwardsCompatibilityClass = Class.forName("org.castor.xml.BackwardCompatibilityContext");
                Method setter = MappingTool.class.getMethod("setInternalContext", internalContextClass);
                if (setter != null) {
                    this.getLog().info((CharSequence)"About to invoke 'setInternalContext()' on org.exolab.castor.tools.MappingTool");
                    setter.invoke((Object)tool, backwardsCompatibilityClass.newInstance());
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            Class<?> clazz = cl.loadClass(this.getClassName());
            tool.addClass(clazz);
            File file = new File(this.outputDirectory, this.getMappingName().trim());
            if (file.exists() && !this.force) {
                this.getLog().info((CharSequence)(this.getMappingName() + " allready generated"));
                return;
            }
            FileWriter writer = new FileWriter(file);
            tool.write((Writer)writer);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate mapping for " + this.getClassName(), e);
        }
    }

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        if (this.projectClassLoader != null) {
            return this.projectClassLoader;
        }
        List compile = this.project.getCompileClasspathElements();
        URL[] urls = new URL[compile.size()];
        int i = 0;
        for (Object object : compile) {
            urls[i] = object instanceof Artifact ? ((Artifact)object).getFile().toURL() : new File((String)object).toURL();
            ++i;
        }
        ((Object)((Object)this)).getClass().getClassLoader();
        this.projectClassLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        return this.projectClassLoader;
    }

    protected abstract String getClassName();

    protected abstract String getMappingName();
}

