/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cassandra.Utils;

public class StopCassandraClusterMojo
extends AbstractMojo {
    private boolean skip;
    protected int stopPort;
    protected String stopKey;
    private String rpcAddress;
    protected int rpcPort;
    private int clusterSize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        if (this.stopPort <= 0) {
            throw new MojoExecutionException("Please specify a valid port");
        }
        if (this.stopKey == null) {
            throw new MojoExecutionException("Please specify a valid stopKey");
        }
        if (this.clusterSize < 1) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be at least 1");
        }
        if (this.clusterSize > 254) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be less than 254");
        }
        for (int node = 0; node < this.clusterSize; ++node) {
            Utils.stopCassandraServer("127.0.0." + (node + 1), this.rpcPort, "127.0.0." + (node + 1), this.stopPort, this.stopKey, this.getLog());
        }
    }
}

