/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.apt.CollectionUtils;
import org.codehaus.mojo.apt.ProcessMojo;

public class EclipseMojo
extends ProcessMojo {
    private File basedir;
    private ArtifactRepository localRepository;

    protected void executeImpl() throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().info((CharSequence)"Not executing apt eclipse goal as the project is not a Java classpath-capable package");
            return;
        }
        if (!this.isAptDefined()) {
            this.getLog().info((CharSequence)"Not executing apt eclipse goal, plugin is not configuret for this project.");
            return;
        }
        this.getLog().info((CharSequence)"Executing apt eclipse goal!");
        File prefs = new File(this.basedir, ".settings" + File.separator + "org.eclipse.jdt.apt.core.prefs");
        try {
            prefs.getParentFile().mkdirs();
            prefs.createNewFile();
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Can't create file: " + prefs.getPath());
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(prefs, "ISO-8859-1");
        }
        catch (FileNotFoundException exception) {
            throw new MojoExecutionException(null, (Exception)exception);
        }
        catch (UnsupportedEncodingException exception) {
            throw new MojoExecutionException(null, (Exception)exception);
        }
        out.println("#" + new Date());
        out.println("eclipse.preferences.version=1");
        out.println("org.eclipse.jdt.apt.aptEnabled=true");
        out.println("org.eclipse.jdt.apt.genSrcDir=" + this.getOutputDirectory().getPath());
        if (this.getOptions() != null) {
            for (String option : this.getOptions()) {
                out.println("org.eclipse.jdt.apt.processorOptions/" + option);
            }
        }
        out.close();
        File factorypathFile = new File(this.basedir, ".factorypath");
        try {
            prefs.createNewFile();
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Can't create file: " + factorypathFile.getPath());
        }
        try {
            out = new PrintWriter(factorypathFile, "UTF-8");
        }
        catch (FileNotFoundException exception) {
        }
        catch (UnsupportedEncodingException exception) {
            // empty catch block
        }
        String localRepo = null;
        try {
            localRepo = new File(this.localRepository.getBasedir()).getCanonicalPath();
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Local repository: " + this.localRepository.getBasedir() + " doesn't exists!");
        }
        out.println("<factorypath> ");
        for (String factorypathentry : this.getClasspathElements()) {
            String kind = "EXTJAR";
            if (factorypathentry.endsWith("tools.jar")) continue;
            try {
                String tmp = new File(factorypathentry).getCanonicalPath();
                if (tmp.startsWith(localRepo)) {
                    kind = "VARJAR";
                    factorypathentry = tmp.replace(localRepo, "");
                    factorypathentry = "M2_REPO" + factorypathentry.replace("\\", "/");
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
            String batchModeString = EclipseMojo.hasAnnotationProcessorFactory(factorypathentry) ? "true" : "false";
            out.println("    <factorypathentry kind=\"" + kind + "\" id=\"" + factorypathentry + "\" enabled=\"true\" runInBatchMode=\"" + batchModeString + "\"/>");
        }
        out.println("</factorypath> ");
        out.close();
    }

    protected File getOutputDirectory() {
        String path = super.getOutputDirectory().getPath();
        path = path.replace(this.getProject().getBasedir().getAbsolutePath(), "").replace("\\", "/");
        return new File(path);
    }

    private boolean isAptDefined() {
        Set<Artifact> pluginArtifacts = CollectionUtils.genericSet(this.getProject().getPluginArtifacts(), Artifact.class);
        for (Artifact artifact : pluginArtifacts) {
            if (!"apt-maven-plugin".equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotationProcessorFactory(String factorypathentry) {
        try {
            JarFile file;
            if (factorypathentry.endsWith("jar") && (file = new JarFile(factorypathentry)).getEntry("META-INF/services/com.sun.mirror.apt.AnnotationProcessorFactory") != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

