/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.mojo.animal_sniffer.maven.Signature;

public class CheckSignatureMojo
extends AbstractMojo {
    protected List classpathElements;
    protected File outputDirectory;
    protected Signature signature;
    protected String[] ignores;
    protected boolean ignoreDependencies;
    protected boolean skip;
    protected ArtifactResolver resolver;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Signature checking is skipped.");
            return;
        }
        try {
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(this.artifactFactory);
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            Set ignoredPackages = this.buildPackageList();
            if (this.ignores != null) {
                for (int i = 0; i < this.ignores.length; ++i) {
                    String ignore = this.ignores[i];
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)ignoredPackages.toString());
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)new MavenLogger(this.getLog()));
            signatureChecker.setCheckJars(false);
            signatureChecker.setSourcePath(Collections.singletonList(new File(this.project.getBuild().getSourceDirectory())));
            signatureChecker.process(this.outputDirectory);
            if (signatureChecker.isSignatureBroken()) {
                throw new MojoFailureException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
    }

    private Set buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder((Logger)new MavenLogger(this.getLog()));
        this.apply((ClassFileVisitor)plb);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v) throws IOException {
        v.process(this.outputDirectory);
        if (this.ignoreDependencies) {
            Iterator itr = this.classpathElements.iterator();
            while (itr.hasNext()) {
                String path = (String)itr.next();
                v.process(new File(path));
            }
        }
    }
}

