/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JDocDescriptor;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;

public final class JMethodSignature {
    private JModifiers modifiers = null;
    private JType returnType = null;
    private String name = null;
    private Map<String, JParameter> params = null;
    private JDocComment jdc = null;
    private List<JClass> exceptions = null;

    public JMethodSignature(String name, JType returnType) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this.jdc = new JDocComment();
        this.returnType = returnType;
        this.name = name;
        this.modifiers = new JModifiers();
        this.params = new LinkedHashMap<String, JParameter>(3);
        this.exceptions = new ArrayList<JClass>(1);
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        for (JClass jClass : this.exceptions) {
            if (!expClassName.equals(jClass.getName())) continue;
            return;
        }
        this.exceptions.add(exp);
        this.jdc.addDescriptor(JDocDescriptor.createExceptionDesc(expClassName, null));
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        if (parameter == null) {
            return;
        }
        String pName = parameter.getName();
        if (this.params.get(pName) != null) {
            StringBuilder err = new StringBuilder();
            err.append("A parameter already exists for this method, ");
            err.append(this.name);
            err.append(", with the name: ");
            err.append(pName);
            throw new IllegalArgumentException(err.toString());
        }
        this.params.put(pName, parameter);
        this.jdc.addDescriptor(JDocDescriptor.createParamDesc(pName, null));
    }

    public JClass[] getExceptions() {
        return this.exceptions.toArray(new JClass[0]);
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public JParameter getParameter(int index) {
        Iterator<Map.Entry<String, JParameter>> paramIter = this.params.entrySet().iterator();
        Map.Entry<String, JParameter> selected = null;
        for (int i = 0; i <= index; ++i) {
            selected = paramIter.next();
        }
        return (JParameter)selected.getValue();
    }

    public synchronized JParameter[] getParameters() {
        return this.params.values().toArray(new JParameter[0]);
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public void setComment(String comment) {
        this.jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, true);
    }

    public void print(JSourceWriter jsw, boolean printJavaDoc) {
        if (printJavaDoc) {
            this.jdc.print(jsw);
        }
        jsw.write(this.modifiers.toString());
        if (this.modifiers.toString().length() > 0) {
            jsw.write(32);
        }
        if (this.returnType != null) {
            jsw.write(this.returnType);
        } else {
            jsw.write("void");
        }
        jsw.write(32);
        jsw.write(this.name);
        jsw.write(40);
        if (this.params.size() > 0) {
            jsw.write(32);
            Enumeration<JParameter> paramEnum = Collections.enumeration(this.params.values());
            jsw.write(paramEnum.nextElement());
            while (paramEnum.hasMoreElements()) {
                jsw.write(", ");
                jsw.write(paramEnum.nextElement());
            }
            jsw.write(32);
        }
        jsw.write(41);
        if (this.exceptions.size() > 0) {
            jsw.writeln();
            jsw.write("    throws ");
            for (int i = 0; i < this.exceptions.size(); ++i) {
                if (i > 0) {
                    jsw.write(", ");
                }
                JClass jClass = this.exceptions.get(i);
                jsw.write(jClass.getName());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.returnType != null) {
            sb.append(this.returnType);
        } else {
            sb.append("void");
        }
        sb.append(' ');
        sb.append(this.name);
        sb.append('(');
        if (this.params.size() > 0) {
            sb.append(' ');
            Enumeration<JParameter> paramEnum = Collections.enumeration(this.params.values());
            sb.append(paramEnum.nextElement().getType().getName());
            while (paramEnum.hasMoreElements()) {
                sb.append(", ");
                sb.append(paramEnum.nextElement().getType().getName());
            }
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }

    protected String[] getParameterClassNames() {
        ArrayList<String> names = new ArrayList<String>(this.params.size());
        for (JParameter param : this.params.values()) {
            JType jType = param.getType();
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (jType.isPrimitive()) continue;
            JClass jclass = (JClass)jType;
            names.add(jclass.getName());
        }
        return names.toArray(new String[0]);
    }
}

