/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.modello.plugin.java.javasource.JComment;
import org.codehaus.modello.plugin.java.javasource.JDocDescriptor;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;

public class JDocComment {
    private List<JDocDescriptor> _descriptors = new ArrayList<JDocDescriptor>();
    private StringBuilder _comment = new StringBuilder();

    public void addDescriptor(JDocDescriptor jdesc) {
        if (jdesc == null) {
            return;
        }
        if (this._descriptors.size() == 0) {
            this._descriptors.add(jdesc);
            return;
        }
        for (int i = 0; i < this._descriptors.size(); ++i) {
            JDocDescriptor jdd = this._descriptors.get(i);
            short compare = jdesc.compareTo(jdd);
            switch (compare) {
                case 0: {
                    this._descriptors.add(i + 1, jdesc);
                    return;
                }
                case -1: {
                    this._descriptors.add(i, jdesc);
                    return;
                }
            }
        }
        this._descriptors.add(jdesc);
    }

    public void appendComment(String comment) {
        this._comment.append(comment);
    }

    public String getComment() {
        return this._comment.toString();
    }

    public Enumeration<JDocDescriptor> getDescriptors() {
        return Collections.enumeration(this._descriptors);
    }

    public int getLength() {
        return this._comment.length();
    }

    public JDocDescriptor getParamDescriptor(String name) {
        if (name == null) {
            return null;
        }
        for (JDocDescriptor jdd : this._descriptors) {
            if (jdd.getType() != 0 || !name.equals(jdd.getName())) continue;
            return jdd;
        }
        return null;
    }

    public void print(JSourceWriter jsw) {
        JComment jComment = new JComment(4);
        jComment.setComment(this._comment.toString());
        if (this._descriptors.size() > 0) {
            jComment.appendComment("\n");
        }
        for (int i = 0; i < this._descriptors.size(); ++i) {
            jComment.appendComment("\n");
            jComment.appendComment(this._descriptors.get(i).toString());
        }
        jComment.print(jsw);
    }

    public void setComment(String comment) {
        this._comment.setLength(0);
        this._comment.append(comment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        sb.append(" * ");
        sb.append(" */\n");
        return sb.toString();
    }
}

