/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner.jetty;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.codehaus.jstestrunner.TestResultProducer;
import org.codehaus.jstestrunner.jetty.JSTestResultHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class JSTestResultServer {
    private Server webServer;
    private JSTestResultHandler jsTestResultHandler;
    private Integer port;
    private String contextPath;
    private String[] resourceBases;
    private boolean initedWebServer = false;

    public JSTestResultHandler.JSTestResult getJsTestResult(URL url, TestResultProducer testResultProducer) {
        return this.jsTestResultHandler.getJsTestResult(url, testResultProducer, 30L, TimeUnit.SECONDS);
    }

    private void initWebServer() {
        this.webServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port.intValue());
        this.webServer.addConnector((Connector)connector);
        Handler[] handlers = new Handler[this.resourceBases.length + 1];
        int i = 0;
        for (String resourceBase : this.resourceBases) {
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setResourceBase(resourceBase);
            handlers[i++] = resourceHandler;
        }
        this.jsTestResultHandler = new JSTestResultHandler();
        handlers[i] = this.jsTestResultHandler;
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(handlers);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath(this.contextPath);
        contextHandler.setHandler((Handler)handlerList);
        this.webServer.setHandler((Handler)contextHandler);
    }

    @Resource
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Resource
    public void setPort(Integer port) {
        this.port = port;
    }

    @Resource
    public void setResourceBases(String[] resourceBases) {
        this.resourceBases = resourceBases;
    }

    public void start() throws Exception {
        if (!this.initedWebServer) {
            this.initWebServer();
            this.initedWebServer = true;
        }
        this.webServer.start();
    }

    public void stop() throws Exception {
        if (this.initedWebServer) {
            this.webServer.stop();
        }
    }
}

