/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.JsonWriteContext;
import org.codehaus.jackson.impl.DefaultPrettyPrinter;
import org.codehaus.jackson.impl.JsonWriteContextImpl;

public abstract class JsonGeneratorBase
extends JsonGenerator {
    protected int _features;
    protected JsonWriteContextImpl _writeContext;

    protected JsonGeneratorBase(int features) {
        this._features = features;
        this._writeContext = JsonWriteContextImpl.createRootContext();
    }

    public void enableFeature(JsonGenerator.Feature f) {
        this._features |= f.getMask();
    }

    public void disableFeature(JsonGenerator.Feature f) {
        this._features &= ~f.getMask();
    }

    public void setFeature(JsonGenerator.Feature f, boolean state) {
        if (state) {
            this.enableFeature(f);
        } else {
            this.disableFeature(f);
        }
    }

    public boolean isFeatureEnabled(JsonGenerator.Feature f) {
        return (this._features & f.getMask()) != 0;
    }

    public final void useDefaultPrettyPrinter() {
        this.setPrettyPrinter(new DefaultPrettyPrinter());
    }

    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            this.doWriteStartArray();
        }
    }

    protected abstract void doWriteStartArray() throws IOException, JsonGenerationException;

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            this.doWriteEndArray();
        }
        this._writeContext = this._writeContext.getParentImpl();
    }

    protected abstract void doWriteEndArray() throws IOException, JsonGenerationException;

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            this.doWriteStartObject();
        }
    }

    protected abstract void doWriteStartObject() throws IOException, JsonGenerationException;

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParentImpl();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            this.doWriteEndObject();
        }
    }

    protected abstract void doWriteEndObject() throws IOException, JsonGenerationException;

    public final void writeFieldName(String name) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.doWriteFieldName(name, status == 1);
    }

    public abstract void doWriteFieldName(String var1, boolean var2) throws IOException, JsonGenerationException;

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    protected abstract void _releaseBuffers();

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public final void copyCurrentEvent(JsonParser jp) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jp.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                this.writeString(jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength());
                break;
            }
            case VALUE_NUMBER_INT: {
                this.writeNumber(jp.getIntValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.writeNumber(jp.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            default: {
                this._cantHappen();
            }
        }
    }

    public final void copyCurrentStructure(JsonParser jp) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.FIELD_NAME) {
            this.writeFieldName(jp.getCurrentName());
            t = jp.nextToken();
        }
        switch (t) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jp);
            }
        }
    }

    protected abstract void _verifyValueWrite(String var1) throws IOException, JsonGenerationException;

    protected void _reportError(String msg) throws JsonGenerationException {
        throw new JsonGenerationException(msg);
    }

    protected void _cantHappen() {
        throw new RuntimeException("Internal error: should never end up through this code path");
    }
}

