/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.components.HeadLink;
import org.slf4j.Logger;

public class HeadLink {
    @Parameter(required=true)
    private ContextLink _context;
    @Parameter(required=true, defaultPrefix="literal")
    private String _href;
    @Parameter(required=true, defaultPrefix="literal")
    private String _rel;
    @Parameter(required=true, defaultPrefix="literal")
    private String _type;
    @Parameter
    private String _title;
    @Inject
    private Logger logger;
    @Inject
    private ComponentResources _resources;

    void beginRender(MarkupWriter writer) {
        Link link = this._resources.createEventLink("fileLink", new Object[]{this._href, this._type});
        writer.element("link", new Object[]{"href", link, "rel", this._rel, "type", this._type, "title", this._title});
        this._resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onFileLink(String href, String type) {
        if (StringUtils.isEmpty((String)href) || href.contains("..")) {
            return null;
        }
        File file = this._context.getFile(href);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Fichier inexistant : " + file.getAbsolutePath(), (Throwable)e);
        }
        return new FileStreamResponse(this, (InputStream)stream, type);
    }
}

