/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.services;

import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.ComponentSource;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.services.ServiceChoice;
import org.chorem.pollen.business.services.ServiceComment;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.business.services.ServiceUser;
import org.chorem.pollen.business.services.ServiceVote;
import org.chorem.pollen.ui.services.BackgroundWorker;
import org.chorem.pollen.ui.services.BackgroundWorkerImpl;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.services.ConfigurationImpl;
import org.chorem.pollen.ui.services.PollenShutdown;
import org.chorem.pollen.ui.services.PropertiesFileSymbolProvider;
import org.slf4j.Logger;

public class AppModule {
    private static final String CONFIGURATION_FILE = "pollen.properties";

    public static void bind(ServiceBinder binder) {
        binder.bind(ServiceAuth.class);
        binder.bind(ServiceComment.class);
        binder.bind(ServiceList.class);
        binder.bind(ServiceUser.class);
        binder.bind(ServicePoll.class);
        binder.bind(ServicePollAccount.class);
        binder.bind(ServiceResults.class);
        binder.bind(ServiceVote.class);
        binder.bind(ServiceChoice.class);
    }

    public static void contributeApplicationDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.supported-locales", (Object)"fr,en");
        configuration.add((Object)"tapestry.production-mode", (Object)"true");
        configuration.add((Object)"upload.filesize-max", (Object)"1048576");
        configuration.add((Object)"upload.requestsize-max", (Object)"10485760");
    }

    @EagerLoad
    public RegistryShutdownListener buildPollenShutdown(@InjectService(value="RegistryShutdownHub") RegistryShutdownHub hub) {
        PollenShutdown listener = new PollenShutdown();
        hub.addRegistryShutdownListener((RegistryShutdownListener)listener);
        return listener;
    }

    public static Configuration buildConfiguration() {
        return new ConfigurationImpl(CONFIGURATION_FILE);
    }

    @EagerLoad
    public static BackgroundWorker buildBackgroundWorker(ComponentSource componentSource, Configuration configuration, ServicePoll servicePoll) {
        Messages messages = componentSource.getPage("LocalMessages").getComponentResources().getMessages();
        return new BackgroundWorkerImpl(messages, configuration, servicePoll);
    }

    public PropertiesFileSymbolProvider buildConfigPropertiesFileSymbolProvider(Logger logger) {
        return new PropertiesFileSymbolProvider(logger, CONFIGURATION_FILE);
    }

    public static void contributeSymbolSource(OrderedConfiguration<SymbolProvider> configuration, @InjectService(value="ConfigPropertiesFileSymbolProvider") SymbolProvider configPropertiesFileSymbolProvider) {
        configuration.add("ConfigPropertiesFile", (Object)configPropertiesFileSymbolProvider, new String[]{"after:SystemProperties", "before:ApplicationDefaults"});
    }
}

