/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Mixins;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Select;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.json.JSONObject;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.components.ImageContextLink;
import org.chorem.pollen.ui.data.GenericSelectModel;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollHelper;
import org.chorem.pollen.ui.data.PollStep;
import org.chorem.pollen.ui.data.uio.DateChoiceUIO;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;
import org.chorem.pollen.ui.pages.poll.CreationValidation;
import org.chorem.pollen.ui.pages.poll.PollCreation;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.utils.FeedUtil;
import org.chorem.pollen.ui.utils.ImageUtil;
import org.chorem.pollen.ui.utils.UnitConverter;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/pollCreation.css"})
public class PollCreation {
    @Inject
    private Logger log;
    @Persist
    private PollStep step;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @SessionState
    @Property
    private String siteURL;
    private Date beginDateValidation;
    private Date beginChoiceDateValidation;
    @Component(parameters={"event=change", "onCompleteCallback=literal:onCompleteZoneUpdate"})
    @Mixins(value={"ck/OnEvent"})
    private Select listSelect;
    @InjectComponent
    private Zone pollCreationZone;
    @Property
    @Persist
    private PollDTO poll;
    @Persist
    private PollDTO oldPoll;
    private boolean oldPollExists = false;
    private boolean noStepSubmitSelected = false;
    @Persist
    private boolean addChoiceSelected;
    private int deleteGroupId = -1;
    @Persist
    private boolean uploadExceptionCatched;
    @Property
    @Persist
    private boolean choiceNbCheckBox;
    @Property
    @Persist
    private boolean notificationCheckBox;
    @Property
    @Persist
    private boolean reminderCheckBox;
    @Property
    @Persist
    private PreventRuleDTO notificationPreventRule;
    @Property
    @Persist
    private PreventRuleDTO reminderPreventRule;
    @Property
    @Persist
    private List<VotingListDTO> votingLists;
    @Property
    private VotingListDTO votingList;
    @Property
    private PollAccountDTO votingListPerson;
    @Property
    private int nbVotingListPersons = 5;
    @Persist
    private int currentList;
    @Property
    @Persist
    private GenericSelectModel<PersonListDTO> personLists;
    @Property
    private PersonListDTO personList;
    @Property
    private int nbChoices = 5;
    @Property
    private ChoiceDTO choice;
    @Property
    private DateChoiceUIO dateTypeChoice;
    @Property
    private ImageChoiceUIO imgTypeChoice;
    @Property
    @Persist
    private List<ChoiceDTO> choices;
    @Property
    @Persist
    private List<DateChoiceUIO> dateTypeChoices;
    @Property
    @Persist
    private List<ImageChoiceUIO> imgTypeChoices;
    @InjectComponent
    private ImageContextLink imgContext;
    @InjectComponent
    private ContextLink feedContext;
    @Component(id="pollCreationForm")
    private Form pollCreationForm;
    @Component(id="choicesCreationForm")
    private Form choicesCreationForm;
    @InjectPage
    private CreationValidation creationValidation;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private PropertyAccess _propertyAccess;
    @Inject
    private ComponentResources resources;
    @Component(id="feedback")
    private FeedBack feedback;
    @Inject
    @Symbol(value="upload.filesize-max")
    private int fileSizeMax;
    @Inject
    @Symbol(value="upload.requestsize-max")
    private int requestSizeMax;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Inject
    private Logger logger;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceList serviceList;

    @Log
    Object onSuccessFromPollCreationForm() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Step : " + this.step);
        }
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                this.adaptStepPoll();
                this.step = PollStep.OPTIONS;
                break;
            }
            case 2: {
                this.adaptStepOptions();
                if (this.isFreePoll()) {
                    this.step = PollStep.CHOICES;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            case 3: {
                if (this.deleteGroupId >= 0) {
                    this.votingLists.remove(this.deleteGroupId);
                }
                if (this.noStepSubmitSelected) break;
                this.step = PollStep.CHOICES;
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        if (this.step.equals((Object)PollStep.CHOICES)) {
            return this.choicesCreationForm;
        }
        return this.pollCreationForm;
    }

    @Log
    Object onSubmitFromPollCreationForm() {
        return this.pollCreationForm;
    }

    Object onSuccessFromChoicesCreationForm() {
        if (!this.addChoiceSelected) {
            if (!this.preparePoll()) {
                return this;
            }
            this.createPoll();
            this.creationValidation.setPoll(this.poll);
            return this.creationValidation;
        }
        return this;
    }

    Object onPrevious() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 2: {
                this.step = PollStep.POLL;
                break;
            }
            case 3: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 4: {
                if (this.isFreePoll()) {
                    this.step = PollStep.OPTIONS;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationForm;
    }

    void onValidateFromBeginDate(Date value) throws ValidationException {
        this.beginDateValidation = value;
        if (value != null && value.before(new Date())) {
            throw new ValidationException(this.messages.get("beginDate-validate"));
        }
    }

    void onValidateFromEndDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.before(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("endDate-validate"));
        }
    }

    void onValidateFromBeginChoiceDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        this.beginChoiceDateValidation = value;
        if (value != null && value.after(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("beginChoiceDate-validate"));
        }
    }

    void onValidateFromEndChoiceDate(Date value) throws ValidationException {
        if (this.beginChoiceDateValidation == null) {
            this.beginChoiceDateValidation = new Date();
        }
        if (value != null && value.before(this.beginChoiceDateValidation)) {
            throw new ValidationException(this.messages.get("endChoiceDate-validate"));
        }
    }

    void onValidateFormFromPollCreationForm() throws ValidationException {
        if (this.noStepSubmitSelected) {
            return;
        }
        if (this.step == PollStep.LISTS) {
            int nbListEqual = 0;
            int nbEqual = 0;
            int nbNotNull = 0;
            for (VotingListDTO list1 : this.votingLists) {
                for (VotingListDTO list2 : this.votingLists) {
                    if (!list1.getName().equals(list2.getName())) continue;
                    ++nbListEqual;
                }
            }
            if (nbListEqual > this.votingLists.size()) {
                throw new ValidationException(this.messages.get("lists-validate"));
            }
            for (VotingListDTO list1 : this.votingLists) {
                int nbLocalNotNull = 0;
                for (PollAccountDTO account1 : list1.getPollAccountDTOs()) {
                    if (account1.getVotingId() == null || account1.getVotingId() == "") continue;
                    ++nbNotNull;
                    ++nbLocalNotNull;
                    for (VotingListDTO list2 : this.votingLists) {
                        for (PollAccountDTO account2 : list2.getPollAccountDTOs()) {
                            if (account2.getVotingId() == null || account1.getVotingId() == "" || !account1.getVotingId().equals(account2.getVotingId())) continue;
                            ++nbEqual;
                        }
                    }
                }
                if (nbLocalNotNull != 0) continue;
                throw new ValidationException(this.messages.get("noList-validate"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Votants (equal/notNull) : " + nbEqual + "/" + nbNotNull);
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("list-validate"));
            }
        }
    }

    void onValidateFormFromChoicesCreationForm() throws ValidationException {
        int nbEqual = 0;
        int nbNotNull = 0;
        if (this.step == PollStep.CHOICES) {
            if (this.isTextChoices()) {
                for (ChoiceDTO choice1 : this.choices) {
                    if (choice1.getName() == null) continue;
                    ++nbNotNull;
                    for (ChoiceDTO choice2 : this.choices) {
                        if (choice2.getName() == null || !choice1.getName().equals(choice2.getName())) continue;
                        ++nbEqual;
                    }
                }
            } else if (this.isDateChoices()) {
                for (DateChoiceUIO choice1 : this.dateTypeChoices) {
                    if (choice1.getDate() == null) continue;
                    ++nbNotNull;
                    for (DateChoiceUIO choice2 : this.dateTypeChoices) {
                        if (choice2.getDate() == null || !choice1.getDate().equals(choice2.getDate())) continue;
                        ++nbEqual;
                    }
                }
            } else if (this.isImgChoices()) {
                for (ImageChoiceUIO choice1 : this.imgTypeChoices) {
                    if (choice1.getImg() == null) continue;
                    ++nbNotNull;
                    for (ImageChoiceUIO choice2 : this.imgTypeChoices) {
                        if (choice2.getImg() == null || !choice1.getImg().getFileName().equals(choice2.getImg().getFileName())) continue;
                        ++nbEqual;
                    }
                }
            }
            if (nbNotNull == 0) {
                throw new ValidationException(this.messages.get("noChoice-validate"));
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("choice-validate"));
            }
        }
    }

    Object onUploadException(FileUploadException e) {
        this.logger.error(e.getMessage());
        String fSize = UnitConverter.getFormattedFileSize((long)this.fileSizeMax);
        String rSize = UnitConverter.getFormattedFileSize((long)this.requestSizeMax);
        this.feedback.addError(this.messages.format("uploadError", new Object[]{fSize, rSize}));
        this.uploadExceptionCatched = true;
        return this;
    }

    private void adaptStepOptions() {
        if (this.poll.isAnonymous()) {
            this.poll.setAnonymousVoteAllowed(true);
        }
        if (this.poll.isContinuousResults()) {
            this.poll.setPublicResults(true);
        }
    }

    @Log
    private void adaptStepPoll() {
        if (this.isFreePoll()) {
            this.votingLists.clear();
        } else if (this.isRestrictedPoll() && this.votingLists.size() > 1) {
            for (int i = 1; i < this.votingLists.size(); ++i) {
                this.votingLists.remove(i);
            }
            this.currentList = 0;
        } else if (this.votingLists.isEmpty()) {
            this.votingList = new VotingListDTO();
            for (int i = 0; i < this.nbVotingListPersons; ++i) {
                this.votingList.getPollAccountDTOs().add(new PollAccountDTO());
            }
            this.votingLists.add(this.votingList);
            this.currentList = this.getVotingListIndex();
        }
        if (this.poll.getBeginDate() != null) {
            this.poll.setEndChoiceDate(this.poll.getBeginDate());
        }
    }

    @Log
    private boolean preparePoll() {
        if (this.userExists) {
            this.poll.setUserId(this.user.getId());
        }
        if (this.notificationCheckBox) {
            this.poll.getPreventRuleDTOs().add(this.notificationPreventRule);
        }
        if (this.reminderCheckBox) {
            this.poll.getPreventRuleDTOs().add(this.reminderPreventRule);
        }
        if (!this.isFreePoll()) {
            for (VotingListDTO list : this.votingLists) {
                Iterator it = list.getPollAccountDTOs().iterator();
                while (it.hasNext()) {
                    if (((PollAccountDTO)it.next()).getVotingId() != null) continue;
                    it.remove();
                }
            }
            this.poll.setVotingListDTOs(this.votingLists);
        }
        if (this.isTextChoices()) {
            for (ChoiceDTO choice : this.choices) {
                if (choice.getName() == null) continue;
                choice.setValidate(true);
                this.poll.getChoiceDTOs().add(choice);
            }
        } else if (this.isDateChoices()) {
            for (ChoiceDTO choice : this.dateTypeChoices) {
                if (choice.getDate() == null) continue;
                choice.setValidate(true);
                choice.setName(String.valueOf(choice.getDate().getTime()));
                this.poll.getChoiceDTOs().add(choice);
            }
        } else if (this.isImgChoices()) {
            for (ImageChoiceUIO imgChoice : this.imgTypeChoices) {
                if (imgChoice.getImg() == null) continue;
                this.logger.debug("Image: " + imgChoice.getImg().getFileName() + ", type: " + imgChoice.getImg().getContentType());
                if (imgChoice.getImg().getContentType().contains("image") || imgChoice.getImg().getContentType().contains("IMAGE")) {
                    imgChoice.setValidate(true);
                    imgChoice.setName(imgChoice.getImg().getFileName().replace(' ', '_'));
                    this.poll.getChoiceDTOs().add(imgChoice);
                    continue;
                }
                return false;
            }
        }
        if (this.poll.getBeginDate() == null) {
            this.poll.setBeginDate(new Date());
        }
        if (this.poll.isAnonymous()) {
            this.poll.setAnonymousVoteAllowed(true);
        }
        if (this.poll.isContinuousResults()) {
            this.poll.setPublicResults(true);
        }
        if (this.poll.getMaxChoiceNb() < 1 || this.poll.getMaxChoiceNb() > this.poll.getChoiceDTOs().size()) {
            this.poll.setMaxChoiceNb(this.poll.getChoiceDTOs().size());
        }
        return true;
    }

    private void createPoll() {
        this.poll.setId(this.servicePoll.createPoll(this.poll));
        if (this.poll.getId() != null) {
            if (this.poll.getChoiceType() == ChoiceType.IMAGE) {
                File dir = this.imgContext.getImageDir();
                ImageUtil.saveImages((List)this.imgTypeChoices, (File)dir);
            }
            this.poll = this.servicePoll.findPollById(this.poll.getId());
            this.addFeedEntry();
            this.sendMailNotification();
        }
    }

    private void addFeedEntry() {
        PollAccountDTO creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        File feedFile = this.feedContext.getFile(this.poll.getPollId());
        FeedUtil.createFeed((File)feedFile, (String)"atom_1.0", (String)this.messages.format("pollFeed_title", new Object[]{this.poll.getTitle()}), (String)this.siteURL, (String)this.messages.format("pollFeed_desc", new Object[]{this.poll.getDescription()}));
        FeedUtil.feedFeed((File)feedFile, (String)this.messages.format("pollFeed_createTitle", new Object[]{creator.getVotingId()}), (String)voteURL, (String)this.messages.get("pollFeed_createContent"));
    }

    private void sendMailNotification() {
        PollAccountDTO creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        String modifURL = this.siteURL + "poll/Modification/" + this.poll.getPollId() + ":" + creator.getAccountId();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        if (this.poll.getCreatorEmail() != null) {
            data.put("to", this.poll.getCreatorEmail());
            data.put("title", this.messages.format("creatorEmail_subject", new Object[]{this.poll.getTitle()}));
            data.put("msg", this.messages.format("creatorEmail_msg", new Object[]{this.poll.getTitle(), voteURL, modifURL}));
            PreventRuleManager.emailAction(data);
        }
        for (VotingListDTO list : this.poll.getVotingListDTOs()) {
            for (PollAccountDTO account : list.getPollAccountDTOs()) {
                if (account.getEmail() == null) continue;
                String accountVoteURL = voteURL + ":" + account.getAccountId();
                data.put("to", account.getEmail());
                data.put("title", this.messages.format("votingEmail_subject", new Object[]{this.poll.getTitle()}));
                data.put("msg", this.messages.format("votingEmail_msg", new Object[]{this.poll.getTitle(), account.getVotingId(), accountVoteURL}));
                PreventRuleManager.emailAction(data);
            }
        }
    }

    public String getChoiceDateDisplay() {
        return this.poll.isChoiceAddAllowed() ? "display: block;" : "display: none;";
    }

    public String getChoiceNbDisplay() {
        return this.choiceNbCheckBox ? "display: block;" : "display: none;";
    }

    public String getNotificationDisplay() {
        return this.notificationCheckBox ? "display: block;" : "display: none;";
    }

    public String getReminderDisplay() {
        return this.reminderCheckBox ? "display: block;" : "display: none;";
    }

    public int getVotingListIndex() {
        return this.votingLists.indexOf(this.votingList);
    }

    public int getVotingListNumber() {
        return this.votingLists.indexOf(this.votingList) + 1;
    }

    public String getStepLegend() {
        Integer index = this.step.getIndex();
        if (this.isFreePoll() && this.step == PollStep.CHOICES) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                return this.messages.format("pollLegend", new Object[]{index});
            }
            case 2: {
                return this.messages.format("optionsLegend", new Object[]{index});
            }
            case 3: {
                return this.messages.format("listsLegend", new Object[]{index});
            }
            case 4: {
                return this.messages.format("choicesLegend", new Object[]{index});
            }
        }
        return "";
    }

    public String getCurrentListClass() {
        if (this.votingLists.size() > 1 && this.getVotingListIndex() == this.currentList) {
            return "currentGroupDiv";
        }
        return "groupDiv";
    }

    public boolean isSeveralGroups() {
        return this.votingLists.size() > 1;
    }

    public boolean isInPoll() {
        return this.step == PollStep.POLL;
    }

    public boolean isInLists() {
        return this.step == PollStep.LISTS;
    }

    public boolean isInChoices() {
        return this.step == PollStep.CHOICES;
    }

    public boolean isInOptions() {
        return this.step == PollStep.OPTIONS;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.CONDORCET;
    }

    public boolean isNumberVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NUMBER;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextChoices() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateChoices() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImgChoices() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public JSONObject onChangeFromListSelect(String value) {
        if (!"".equals(value)) {
            this.personList = this.serviceList.findPersonListById(value);
            for (PollAccountDTO account : this.personList.getPollAccountDTOs()) {
                account.setId("");
                account.setPersonListId("");
            }
            ((VotingListDTO)this.votingLists.get(this.currentList)).setPollAccountDTOs(this.personList.getPollAccountDTOs());
        }
        return this.createParamsForCallback();
    }

    public JSONObject onChangeFromChoiceType(String value) {
        this.poll.setChoiceType(ChoiceType.valueOf((String)value));
        return this.createParamsForCallback();
    }

    private JSONObject createParamsForCallback() {
        JSONObject json = new JSONObject();
        Link link = this.resources.createEventLink("updatePollCreationZone", new Object[0]);
        json.put("link", (Object)link.toAbsoluteURI());
        json.put("zoneId", (Object)"pollCreationZone");
        return json;
    }

    public Object onUpdatePollCreationZone() {
        return this.pollCreationZone.getBody();
    }

    void onSelectedFromAddPerson(int i) {
        ((VotingListDTO)this.votingLists.get(i)).getPollAccountDTOs().add(new PollAccountDTO());
        this.noStepSubmitSelected = true;
    }

    void onSelectedFromAddGroup() {
        this.votingList = new VotingListDTO();
        for (int i = 0; i < this.nbVotingListPersons; ++i) {
            this.votingList.getPollAccountDTOs().add(new PollAccountDTO());
        }
        this.votingLists.add(this.votingList);
        this.currentList = this.getVotingListIndex();
        this.noStepSubmitSelected = true;
    }

    void onSelectedFromDeleteGroup(int i) {
        if (this.currentList == i) {
            this.currentList = this.votingLists.size() - 1;
        } else if (this.currentList > i) {
            --this.currentList;
        }
        this.deleteGroupId = i;
        this.noStepSubmitSelected = true;
    }

    void onSelectedFromEditGroup(int i) {
        this.currentList = i;
        this.noStepSubmitSelected = true;
    }

    void onSelectedFromAddChoice() {
        if (this.poll.getChoiceType() == ChoiceType.DATE) {
            this.dateTypeChoices.add(new DateChoiceUIO());
        } else if (this.poll.getChoiceType() == ChoiceType.IMAGE) {
            this.imgTypeChoices.add(new ImageChoiceUIO());
        } else {
            this.choices.add(new ChoiceDTO());
        }
        this.addChoiceSelected = true;
    }

    public boolean isPersonListsExists() {
        return this.personLists != null && !this.personLists.getList().isEmpty();
    }

    void onActivate(String id) {
        if (!(id == null || "".equals(id) || this.oldPoll != null && id.equals(this.oldPoll.getPollId()))) {
            this.oldPoll = this.servicePoll.findPollByPollId(id);
            if (this.oldPoll != null) {
                this.initWithExistingPoll(this.oldPoll);
                this.oldPoll = null;
                this.oldPollExists = true;
            }
        }
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        if (!(this.addChoiceSelected || this.uploadExceptionCatched || this.choicesCreationForm.getHasErrors())) {
            this.step = PollStep.POLL;
            if (!this.oldPollExists) {
                this.oldPoll = null;
                this.initPoll();
            }
            this.initPersonLists();
        }
        this.addChoiceSelected = false;
        this.uploadExceptionCatched = false;
    }

    private void initPoll() {
        this.poll = new PollDTO();
        if (this.userExists) {
            this.poll.setCreatorId(this.user.getLogin());
            this.poll.setCreatorEmail(this.user.getEmail());
        }
        this.notificationPreventRule = new PreventRuleDTO("vote", 0, true, "emailAction");
        this.reminderPreventRule = new PreventRuleDTO("rappel", 0, false, "emailAction");
        this.notificationCheckBox = false;
        this.reminderCheckBox = false;
        this.choiceNbCheckBox = false;
        this.choices = new ArrayList();
        this.dateTypeChoices = new ArrayList();
        this.imgTypeChoices = new ArrayList();
        for (int i = 0; i < this.nbChoices; ++i) {
            this.choices.add(new ChoiceDTO());
            this.dateTypeChoices.add(new DateChoiceUIO());
            this.imgTypeChoices.add(new ImageChoiceUIO());
        }
        this.votingLists = new ArrayList();
    }

    private void initWithExistingPoll(PollDTO oldPoll) {
        this.poll = PollHelper.getPoll((PollDTO)oldPoll);
        PollAccountDTO creator = this.servicePollAccount.findPollAccountById(oldPoll.getCreatorId());
        this.poll.setCreatorId(creator.getVotingId());
        this.poll.setCreatorEmail(creator.getEmail());
        this.notificationPreventRule = PollHelper.getNotificationPreventRule((PollDTO)oldPoll);
        this.notificationCheckBox = !"".equals(this.notificationPreventRule.getScope());
        this.reminderPreventRule = PollHelper.getReminderPreventRule((PollDTO)oldPoll);
        this.reminderCheckBox = !"".equals(this.reminderPreventRule.getScope());
        this.choices = PollHelper.getTextChoices((PollDTO)oldPoll);
        this.dateTypeChoices = PollHelper.getDateChoices((PollDTO)oldPoll);
        this.imgTypeChoices = PollHelper.getImageChoices((PollDTO)oldPoll);
        this.votingLists = PollHelper.getVotingLists((PollDTO)oldPoll);
    }

    private void initPersonLists() {
        if (this.userExists) {
            List _personLists = this.serviceList.findPersonListByUser(this.user.getId());
            this.personLists = new GenericSelectModel(_personLists, PersonListDTO.class, "name", "id", this._propertyAccess);
        }
    }
}

