package org.chorem.pollen.ui.filters;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.utils.ContextUtil;

/**
 * Filtre permettant de capturer les exceptions. Ce filtre capture les
 * exceptions sur les réponses du serveur.
 *
 * @author rannou
 * @version $Id: PollenExceptionsFilter.java 2731 2009-08-18 12:22:46Z nrannou $
 */
public final class PollenExceptionsFilter implements Filter {
    private FilterConfig filterConfig = null;

    /** log. */
    private static final Log log = LogFactory
            .getLog(PollenExceptionsFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    @Override
    public void destroy() {
        this.filterConfig = null;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
        if (filterConfig == null) {
            return;
        }

        // capture des exceptions
        try {
            chain.doFilter(request, response);
        } catch (Exception e) {

            if (log.isDebugEnabled()) {
                log.debug("Exception capturée", e);
            }

            // si la connexion est fermée, reconnexion et affichage d'un message
            ContextUtil.getInstance().buildContext();
        }
    }

}
