/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollAction;
import org.chorem.pollen.ui.data.PollStep;
import org.chorem.pollen.ui.pages.poll.ConfirmPoll;
import org.chorem.pollen.ui.pages.poll.ModificationValidation;
import org.chorem.pollen.ui.pages.poll.PollModification;
import org.chorem.pollen.ui.services.Configuration;

@IncludeStylesheet(value={"context:css/pollCreation.css"})
public class PollModification {
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    private String param;
    @Component(id="feedback")
    private FeedBack feedback;
    @Persist
    private PollStep step;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @SessionState
    @Property
    private String siteURL;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginChoiceDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField endDate;
    @Persist
    @Property
    private DateFormat dateFormat;
    @Inject
    private Locale currentLocale;
    @Property
    @Persist
    private PollDTO poll;
    @Property
    @Persist
    private PollAccountDTO creator;
    @Property
    private boolean userAllowed = false;
    private Date beginDateValidation;
    @InjectComponent
    private Zone pollCreationZone;
    @InjectPage
    private ConfirmPoll confirmPoll;
    @Property
    @Persist
    private boolean notificationCheckBox;
    @Property
    @Persist
    private PreventRuleDTO newRule;
    @Property
    private VotingListDTO votingList;
    @Property
    private PollAccountDTO votingListPerson;
    @Property
    private ChoiceDTO choice;
    @InjectPage
    private ModificationValidation modificationValidation;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceList serviceList;

    Object onSuccessFromPollCreationForm() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 2: {
                if (this.poll.isContinuousResults()) {
                    this.poll.setPublicResults(true);
                }
                if (this.isFreePoll()) {
                    this.step = PollStep.CHOICES;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            case 3: {
                this.step = PollStep.CHOICES;
                break;
            }
            case 4: {
                PreventRuleDTO oldRule = null;
                for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
                    if (!rule.getId().equals(this.newRule.getId())) continue;
                    oldRule = rule;
                }
                if (oldRule != null) {
                    this.poll.getPreventRuleDTOs().remove(oldRule);
                    if (this.notificationCheckBox) {
                        this.poll.getPreventRuleDTOs().add(this.newRule);
                    }
                } else if (this.notificationCheckBox) {
                    this.poll.getPreventRuleDTOs().add(this.newRule);
                }
                List modifiedAccounts = this.getModifiedAccounts();
                this.servicePollAccount.updatePollAccount(this.creator);
                for (VotingListDTO votingList : this.poll.getVotingListDTOs()) {
                    for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                        this.servicePollAccount.updatePollAccount(account);
                    }
                    this.serviceList.updateVotingList(votingList);
                }
                if (this.poll.isContinuousResults()) {
                    this.poll.setPublicResults(true);
                }
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    choice.setValidate(true);
                }
                this.servicePoll.updatePoll(this.poll);
                this.sendMailNotification(modifiedAccounts);
                this.step = PollStep.POLL;
                this.modificationValidation.setPoll(this.poll);
                return this.modificationValidation;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    Object onSubmitFromPollCreationForm() {
        return this.pollCreationZone.getBody();
    }

    Object onPrevious() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 2: {
                this.step = PollStep.POLL;
                break;
            }
            case 3: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 4: {
                if (this.isFreePoll()) {
                    this.step = PollStep.OPTIONS;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    void onValidateFromEndDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.before(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("endDate-validate"));
        }
    }

    void onValidateFromBeginChoiceDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.after(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("beginChoiceDate-validate"));
        }
    }

    void onValidateFormFromPollCreationForm() throws ValidationException {
        if (this.step == PollStep.LISTS) {
            List votingLists = this.poll.getVotingListDTOs();
            int nbListEqual = 0;
            int nbEqual = 0;
            int nbNotNull = 0;
            for (VotingListDTO list1 : votingLists) {
                for (VotingListDTO list2 : votingLists) {
                    if (!list1.getName().equals(list2.getName())) continue;
                    ++nbListEqual;
                }
            }
            if (nbListEqual > votingLists.size()) {
                throw new ValidationException(this.messages.get("lists-validate"));
            }
            for (VotingListDTO list1 : votingLists) {
                int nbLocalNotNull = 0;
                for (PollAccountDTO account1 : list1.getPollAccountDTOs()) {
                    if (account1.getVotingId() == null || account1.getVotingId() == "") continue;
                    ++nbNotNull;
                    ++nbLocalNotNull;
                    for (VotingListDTO list2 : votingLists) {
                        for (PollAccountDTO account2 : list2.getPollAccountDTOs()) {
                            if (account2.getVotingId() == null || account1.getVotingId() == "" || !account1.getVotingId().equals(account2.getVotingId())) continue;
                            ++nbEqual;
                        }
                    }
                }
                if (nbLocalNotNull != 0) continue;
                throw new ValidationException(this.messages.get("noList-validate"));
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("list-validate"));
            }
        }
    }

    Object onActionFromCloseButton() {
        String backPage = "poll/modification";
        this.confirmPoll.setBackPage(backPage);
        this.confirmPoll.setAction(PollAction.CLOSE);
        this.confirmPoll.setPoll(this.poll);
        return this.confirmPoll;
    }

    public String getChoiceDateDisplay() {
        return this.poll.isChoiceAddAllowed() ? "display: block;" : "display: none;";
    }

    public String getNotificationDisplay() {
        return this.notificationCheckBox ? "display: block;" : "display: none;";
    }

    public Date getChoiceNameAsDate() {
        return new Date(Long.valueOf(this.choice.getName()));
    }

    public int getWeightAsInt() {
        return (int)this.votingList.getWeight();
    }

    public int getVotingListNumber() {
        return this.poll.getVotingListDTOs().indexOf(this.votingList) + 1;
    }

    public String getStepLegend() {
        Integer index = this.step.getIndex();
        if (this.poll.getPollType() == PollType.FREE && this.step == PollStep.CHOICES) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                return this.messages.format("pollLegend", new Object[]{index});
            }
            case 2: {
                return this.messages.format("optionsLegend", new Object[]{index});
            }
            case 3: {
                return this.messages.format("listsLegend", new Object[]{index});
            }
            case 4: {
                return this.messages.format("choicesLegend", new Object[]{index});
            }
        }
        return "";
    }

    public boolean isInPoll() {
        return this.step == PollStep.POLL;
    }

    public boolean isInLists() {
        return this.step == PollStep.LISTS;
    }

    public boolean isInChoices() {
        return this.step == PollStep.CHOICES;
    }

    public boolean isInOptions() {
        return this.step == PollStep.OPTIONS;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextChoices() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateChoices() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImgChoices() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    private void sendMailNotification(List<PollAccountDTO> modifiedAccounts) {
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        for (PollAccountDTO account : modifiedAccounts) {
            if (account.getEmail() == null) continue;
            String accountVoteURL = voteURL + ":" + account.getAccountId();
            data.put("to", account.getEmail());
            data.put("title", this.messages.format("votingEmail_subject", new Object[]{this.poll.getTitle()}));
            data.put("msg", this.messages.format("votingEmail_msg", new Object[]{this.poll.getTitle(), account.getVotingId(), accountVoteURL}));
            PreventRuleManager.emailAction(data);
        }
    }

    private List<PollAccountDTO> getModifiedAccounts() {
        ArrayList<PollAccountDTO> modifiedAccounts = new ArrayList<PollAccountDTO>();
        for (VotingListDTO list : this.poll.getVotingListDTOs()) {
            for (PollAccountDTO newAccount : list.getPollAccountDTOs()) {
                PollAccountDTO oldAccount = this.servicePollAccount.findPollAccountById(newAccount.getId());
                if (oldAccount.getEmail() == null && newAccount.getEmail() != null) {
                    modifiedAccounts.add(newAccount);
                    continue;
                }
                if (oldAccount.getEmail() == null || newAccount.getEmail() == null || newAccount.getVotingId().equals(oldAccount.getVotingId()) && newAccount.getEmail().equals(oldAccount.getEmail())) continue;
                modifiedAccounts.add(newAccount);
            }
        }
        return modifiedAccounts;
    }

    void onActivate(String id) {
        this.param = id;
        if (id != null && !"".equals(id)) {
            String pollId = id.split(":", 2)[0];
            if (this.poll == null || !pollId.equals(this.poll.getPollId())) {
                this.poll = this.servicePoll.findPollByPollId(pollId);
                this.creator = null;
                this.newRule = null;
            }
            if (this.poll != null) {
                String creatorId;
                if (this.creator == null) {
                    this.creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
                }
                if (id.split(":", 2).length == 2 && (creatorId = id.split(":", 2)[1]).equals(this.creator.getAccountId())) {
                    this.userAllowed = true;
                }
                if (this.newRule == null) {
                    this.initNotificationRule();
                }
            }
        }
        if (this.poll == null) {
            this.feedback.addError(this.messages.get("pollNotFound"));
        } else if (this.poll.isClosed()) {
            this.feedback.addError(this.messages.get("pollClosed"));
        } else if (!this.userAllowed) {
            this.feedback.addError(this.messages.get("userNotAllowed"));
        }
    }

    String onPassivate() {
        return this.param;
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.dateFormat = DateFormat.getDateTimeInstance(3, 3, this.currentLocale);
        if (this.poll != null) {
            this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
            this.creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
            this.initNotificationRule();
        }
        this.step = PollStep.POLL;
    }

    private void initNotificationRule() {
        this.notificationCheckBox = false;
        this.newRule = new PreventRuleDTO("vote", 0, true, "emailAction");
        this.newRule.setPollId(this.poll.getId());
        for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
            if (!"vote".equals(rule.getScope())) continue;
            this.notificationCheckBox = true;
            this.newRule = rule;
        }
    }
}

