/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.TextField;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.chorem.pollen.business.ServiceComment;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.ServicePollAccount;
import org.chorem.pollen.business.ServiceResults;
import org.chorem.pollen.business.ServiceVote;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.uio.DateChoiceUIO;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;
import org.chorem.pollen.ui.pages.poll.ImageDisplay;
import org.chorem.pollen.ui.pages.poll.VoteForPoll;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.utils.ImageUtil;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/vote.css"})
public class VoteForPoll {
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Component(id="feedback")
    private FeedBack feedback;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @SessionState
    @Property
    private String siteURL;
    @Component
    private Form voteForm;
    @Component(id="pollAccountName")
    private TextField nameField;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField dateDTF;
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Property
    @Persist
    private PollDTO poll;
    @Property
    private VoteDTO vote;
    @Property
    private ChoiceDTO choiceOfPoll;
    @Property
    private ChoiceDTO choiceOfVote;
    @Persist
    private List<ResultDTO> results;
    @Property
    @Retain
    private BeanModel voteModel;
    @InjectPage
    private ImageDisplay imageDisplay;
    @InjectComponent
    private Zone pollZone;
    @InjectComponent
    private Zone commentZone;
    @Property
    private EvenOdd evenOdd = new EvenOdd();
    private boolean addChoice;
    private boolean alreadyVoted;
    private List<ChoiceDTO> voteChoices = new ArrayList();
    @Property
    @Persist
    private PollAccountDTO pollAccount;
    @Property
    @Persist
    private ChoiceDTO newChoice;
    @Property
    @Persist
    private DateChoiceUIO newDateChoice;
    @Property
    @Persist
    private ImageChoiceUIO newImageChoice;
    @Property
    @Persist
    private CommentDTO comment;
    @Property
    @Persist
    private CommentDTO newComment;
    @Parameter(defaultPrefix="message", value="yourName")
    private String yourName;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServiceVote serviceVote;
    @Inject
    private ServiceComment serviceComment;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceResults serviceResults;

    void updatePoll(String id) {
        if (id != null && !id.equals("")) {
            this.poll = this.servicePoll.findPollByPollId(id);
        }
    }

    Object onSuccessFromVoteForm() {
        if (this.initPollAccount()) {
            ArrayList<ChoiceDTO> choiceDTOs = new ArrayList<ChoiceDTO>();
            if (this.poll.getVoteCounting() == VoteCountingType.NORMAL) {
                int nbChoices = 0;
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    if (choice.getValue() == 1) {
                        ++nbChoices;
                    }
                    choiceDTOs.add(choice);
                }
                if (nbChoices > this.poll.getMaxChoiceNb()) {
                    this.voteForm.recordError(this.messages.format("tooManyChoices", new Object[]{this.poll.getMaxChoiceNb()}));
                    return this.pollZone.getBody();
                }
            } else if (this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE) {
                int total = 0;
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    total += choice.getValue();
                    choiceDTOs.add(choice);
                }
                if (total != 100) {
                    this.voteForm.recordError(this.messages.get("not100percent"));
                    return this.pollZone.getBody();
                }
            } else if (this.poll.getVoteCounting() == VoteCountingType.CONDORCET) {
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    if (choice.getValue() == 0) {
                        choice.setValue(100);
                    }
                    choiceDTOs.add(choice);
                }
            }
            VoteDTO vote = new VoteDTO(null, this.poll.getId(), null);
            vote.setChoiceDTOs(choiceDTOs);
            vote.setWeight(this.pollAccount.getWeight());
            if (this.alreadyVoted) {
                for (VoteDTO v : this.poll.getVoteDTOs()) {
                    PollAccountDTO voteAccount = this.servicePollAccount.findPollAccountById(v.getPollAccountId());
                    if (!voteAccount.getVotingId().equals(this.pollAccount.getVotingId())) continue;
                    vote.setId(v.getId());
                    this.serviceVote.deleteVote(vote);
                    this.serviceVote.createVote(vote, this.pollAccount);
                }
            } else {
                this.serviceVote.createVote(vote, this.pollAccount);
            }
            this.updatePoll(this.poll.getPollId());
            if (this.poll.isContinuousResults()) {
                this.results = this.serviceResults.getAllResults(this.poll.getPollId());
            }
            this.sendMailNotification();
        }
        this.voteChoices.clear();
        return this.pollZone.getBody();
    }

    Object onActionFromEditVote(String votingId) {
        this.pollAccount.setVotingId(votingId);
        return this.pollZone.getBody();
    }

    private boolean initPollAccount() {
        this.alreadyVoted = false;
        boolean userIdMatching = false;
        boolean anonymousForbidden = false;
        boolean restrictedListsForbidden = false;
        if (this.poll.getPollType() != PollType.FREE) {
            restrictedListsForbidden = true;
            for (VotingListDTO list : this.poll.getVotingListDTOs()) {
                for (PollAccountDTO account : list.getPollAccountDTOs()) {
                    if (!this.pollAccount.getVotingId().equals(account.getVotingId())) continue;
                    restrictedListsForbidden = false;
                    this.pollAccount = this.servicePollAccount.findPollAccountById(account.getId());
                    this.pollAccount.setVotingListId(list.getId());
                    this.pollAccount.setWeight(account.getWeight());
                    this.logger.debug("Compte \"" + account.getVotingId() + "\" pr\u00e9sent dans la liste \"" + list.getName() + "\" (poids=" + account.getWeight() + ")");
                }
            }
            if (restrictedListsForbidden) {
                this.voteForm.recordError((Field)this.nameField, this.messages.format("restrictedListsForbidden", new Object[]{this.pollAccount.getVotingId()}));
            }
        }
        if (this.userExists) {
            this.pollAccount.setUserId(this.user.getId());
        } else {
            this.pollAccount.setUserId("");
        }
        if (this.isVoteAnonymous()) {
            if (this.poll.isAnonymousVoteAllowed()) {
                this.pollAccount.setVotingId("anonymous" + UUID.randomUUID().toString().replaceAll("-", ""));
            } else {
                anonymousForbidden = true;
                this.voteForm.recordError((Field)this.nameField, this.messages.get("anonymousForbidden"));
            }
        } else {
            this.alreadyVoted = this.hasAlreadyVoted(this.pollAccount.getVotingId());
            userIdMatching = this.isUserIdMatching(this.pollAccount.getVotingId());
            if (this.alreadyVoted && !userIdMatching) {
                this.voteForm.recordError((Field)this.nameField, this.messages.format("alreadyVoted", new Object[]{this.pollAccount.getVotingId()}));
            }
        }
        this.logger.debug("alreadyVoted: " + this.alreadyVoted);
        this.logger.debug("userIdMatching: " + userIdMatching);
        this.logger.debug("anonymousForbidden: " + anonymousForbidden);
        this.logger.debug("restrictedListsForbidden: " + restrictedListsForbidden);
        return (!this.alreadyVoted || userIdMatching) && !anonymousForbidden && !restrictedListsForbidden;
    }

    private boolean hasAlreadyVoted(String votingId) {
        for (VoteDTO vote : this.poll.getVoteDTOs()) {
            PollAccountDTO account = this.servicePollAccount.findPollAccountById(vote.getPollAccountId());
            if (!account.getVotingId().equals(votingId)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserIdMatching(String votingId) {
        boolean userIdMatching = false;
        for (int i = 0; i < this.poll.getVoteDTOs().size() && !userIdMatching; ++i) {
            String id = ((VoteDTO)this.poll.getVoteDTOs().get(i)).getPollAccountId();
            PollAccountDTO account = this.servicePollAccount.findPollAccountById(id);
            if (!account.getVotingId().equals(votingId) || !this.userExists || this.user.getId().length() <= 0) continue;
            userIdMatching = this.user.getId().equals(account.getUserId());
        }
        return userIdMatching;
    }

    private void sendMailNotification() {
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        String modifURL = this.siteURL + "poll/Modification/" + this.poll.getPollId() + ":" + MD5.encode((String)this.poll.getCreatorId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        data.put("to", this.poll.getCreatorEmail());
        data.put("title", this.messages.format("voteEmail_subject", new Object[]{this.poll.getTitle()}));
        data.put("msg", this.messages.format("voteEmail_msg", new Object[]{this.poll.getTitle(), this.poll.getVoteDTOs().size(), voteURL, modifURL}));
        for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
            PreventRuleManager manager = new PreventRuleManager(rule);
            manager.execute("vote", Integer.valueOf(this.poll.getVoteDTOs().size()), data);
        }
    }

    public boolean isAddChoice() {
        return this.addChoice;
    }

    public void setAddChoice(boolean addChoice) {
        this.choiceOfVote.setValue(addChoice ? 1 : 0);
    }

    public Boolean isChoiceInVote(ChoiceDTO choice) {
        if (choice != null) {
            switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCounting().ordinal()]) {
                case 1: {
                    return choice.getValue() > 0;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return choice.getValue() < 100;
                }
            }
        }
        return null;
    }

    public ChoiceDTO getCurrentVoteChoice() {
        for (ChoiceDTO choice : this.vote.getChoiceDTOs()) {
            if (!choice.getId().equals(this.choiceOfPoll.getId())) continue;
            return choice;
        }
        return null;
    }

    public String getCurrentChoiceResult() {
        String val = "";
        for (ResultDTO result : this.results) {
            if (!result.getName().equals(this.choiceOfPoll.getName()) || !(val = result.getValue()).endsWith(".0")) continue;
            val = val.substring(0, val.indexOf(46));
        }
        return val;
    }

    public boolean isVoteAnonymous() {
        return this.poll.isAnonymous() || this.pollAccount.getVotingId() == null || this.pollAccount.getVotingId().equals("") || this.pollAccount.getVotingId().equalsIgnoreCase(this.messages.get("anonymous"));
    }

    public boolean isCurrentVoteAnonymous() {
        return this.poll.isAnonymous() || this.getCurrentVotingId().startsWith("anonymous");
    }

    public String getCurrentVotingId() {
        String id = this.vote.getPollAccountId();
        String votingId = this.servicePollAccount.findPollAccountById(id).getVotingId();
        return votingId;
    }

    void onValidateFromTextName(String value) throws ValidationException {
        this.validateNewChoice(value);
    }

    void onValidateFromDateDTF(Date value) throws ValidationException {
        this.validateNewChoice(String.valueOf(value.getTime()));
    }

    void onValidateFromImgFile(UploadedFile value) throws ValidationException {
        this.validateNewChoice(value.getFileName().replace(' ', '_'));
    }

    private void validateNewChoice(String value) throws ValidationException {
        for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
            if (!value.equals(choice.getName())) continue;
            throw new ValidationException(this.messages.format("choiceExists", new Object[]{value}));
        }
    }

    Object onSuccessFromChoiceForm() {
        if (this.isTextType()) {
            if (this.newChoice.getName() != null) {
                this.newChoice.setValidate(true);
                this.newChoice.setPollId(this.poll.getId());
                this.poll.getChoiceDTOs().add(this.newChoice);
            }
        } else if (this.isDateType()) {
            if (this.newDateChoice.getDate() != null) {
                this.newDateChoice.setValidate(true);
                this.newDateChoice.setPollId(this.poll.getId());
                this.newDateChoice.setName(String.valueOf(this.newDateChoice.getDate().getTime()));
                this.poll.getChoiceDTOs().add(this.newDateChoice);
            }
        } else if (this.isImageType() && this.newImageChoice.getImg() != null) {
            this.newImageChoice.setValidate(true);
            this.newImageChoice.setPollId(this.poll.getId());
            this.newImageChoice.setName(this.newImageChoice.getImg().getFileName().replace(' ', '_'));
            this.poll.getChoiceDTOs().add(this.newImageChoice);
            ImageUtil.saveImage((ImageChoiceUIO)this.newImageChoice, (File)new File(this.conf.getProperty("upImgDir"), this.poll.getPollId()));
        }
        this.servicePoll.updatePoll(this.poll);
        this.updatePoll(this.poll.getPollId());
        this.newChoice = new ChoiceDTO();
        this.newDateChoice = new DateChoiceUIO();
        this.newImageChoice = new ImageChoiceUIO();
        return this;
    }

    Object onSuccessFromCommentForm() {
        this.newComment.setPollId(this.poll.getId());
        this.newComment.setPostDate(new Date());
        this.serviceComment.createComment(this.newComment);
        this.updatePoll(this.poll.getPollId());
        this.newComment = new CommentDTO();
        return this.commentZone.getBody();
    }

    public boolean isPollNull() {
        return this.poll == null;
    }

    public boolean isPollChoiceStarted() {
        Date now = new Date();
        return this.poll.getBeginChoiceDate() == null || this.poll.getBeginChoiceDate().before(now);
    }

    public boolean isPollStarted() {
        Date now = new Date();
        return this.poll.getBeginDate() == null || this.poll.getBeginDate().before(now);
    }

    public boolean isPollFinished() {
        Date now = new Date();
        return this.poll.getEndDate() != null && this.poll.getEndDate().before(now);
    }

    public boolean isPollChoiceOrVoteStarted() {
        return this.isPollChoiceStarted() || this.isPollStarted();
    }

    public boolean isPollChoiceRunning() {
        return this.poll.isChoiceAddAllowed() && this.isPollChoiceStarted() && !this.isPollStarted();
    }

    public boolean isPollRunning() {
        return this.isPollStarted() && !this.isPollFinished() && !this.poll.isClosed();
    }

    public boolean isDescNull() {
        return this.choiceOfPoll.getDescription() == null;
    }

    public boolean isAccountFieldDisplayed() {
        return !this.poll.isAnonymous() || this.isRestrictedPoll() || this.isGroupPoll();
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.CONDORCET;
    }

    public String getCreatorName() {
        PollAccountDTO pollAccount = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        return pollAccount.getVotingId();
    }

    public String getHelpMessage() {
        switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCounting().ordinal()]) {
            case 1: {
                return this.messages.get("normalVote-help");
            }
            case 2: {
                return this.messages.get("percentageVote-help");
            }
            case 3: {
                return this.messages.get("condorcetVote-help");
            }
        }
        return "";
    }

    public Date getChoiceNameAsDate() {
        return new Date(Long.valueOf(this.choiceOfPoll.getName()));
    }

    public String getChoiceImageSrc() {
        File dir = new File(this.conf.getProperty("upImgDir"), this.poll.getPollId());
        File file = new File(dir, this.choiceOfPoll.getName());
        return file.getAbsolutePath();
    }

    public String getChoiceThumbSrc() {
        File dir = new File(this.conf.getProperty("upImgDir"), this.poll.getPollId());
        File file = new File(dir, "thumb_" + this.choiceOfPoll.getName());
        return file.getAbsolutePath();
    }

    Object onDisplayImage(String choiceId) {
        this.imageDisplay.setPoll(this.poll);
        this.imageDisplay.setChoiceId(choiceId);
        this.imageDisplay.setPageStyle("Vote");
        return this.imageDisplay;
    }

    String onToClientFromCondorcetInput() {
        if (this.choiceOfVote.getValue() == 0) {
            return "";
        }
        return null;
    }

    void onActivate(String id) {
        this.pollAccount = new PollAccountDTO();
        if (this.userExists) {
            this.pollAccount.setVotingId(this.user.getFirstName() + " " + this.user.getLastName());
        } else {
            this.pollAccount.setVotingId(this.yourName);
        }
        this.updatePoll(id);
        if (this.poll != null) {
            if (this.poll.isContinuousResults()) {
                this.results = this.serviceResults.getAllResults(this.poll.getPollId());
            }
            this.newChoice = new ChoiceDTO();
            this.newDateChoice = new DateChoiceUIO();
            this.newImageChoice = new ImageChoiceUIO();
            this.newComment = new CommentDTO();
            this.newComment.setPollId(this.poll.getId());
        }
        if (this.poll == null) {
            this.feedback.addError(this.messages.get("pollNotFound"));
        } else if (this.poll.isClosed()) {
            this.feedback.addInfo(this.messages.get("pollClosed"));
        } else if (!this.isPollStarted()) {
            this.feedback.addInfo(this.messages.get("pollNotStarted"));
        } else if (this.isPollFinished()) {
            this.feedback.addInfo(this.messages.get("pollFinished"));
        }
        if (this.isPollChoiceRunning()) {
            this.feedback.addInfo(this.messages.get("pollChoiceRunning"));
        }
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
    }
}

