/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.admin;

import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

/**
 * To confirm a poll action (such as delete or close).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ConfirmPollAction extends PollenActionSupport implements PollenUserSecurityAware, PollUriAware {

    private static final long serialVersionUID = 1L;

    protected Poll poll;

    protected String redirectUrl;

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Poll getPoll() {
        return poll;
    }

    @Override
    public String execute() throws Exception {
        poll = getUserSecurityContext().getPoll();

        return SUCCESS;
    }

}
