/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteDao;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class VoterListMemberDao
extends AbstractPollenDao<VoterListMember> {
    @Override
    public Class<VoterListMember> getEntityClass() {
        return VoterListMember.class;
    }

    public void deleteFromParent(VoterListMember entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterListEquals(VoterList v) {
        return this.forEquals("voterList", v);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterListIdEquals(String voterListId) {
        return this.forProperties("voterList.topiaId", voterListId, new Object[0]);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forMemberEquals(PollenPrincipal v) {
        return this.forEquals("member", v);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollEquals(Poll poll) {
        return this.forProperties("voterList.poll", poll, new Object[0]);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollAndMember_EmailEquals(Poll poll, String email) {
        return this.forVoterList_PollEquals(poll).addEquals("member.email", email);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollIdEqualsAndMember_EmailEquals(String pollId, String email) {
        return this.forEquals("member.email", email).addEquals("voterList.poll.topiaId", pollId);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollIdEqualsAndMember_PollenUserEquals(String pollId, PollenUser user) {
        return this.forEquals("member.pollenUser", user).addEquals("voterList.poll.topiaId", pollId);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollEqualsAndMember_Invalid(Poll poll) {
        return this.forVoterList_PollEquals(poll).addEquals("member.invalid", true);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollEqualsAndInvitationSent(Poll poll) {
        return this.forVoterList_PollEquals(poll).addEquals("invitationSent", true);
    }

    public AddCriteriaOrRunQueryStep<VoterListMember> forVoterList_PollEqualsAndMemberIn(Poll poll, List<PollenPrincipal> pollenPrincipals) {
        return this.forVoterList_PollEquals(poll).addIn("member", pollenPrincipals);
    }

    @Override
    public void delete(VoterListMember entity) {
        VoteDao voteDao = this.daoSupplier.getVoteDao();
        Vote vote = (Vote)voteDao.forVoterListMemberContains(entity).findUniqueOrNull();
        if (vote != null) {
            vote.removeVoterListMember(entity);
            if (vote.isVoterListMemberEmpty()) {
                voteDao.delete(vote);
            }
        }
        this.deleteFromParent(entity);
    }

    public long countDistinctMembers(Poll poll, boolean invitationSent) {
        String hql = " select count(m.member.email) from " + VoterListMember.class.getCanonicalName() + " m  where m.voterList.poll = :p0";
        HashMap params = Maps.newHashMap();
        params.put("p0", poll);
        if (invitationSent) {
            hql = hql + " and m.invitationSent = :is0";
            params.put("is0", true);
        }
        return this.count(hql, params);
    }

    public boolean existsByPollAndMember(Poll poll, PollenPrincipal mainPrincipal) {
        return this.forProperties("voterList.poll", poll, new Object[0]).addEquals("member", mainPrincipal).exists();
    }

    public boolean existsByPollAndMember(Poll poll, PollenUser pollenUser) {
        return this.forProperties("voterList.poll", poll, new Object[0]).addEquals("member.pollenUser", pollenUser).exists();
    }

    public List<VoterListMember> findAllByMemberAndPoll(PollenPrincipal mainPrincipal, Poll poll) {
        return this.forMemberEquals(mainPrincipal).addEquals("voterList.poll", poll).findAll();
    }
}

