/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAOAbstract;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class VoteDAOImpl<E extends Vote>
extends VoteDAOAbstract<E> {
    public List<E> findAllVotes(Poll poll) throws TopiaException {
        Preconditions.checkNotNull((Object)poll);
        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE p = :p AND e IN ELEMENTS(p.vote) ORDER BY e.topiaCreateDate DESC";
        List result = this.findAllByQuery(hql, new Object[]{"p", poll});
        return result;
    }

    public List<E> findAllVotesByPoll(Poll poll, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)pager);
        String countHql = "SELECT COUNT(e) FROM VoteImpl e, PollImpl p WHERE p = :p AND e IN ELEMENTS(p.vote)";
        this.computeAndAddRecordsToPager(countHql, pager, new Object[]{"p", poll});
        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE p = :p AND e IN ELEMENTS(p.vote) ORDER BY e.topiaCreateDate DESC";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[]{"p", poll});
        return result;
    }

    public Vote findVoteByPollAndVotingId(Poll poll, String votingId) throws TopiaException {
        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE p = :p AND e in elements(p.vote) AND e.pollAccount.votingId = :v";
        Vote result = (Vote)this.findByQuery(Vote.class, hql, new Object[]{"p", poll, "v", votingId});
        return result;
    }

    public E findByAccountId(String accountId) throws TopiaException {
        String hql = "FROM VoteImpl e WHERE e.pollAccount.accountId = :a";
        Vote result = (Vote)this.findByQuery(hql, new Object[]{"a", accountId});
        return (E)result;
    }
}

