/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PersonListDAOImpl<E extends PersonList>
extends PersonListDAOAbstract<E> {
    public List<E> findFavoriteLists(UserAccount user, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)pager);
        String countHql = "SELECT COUNT(*) FROM PersonListImpl WHERE owner = :owner";
        this.computeAndAddRecordsToPager(countHql, pager, new Object[]{"owner", user});
        String hql = "FROM PersonListImpl e WHERE e.owner = :owner";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[]{"owner", user});
        return result;
    }

    public List<E> findAllFavoriteLists(UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        String hql = "FROM PersonListImpl WHERE owner = :owner";
        List result = this.findAllByQuery(hql, new Object[]{"owner", user});
        return result;
    }

    public boolean isPersonListExist(UserAccount user, String name) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name));
        String hql = "SELECT COUNT(*) FROM PersonListImpl WHERE owner = :owner AND name = :name";
        boolean result = this.existsByQuery(hql, new Object[]{"owner", user, "name", name});
        return result;
    }
}

