/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.json.JSONObject;
import org.chenillekit.tapestry.core.base.AbstractWindow;

public class Window
extends AbstractWindow {
    @Environmental
    private RenderSupport renderSupport;
    private boolean hasBody = false;

    @BeforeRenderBody
    void beforeRenderBody(MarkupWriter writer) {
        this.hasBody = true;
        writer.element("div", new Object[]{"id", this.getClientId() + "Content", "style", "display:none;"});
    }

    @AfterRenderBody
    void afterRenderBody(MarkupWriter writer) {
        writer.end();
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        JSONObject options = new JSONObject();
        options.put("className", (Object)this.getClassName());
        options.put("width", (Object)this.getWidth());
        options.put("height", (Object)this.getHeight());
        options.put("id", (Object)this.getClientId());
        options.put("title", (Object)this.getTitle());
        this.configure(options);
        this.renderSupport.addScript("%s = new Window(%s);", new Object[]{this.getClientId(), options});
        if (this.hasBody) {
            this.renderSupport.addScript("%s.setContent('%sContent');", new Object[]{this.getClientId(), this.getClientId()});
        }
        if (this.isShow()) {
            this.renderSupport.addScript("%s.show%s(%s);", new Object[]{this.getClientId(), this.isCenter() ? "Center" : "", this.isModal()});
        }
    }
}

