/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.EventLink;
import org.apache.tapestry5.corelib.components.Loop;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.Request;

@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "TabSet.js"})
@IncludeStylesheet(value={"TabSet.css"})
public class TabSet
implements ClientElement {
    private static String EVENT_NAME = "clicked";
    @Inject
    private ComponentResources resources;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="literal")
    private String update;
    @Parameter(required=true, defaultPrefix="list")
    private List<String> panelIds;
    @Parameter
    private String activePanelId;
    @Environmental
    private RenderSupport renderSupport;
    @Environmental
    private ClientBehaviorSupport clientBehaviorSupport;
    @Inject
    private Request request;
    @Component(parameters={"source=inherit:panelIds", "value=panelId"})
    private Loop tabLoop;
    @Component(parameters={"update=inherit:update"})
    private Zone contentZone;
    @Component(parameters={"event=clicked", "zone=contentZone", "context=panelId"})
    private EventLink eventLink;
    @Property
    private String panelId;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.renderSupport.allocateClientId(this.clientId);
        if (this.activePanelId == null) {
            this.activePanelId = this.panelIds.get(0);
        }
    }

    void afterRender(MarkupWriter writer) {
        this.renderSupport.addScript("new Ck.TabSet('%s', '%s');", new Object[]{this.getClientId() + "_panel", this.activePanelId});
    }

    public String getPanelTitle() {
        String panelTitle = this.panelId;
        if (this.resources.getContainerResources().getMessages().contains("label-" + this.panelId)) {
            panelTitle = this.resources.getContainerResources().getMessages().get("label-" + this.panelId);
        }
        return panelTitle;
    }

    public Block getInitialActiveBlock() {
        return this.resources.getContainer().getComponentResources().getBlock(this.activePanelId);
    }

    Object onClicked(String panelId) {
        this.activePanelId = panelId;
        return this.resources.getContainer().getComponentResources().getBlock(panelId);
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

