/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractTextField;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;
import org.apache.tapestry5.services.Request;

@IncludeJavaScriptLibrary(value={"fckeditor/fckeditor.js"})
public class Editor
extends AbstractTextField {
    @Parameter(defaultPrefix="literal", value="300px")
    private String height;
    @Parameter(defaultPrefix="literal", value="300px")
    private String width;
    @Parameter
    private Asset customConfiguration;
    @Parameter(defaultPrefix="literal", value="Default")
    private String toolbarSet;
    @Inject
    private ClasspathAssetAliasManager cpam;
    @Inject
    private SymbolSource symbolSource;
    @Environmental
    private RenderSupport renderSupport;
    @Inject
    private Request request;
    private String value;

    protected final void writeFieldTag(MarkupWriter writer, String value) {
        writer.element("textarea", new Object[]{"name", this.getControlName(), "id", this.getClientId(), "cols", this.getWidth()});
        this.value = value;
    }

    @AfterRender
    final void afterRender(MarkupWriter writer) {
        if (this.value != null) {
            writer.write(this.value);
        }
        writer.end();
        this.writeScript();
    }

    final void writeScript() {
        String editorVar = "editor_" + this.getClientId().replace('-', '_');
        String fckEditorBasePath = this.cpam.toClientURL(this.symbolSource.expandSymbols("${ck.components}")) + "/fckeditor/";
        this.renderSupport.addScript("var %s = new FCKeditor('%s');", new Object[]{editorVar, this.getClientId()});
        this.renderSupport.addScript("%s.BasePath = '%s';", new Object[]{editorVar, fckEditorBasePath});
        if (this.customConfiguration != null) {
            this.renderSupport.addScript("%s.Config['CustomConfigurationsPath'] = '%s';", new Object[]{editorVar, this.getCustomizedConfigurationURL(this.customConfiguration)});
        }
        if (this.toolbarSet != null) {
            this.renderSupport.addScript("%s.ToolbarSet = '%s';", new Object[]{editorVar, this.toolbarSet});
        }
        this.renderSupport.addScript("%s.Height = '%s';", new Object[]{editorVar, this.height});
        this.renderSupport.addScript("%s.Width = '%s';", new Object[]{editorVar, this.width});
        this.renderSupport.addScript("%s.ReplaceTextarea();", new Object[]{editorVar});
    }

    protected String getCustomizedConfigurationURL(Asset configurationAsset) {
        String hackedPath = null;
        String contextPath = this.request.getContextPath();
        if (configurationAsset != null) {
            hackedPath = configurationAsset.toClientURL();
            if (hackedPath.startsWith("../")) {
                hackedPath = contextPath + hackedPath.substring(2);
            }
            if (!hackedPath.startsWith(contextPath)) {
                hackedPath = contextPath + "/" + hackedPath;
            }
        }
        return hackedPath;
    }
}

