/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.net.URL;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.UrlLinkID3V2Frame;

public class WCOMUrlLinkID3V2Frame
extends UrlLinkID3V2Frame {
    public WCOMUrlLinkID3V2Frame(String sCommercialInformationUrl) throws ID3Exception {
        super(sCommercialInformationUrl);
    }

    public WCOMUrlLinkID3V2Frame(URL oCommercialInformationUrl) throws ID3Exception {
        super(oCommercialInformationUrl);
    }

    public WCOMUrlLinkID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitWCOMUrlLinkID3V2Frame(this);
    }

    public void setCommercialInformation(String sCommercialInformationUrl) throws ID3Exception {
        String sOrigURL = this.m_sURL;
        if (sCommercialInformationUrl == null) {
            throw new ID3Exception("Commercial information URL string cannot be null in WCOM frame.");
        }
        this.m_sURL = sCommercialInformationUrl;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public void setCommercialInformation(URL oCommercialInformationUrl) throws ID3Exception {
        String sOrigURL = this.m_sURL;
        if (oCommercialInformationUrl == null) {
            throw new ID3Exception("Commerical information URL object cannot be null in WCOM frame.");
        }
        this.m_sURL = oCommercialInformationUrl.toExternalForm();
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sURL = sOrigURL;
            throw e;
        }
    }

    public String getCommercialInformationUrl() {
        return this.m_sURL;
    }

    protected byte[] getFrameId() {
        return "WCOM".getBytes();
    }

    public String toString() {
        return "Commercial information URL: [" + this.m_sURL + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof WCOMUrlLinkID3V2Frame)) {
            return false;
        }
        WCOMUrlLinkID3V2Frame oOtherWCOM = (WCOMUrlLinkID3V2Frame)oOther;
        return this.m_sURL.equals(oOtherWCOM.m_sURL);
    }
}

