/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TXXXTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private String m_sDescription = null;

    public TXXXTextInformationID3V2Frame(String sDescription, String sInformation) throws ID3Exception {
        super(sInformation);
        if (sDescription == null || sDescription.length() == 0) {
            throw new ID3Exception("Description required for TXXX frame.");
        }
        if (sInformation == null || sInformation.length() == 0) {
            throw new ID3Exception("Information required for TXXX frame.");
        }
        this.m_sDescription = sDescription;
    }

    public TXXXTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            this.m_sDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            byte[] abyInformation = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyInformation);
            this.m_sInformation = new String(abyInformation, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTXXXTextInformationID3V2Frame(this);
    }

    public void setDescriptionAndInformation(String sDescription, String sInformation) throws ID3Exception {
        String sOrigDescription = this.m_sDescription;
        String sOrigInformation = this.m_sInformation;
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        if (sDescription == null || sDescription.length() == 0) {
            throw new ID3Exception("Description required for TXXX frame.");
        }
        if (sInformation == null || sInformation.length() == 0) {
            throw new ID3Exception("Information required for TXXX frame.");
        }
        this.m_sDescription = sDescription;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sInformation;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sDescription = sOrigDescription;
            this.m_sInformation = sOrigInformation;
            this.m_oTextEncoding = oOrigTextEncoding;
            throw e;
        }
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String getInformation() {
        return this.m_sInformation;
    }

    protected byte[] getFrameId() {
        return "TXXX".getBytes();
    }

    public String toString() {
        return "User-defined text: Description=[" + this.m_sDescription + "], Information=[" + this.m_sInformation + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_sInformation.getBytes(this.m_oTextEncoding.getEncodingString()));
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TXXXTextInformationID3V2Frame)) {
            return false;
        }
        TXXXTextInformationID3V2Frame oOtherTXXX = (TXXXTextInformationID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherTXXX.m_oTextEncoding) && this.m_sDescription.equals(oOtherTXXX.m_sDescription) && this.m_sInformation.equals(oOtherTXXX.m_sInformation);
    }
}

