/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TKEYTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private String m_sInitialKey = null;

    public TKEYTextInformationID3V2Frame(String sInitialKey) throws ID3Exception {
        super(sInitialKey);
        if (!sInitialKey.matches("([A-G][#b]?m?|o)")) {
            throw new ID3Exception("Invalid initial key string.");
        }
        this.m_sInitialKey = sInitialKey;
    }

    public TKEYTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_sInitialKey = this.m_sInformation;
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTKEYTextInformationID3V2Frame(this);
    }

    public void setInitialKey(String sInitialKey) throws ID3Exception {
        if (!sInitialKey.matches("([A-G][#b]?m?|o)")) {
            throw new ID3Exception("Invalid initial key string.");
        }
        this.m_sInitialKey = sInitialKey;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sInitialKey;
    }

    public String getInitialKey() {
        return this.m_sInitialKey;
    }

    protected byte[] getFrameId() {
        return "TKEY".getBytes();
    }

    public String toString() {
        return "Initial key: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TKEYTextInformationID3V2Frame)) {
            return false;
        }
        TKEYTextInformationID3V2Frame oOtherTKEY = (TKEYTextInformationID3V2Frame)oOther;
        return this.m_sInitialKey.equals(oOtherTKEY.m_sInitialKey) && this.m_oTextEncoding.equals(oOtherTKEY.m_oTextEncoding) && this.m_sInformation.equals(oOtherTKEY.m_sInformation);
    }
}

