/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TFLTTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    public static final String MPEG_AUDIO = "MPG";
    public static final String MPEG_LAYER_1 = "MPG/1";
    public static final String MPEG_LAYER_2 = "MPG/2";
    public static final String MPEG_LAYER_3 = "MPG/3";
    public static final String MPEG_25 = "MPG/2.5";
    public static final String MPEG_AAC = "MPG/AAC";
    public static final String VQF = "VQF";
    public static final String PCM = "PCM";
    private String m_sFileType = null;

    public TFLTTextInformationID3V2Frame(String sFileType) {
        super(sFileType);
        this.m_sFileType = sFileType;
    }

    public TFLTTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        this.m_sFileType = this.m_sInformation;
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTFLTTextInformationID3V2Frame(this);
    }

    public void setFileType(String sFileType) {
        this.m_sFileType = sFileType;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = sFileType;
    }

    public String getFileType() {
        return this.m_sFileType;
    }

    protected byte[] getFrameId() {
        return "TFLT".getBytes();
    }

    public String toString() {
        return "File type: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TFLTTextInformationID3V2Frame)) {
            return false;
        }
        TFLTTextInformationID3V2Frame oOtherTFLT = (TFLTTextInformationID3V2Frame)oOther;
        return this.m_sFileType.equals(oOtherTFLT.m_sFileType) && this.m_oTextEncoding.equals(oOtherTFLT.m_oTextEncoding) && this.m_sInformation.equals(oOtherTFLT.m_sInformation);
    }
}

