/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TBPMTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iBeatsPerMinute;

    public TBPMTextInformationID3V2Frame(int iBeatsPerMinute) {
        super(Integer.toString(iBeatsPerMinute));
        this.m_iBeatsPerMinute = iBeatsPerMinute;
    }

    public TBPMTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iBeatsPerMinute = (int)Double.parseDouble(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered corrupt TBPM frame while reading tag.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTBPMTextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TBPM".getBytes();
    }

    public String toString() {
        return "Beats per minute: [" + this.m_sInformation + "]";
    }

    public int setBeatsPerMinute(int iBeatsPerMinute) {
        int iOldBeatsPerMinute = this.m_iBeatsPerMinute;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iBeatsPerMinute);
        this.m_iBeatsPerMinute = iBeatsPerMinute;
        return iOldBeatsPerMinute;
    }

    public int getBeatsPerMinute() {
        return this.m_iBeatsPerMinute;
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TBPMTextInformationID3V2Frame)) {
            return false;
        }
        TBPMTextInformationID3V2Frame oOtherTBPM = (TBPMTextInformationID3V2Frame)oOther;
        return this.m_iBeatsPerMinute == oOtherTBPM.m_iBeatsPerMinute && this.m_oTextEncoding.equals(oOtherTBPM.m_oTextEncoding) && this.m_sInformation.equals(oOtherTBPM.m_sInformation);
    }
}

