/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.crypt.ICryptoAgent;
import org.blinkenlights.jid3.crypt.ID3Encryption;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Observer;
import org.blinkenlights.jid3.util.ID3Subject;
import org.blinkenlights.jid3.util.ID3Visitable;
import org.blinkenlights.jid3.v2.ENCRID3V2Frame;
import org.blinkenlights.jid3.v2.EncryptedID3V2Frame;
import org.blinkenlights.jid3.v2.ID3V2Tag;
import org.blinkenlights.jid3.v2.UnknownID3V2Frame;
import org.blinkenlights.jid3.v2.UnknownTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.UnknownUrlLinkID3V2Frame;

public abstract class ID3V2Frame
implements ID3Subject,
ID3Visitable {
    private Set m_oID3ObserverSet = new HashSet();
    private boolean m_bTagAlterPreservationFlag = false;
    private boolean m_bFileAlterPreservationFlag = false;
    private boolean m_bReadOnlyFlag = false;
    private boolean m_bCompressionFlag = false;
    private boolean m_bEncryptionFlag = false;
    private boolean m_bGroupingIdentityFlag = false;
    private byte m_byEncryptionMethod;
    private ICryptoAgent m_oCryptoAgent = null;
    private byte[] m_abyEncryptionData = null;

    public void addID3Observer(ID3Observer oID3Observer) {
        this.m_oID3ObserverSet.add(oID3Observer);
    }

    public void removeID3Observer(ID3Observer oID3Observer) {
        this.m_oID3ObserverSet.remove(oID3Observer);
    }

    public void notifyID3Observers() throws ID3Exception {
        Iterator oIter = this.m_oID3ObserverSet.iterator();
        while (oIter.hasNext()) {
            ID3Observer oID3Observer = (ID3Observer)oIter.next();
            oID3Observer.update(this);
        }
    }

    public void setTagAlterPreservationFlag(boolean bTagAlterPreservationFlagValue) {
        this.m_bTagAlterPreservationFlag = bTagAlterPreservationFlagValue;
    }

    public void setFileAlterPreservationFlag(boolean bFileAlterPreservationFlagValue) {
        this.m_bFileAlterPreservationFlag = bFileAlterPreservationFlagValue;
    }

    public void setReadOnlyFlag(boolean bReadOnlyFlagValue) {
        this.m_bReadOnlyFlag = bReadOnlyFlagValue;
    }

    public void setCompressionFlag(boolean bCompressionFlagValue) {
        this.m_bCompressionFlag = bCompressionFlagValue;
    }

    public void setEncryption(byte byEncryptionMethod) throws ID3Exception {
        this.m_bEncryptionFlag = true;
        this.m_byEncryptionMethod = byEncryptionMethod;
        this.notifyID3Observers();
    }

    public boolean isEncrypted() {
        return this.m_bEncryptionFlag;
    }

    public byte getEncryptionMethod() throws ID3Exception {
        if (!this.isEncrypted()) {
            throw new ID3Exception("This frame is not encrypted.");
        }
        return this.m_byEncryptionMethod;
    }

    void setCryptoAgent(ICryptoAgent oCryptoAgent, byte[] abyEncryptionData) {
        this.m_oCryptoAgent = oCryptoAgent;
        this.m_abyEncryptionData = abyEncryptionData;
    }

    public void setGroupingIdentityFlag(boolean bGroupingIdentityFlagValue) {
        this.m_bGroupingIdentityFlag = bGroupingIdentityFlagValue;
    }

    protected abstract byte[] getFrameId();

    private int getLength() throws IOException {
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        ID3DataOutputStream oLengthIDOS = new ID3DataOutputStream(oBAOS);
        this.writeBody(oLengthIDOS);
        return oBAOS.size();
    }

    public abstract String toString();

    static ID3V2Frame read(ID3DataInputStream oID3DIS) throws ID3Exception {
        return ID3V2Frame.read(oID3DIS, new ENCRID3V2Frame[0]);
    }

    /*
     * WARNING - void declaration
     */
    static ID3V2Frame read(ID3DataInputStream oID3DIS, ENCRID3V2Frame[] aoENCRID3V2Frame) throws ID3Exception {
        String sFrameId = null;
        try {
            void var20_25;
            ID3V2Frame oID3V2Frame;
            Class[] aoArgClassTypes;
            Class<?> oID3V2FrameClass;
            String sClassName;
            byte[] abyFrameId = new byte[4];
            oID3DIS.readFully(abyFrameId);
            if (abyFrameId[0] == 0) {
                return null;
            }
            sFrameId = new String(abyFrameId);
            if (sFrameId.equals("MP3e")) {
                return null;
            }
            if (!sFrameId.matches("[A-Z0-9]+") && ID3V2Tag.usingStrict()) {
                throw new InvalidFrameID3Exception("Invalid frame id [" + sFrameId + "].");
            }
            int iFrameSize = oID3DIS.readBE32();
            int iFirstFlags = oID3DIS.readUnsignedByte();
            boolean bTagAlterPreservationFlag = (iFirstFlags & 0x80) != 0;
            boolean bFileAlterPreservationFlag = (iFirstFlags & 0x40) != 0;
            boolean bReadOnlyFlag = (iFirstFlags & 0x20) != 0;
            boolean bUnknownFirstByteFlags = (iFirstFlags & 0x1F) != 0;
            int iSecondFlags = oID3DIS.readUnsignedByte();
            boolean bCompressionFlag = (iSecondFlags & 0x80) != 0;
            boolean bEncryptionFlag = (iSecondFlags & 0x40) != 0;
            boolean bGroupingIdentityFlag = (iSecondFlags & 0x20) != 0;
            boolean bUnknownSecondByteFlags = (iSecondFlags & 0x1F) != 0;
            int iUncompressedSize = iFrameSize;
            if (bCompressionFlag) {
                iUncompressedSize = oID3DIS.readBE32();
                iFrameSize -= 4;
            }
            int iEncryptionMethodSymbol = 0;
            ICryptoAgent oCryptoAgent = null;
            byte[] abyEncryptionData = null;
            if (bEncryptionFlag) {
                iEncryptionMethodSymbol = oID3DIS.readUnsignedByte();
                --iFrameSize;
                for (int i = 0; i < aoENCRID3V2Frame.length; ++i) {
                    if ((aoENCRID3V2Frame[i].getEncryptionMethodSymbol() & 0xFF) != iEncryptionMethodSymbol) continue;
                    oCryptoAgent = ID3Encryption.getInstance().lookupCryptoAgent(aoENCRID3V2Frame[i].getOwnerIdentifier());
                    abyEncryptionData = aoENCRID3V2Frame[i].getEncryptionData();
                    break;
                }
                if (oCryptoAgent == null) {
                    ByteArrayOutputStream oEncryptedBAOS = new ByteArrayOutputStream();
                    ID3DataOutputStream oEncryptedIDOS = new ID3DataOutputStream(oEncryptedBAOS);
                    oEncryptedIDOS.write(abyFrameId);
                    oEncryptedIDOS.writeBE32(iFrameSize + (bEncryptionFlag ? 1 : 0));
                    oEncryptedIDOS.writeUnsignedByte(iFirstFlags);
                    oEncryptedIDOS.writeUnsignedByte(iSecondFlags);
                    if (bCompressionFlag) {
                        oEncryptedIDOS.writeID3Four(iUncompressedSize);
                    }
                    oEncryptedIDOS.writeUnsignedByte(iEncryptionMethodSymbol);
                    int iFrameDataLength = iFrameSize;
                    byte[] abyEncryptedFrameData = new byte[iFrameDataLength];
                    oID3DIS.readFully(abyEncryptedFrameData);
                    oEncryptedIDOS.write(abyEncryptedFrameData);
                    EncryptedID3V2Frame oEncryptedFrame = new EncryptedID3V2Frame(sFrameId, oEncryptedBAOS.toByteArray());
                    return oEncryptedFrame;
                }
            }
            byte[] abyFrameData = null;
            if (bCompressionFlag) {
                byte[] abyCompressedFrameData = new byte[iFrameSize];
                oID3DIS.readFully(abyCompressedFrameData);
                if (bEncryptionFlag) {
                    abyCompressedFrameData = oCryptoAgent.decrypt(abyCompressedFrameData, abyEncryptionData);
                }
                ByteArrayInputStream oBAIS = new ByteArrayInputStream(abyCompressedFrameData);
                InflaterInputStream oInflaterIS = new InflaterInputStream(oBAIS);
                ID3DataInputStream oInflaterID3DIS = new ID3DataInputStream(oInflaterIS);
                abyFrameData = new byte[iUncompressedSize];
                oInflaterID3DIS.readFully(abyFrameData);
            } else {
                abyFrameData = new byte[iFrameSize];
                oID3DIS.readFully(abyFrameData);
                if (bEncryptionFlag) {
                    abyFrameData = oCryptoAgent.decrypt(abyFrameData, abyEncryptionData);
                }
            }
            if (sFrameId.startsWith("T")) {
                sClassName = "org.blinkenlights.jid3.v2." + sFrameId + "TextInformationID3V2Frame";
                try {
                    oID3V2FrameClass = Class.forName(sClassName);
                    aoArgClassTypes = new Class[]{InputStream.class};
                    Constructor<?> oConstructor = oID3V2FrameClass.getConstructor(aoArgClassTypes);
                    Object[] aoConstructorArgs = new Object[]{new ByteArrayInputStream(abyFrameData)};
                    oID3V2Frame = (ID3V2Frame)oConstructor.newInstance(aoConstructorArgs);
                }
                catch (ClassNotFoundException e) {
                    oID3V2Frame = new UnknownTextInformationID3V2Frame(sFrameId, new ByteArrayInputStream(abyFrameData));
                }
                catch (NoSuchMethodException e) {
                    oID3V2Frame = new UnknownTextInformationID3V2Frame(sFrameId, new ByteArrayInputStream(abyFrameData));
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            } else if (sFrameId.startsWith("W")) {
                sClassName = "org.blinkenlights.jid3.v2." + sFrameId + "UrlLinkID3V2Frame";
                try {
                    oID3V2FrameClass = Class.forName(sClassName);
                    aoArgClassTypes = new Class[]{InputStream.class};
                    Constructor<?> oConstructor = oID3V2FrameClass.getConstructor(aoArgClassTypes);
                    Object[] aoConstructorArgs = new Object[]{new ByteArrayInputStream(abyFrameData)};
                    oID3V2Frame = (ID3V2Frame)oConstructor.newInstance(aoConstructorArgs);
                }
                catch (ClassNotFoundException e) {
                    oID3V2Frame = new UnknownUrlLinkID3V2Frame(sFrameId, new ByteArrayInputStream(abyFrameData));
                }
                catch (NoSuchMethodException e) {
                    oID3V2Frame = new UnknownUrlLinkID3V2Frame(sFrameId, new ByteArrayInputStream(abyFrameData));
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            } else {
                sClassName = "org.blinkenlights.jid3.v2." + sFrameId + "ID3V2Frame";
                try {
                    oID3V2FrameClass = Class.forName(sClassName);
                    aoArgClassTypes = new Class[]{InputStream.class};
                    Constructor<?> oConstructor = oID3V2FrameClass.getConstructor(aoArgClassTypes);
                    Object[] aoConstructorArgs = new Object[]{new ByteArrayInputStream(abyFrameData)};
                    oID3V2Frame = (ID3V2Frame)oConstructor.newInstance(aoConstructorArgs);
                }
                catch (ClassNotFoundException e) {
                    oID3V2Frame = new UnknownID3V2Frame(sFrameId, abyFrameData);
                }
                catch (NoSuchMethodException e) {
                    oID3V2Frame = new UnknownID3V2Frame(sFrameId, abyFrameData);
                }
            }
            var20_25.setTagAlterPreservationFlag(bTagAlterPreservationFlag);
            var20_25.setFileAlterPreservationFlag(bFileAlterPreservationFlag);
            var20_25.setReadOnlyFlag(bReadOnlyFlag);
            var20_25.setCompressionFlag(bCompressionFlag);
            if (bEncryptionFlag) {
                var20_25.setEncryption((byte)iEncryptionMethodSymbol);
            }
            var20_25.setGroupingIdentityFlag(bGroupingIdentityFlag);
            return var20_25;
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            if (sFrameId == null) {
                throw new ID3Exception("Error reading v2 frame.", e);
            }
            throw new ID3Exception("Error reading " + sFrameId + " v2 frame.", e);
        }
    }

    protected void writeHeader(OutputStream oOS) throws ID3Exception {
        try {
            ID3DataOutputStream oIDOS = new ID3DataOutputStream(oOS);
            oIDOS.write(this.getFrameId());
            int iActualLength = this.getActualLength();
            oIDOS.writeBE32(iActualLength);
            int iFirstFlags = 0;
            if (this.m_bTagAlterPreservationFlag) {
                iFirstFlags |= 0x80;
            }
            if (this.m_bFileAlterPreservationFlag) {
                iFirstFlags |= 0x40;
            }
            if (this.m_bReadOnlyFlag) {
                iFirstFlags |= 0x20;
            }
            oIDOS.writeUnsignedByte(iFirstFlags);
            int iSecondFlags = 0;
            if (this.m_bCompressionFlag) {
                iSecondFlags |= 0x80;
            }
            if (this.m_bEncryptionFlag) {
                iSecondFlags |= 0x40;
            }
            if (this.m_bGroupingIdentityFlag) {
                iSecondFlags |= 0x20;
            }
            oIDOS.writeUnsignedByte(iSecondFlags);
            if (this.m_bCompressionFlag) {
                oIDOS.writeBE32(this.getLength());
            }
            if (this.m_bEncryptionFlag) {
                oIDOS.writeUnsignedByte(this.m_byEncryptionMethod & 0xFF);
            }
        }
        catch (Exception e) {
            throw new ID3Exception("Error writing frame: " + e.getMessage(), e);
        }
    }

    private int getActualLength() throws Exception {
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        ID3DataOutputStream oIDOS = new ID3DataOutputStream(oBAOS);
        this.writeBody(oIDOS);
        byte[] abyBody = oBAOS.toByteArray();
        if (this.m_bCompressionFlag) {
            ByteArrayOutputStream oCompressedBAOS = new ByteArrayOutputStream();
            DeflaterOutputStream oDeflaterOS = new DeflaterOutputStream(oCompressedBAOS);
            oDeflaterOS.write(abyBody);
            oDeflaterOS.finish();
            abyBody = oCompressedBAOS.toByteArray();
        }
        if (this.m_bEncryptionFlag) {
            if (this.m_oCryptoAgent == null) {
                throw new ID3Exception("Crypto agent for method " + this.m_byEncryptionMethod + " not registered.  Cannot write frame.");
            }
            abyBody = this.m_oCryptoAgent.encrypt(abyBody, this.m_abyEncryptionData);
        }
        return abyBody.length + (this.m_bCompressionFlag ? 4 : 0) + (this.m_bEncryptionFlag ? 1 : 0);
    }

    protected abstract void writeBody(ID3DataOutputStream var1) throws IOException;

    public void write(OutputStream oOS) throws IOException, ID3Exception {
        ID3DataOutputStream oIDOS = new ID3DataOutputStream(oOS);
        this.writeHeader(oIDOS);
        byte[] abyBody = null;
        ByteArrayOutputStream oBodyBAOS = new ByteArrayOutputStream();
        ID3DataOutputStream oBodyIDOS = new ID3DataOutputStream(oBodyBAOS);
        this.writeBody(oBodyIDOS);
        abyBody = oBodyBAOS.toByteArray();
        if (this.m_bCompressionFlag) {
            ByteArrayOutputStream oCompressedBAOS = new ByteArrayOutputStream();
            DeflaterOutputStream oDeflaterOS = new DeflaterOutputStream(oCompressedBAOS);
            oDeflaterOS.write(abyBody);
            oDeflaterOS.finish();
            abyBody = oCompressedBAOS.toByteArray();
        }
        if (this.m_bEncryptionFlag) {
            if (this.m_oCryptoAgent == null) {
                throw new ID3Exception("Crypto agent for method " + this.m_byEncryptionMethod + " not registered.  Cannot write frame.");
            }
            abyBody = this.m_oCryptoAgent.encrypt(abyBody, this.m_abyEncryptionData);
        }
        oIDOS.write(abyBody);
    }
}

