/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.MP3File;
import org.blinkenlights.jid3.MediaFile;
import org.blinkenlights.jid3.crypt.ICryptoAgent;
import org.blinkenlights.jid3.crypt.ID3CryptException;
import org.blinkenlights.jid3.crypt.ID3Encryption;
import org.blinkenlights.jid3.io.FileSource;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.test.AllTests;
import org.blinkenlights.jid3.util.ID3Util;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v2.AENCID3V2Frame;
import org.blinkenlights.jid3.v2.APICID3V2Frame;
import org.blinkenlights.jid3.v2.COMMID3V2Frame;
import org.blinkenlights.jid3.v2.COMRID3V2Frame;
import org.blinkenlights.jid3.v2.ContentType;
import org.blinkenlights.jid3.v2.ENCRID3V2Frame;
import org.blinkenlights.jid3.v2.EQUAID3V2Frame;
import org.blinkenlights.jid3.v2.ETCOID3V2Frame;
import org.blinkenlights.jid3.v2.EncryptedID3V2Frame;
import org.blinkenlights.jid3.v2.GEOBID3V2Frame;
import org.blinkenlights.jid3.v2.GRIDID3V2Frame;
import org.blinkenlights.jid3.v2.ID3V2Frame;
import org.blinkenlights.jid3.v2.ID3V2Tag;
import org.blinkenlights.jid3.v2.ID3V2_3_0Tag;
import org.blinkenlights.jid3.v2.IPLSID3V2Frame;
import org.blinkenlights.jid3.v2.LINKID3V2Frame;
import org.blinkenlights.jid3.v2.MCDIID3V2Frame;
import org.blinkenlights.jid3.v2.MLLTID3V2Frame;
import org.blinkenlights.jid3.v2.OWNEID3V2Frame;
import org.blinkenlights.jid3.v2.PCNTID3V2Frame;
import org.blinkenlights.jid3.v2.POPMID3V2Frame;
import org.blinkenlights.jid3.v2.POSSID3V2Frame;
import org.blinkenlights.jid3.v2.PRIVID3V2Frame;
import org.blinkenlights.jid3.v2.RBUFID3V2Frame;
import org.blinkenlights.jid3.v2.RVADID3V2Frame;
import org.blinkenlights.jid3.v2.RVRBID3V2Frame;
import org.blinkenlights.jid3.v2.SYLTID3V2Frame;
import org.blinkenlights.jid3.v2.SYTCID3V2Frame;
import org.blinkenlights.jid3.v2.TALBTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TBPMTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TCOMTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TCONTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TCOPTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TDATTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TDLYTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TENCTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TEXTTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TFLTTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TIMETextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TIT1TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TIT2TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TIT3TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TKEYTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TLANTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TLENTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TMEDTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TOALTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TOFNTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TOLYTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TOPETextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TORYTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TOWNTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPE1TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPE2TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPE3TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPE4TextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPOSTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TPUBTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TRCKTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TRDATextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TRSNTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TRSOTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TSIZTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TSRCTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TSSETextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TXXXTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.TYERTextInformationID3V2Frame;
import org.blinkenlights.jid3.v2.UFIDID3V2Frame;
import org.blinkenlights.jid3.v2.USERID3V2Frame;
import org.blinkenlights.jid3.v2.USLTID3V2Frame;
import org.blinkenlights.jid3.v2.UnknownID3V2Frame;
import org.blinkenlights.jid3.v2.WCOMUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WCOPUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WOAFUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WOARUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WOASUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WORSUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WPAYUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WPUBUrlLinkID3V2Frame;
import org.blinkenlights.jid3.v2.WXXXUrlLinkID3V2Frame;

public class ID3V2Test
extends TestCase {
    public ID3V2Test(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)ID3V2Test.class);
    }

    protected void setUp() throws Exception {
        try {
            ID3V2Tag.setDefaultPaddingLength(0);
        }
        catch (ID3Exception iD3Exception) {
            // empty catch block
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadV2_3_0Tag() {
        try {
            File oSourceFile = new File(AllTests.s_RootPath + "v2_3_0tags.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            System.out.println("\n*** v2_3_0tags.mp3 tag:");
            ID3Util.printTags(aoID3Tag);
            if (aoID3Tag.length != 1) {
                ID3V2Test.fail((String)"There should be exactly one set of tags in this file.");
            }
            if (!(aoID3Tag[0] instanceof ID3V2_3_0Tag)) {
                ID3V2Test.fail((String)"Expected ID3V2_3_0Tag.");
            } else {
                ID3V2Tag oID3V2Tag = (ID3V2Tag)aoID3Tag[0];
                int iPaddingLength = oID3V2Tag.getPaddingLength();
                if (iPaddingLength == 133) {
                    System.out.println("Padding length: " + oID3V2Tag.getPaddingLength());
                } else {
                    ID3V2Test.fail((String)("Padding length is 133, not " + iPaddingLength + "."));
                }
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    private void runTagVerifyTest(ID3V2_3_0Tag oID3V2_3_0Tag, String sExpectedPrefix) {
        try {
            ID3Util.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            oMediaFile.setID3Tag(oID3V2_3_0Tag);
            ((MediaFile)oMediaFile).sync();
            byte[] abyPrefix = ID3Util.convertFrhedToByteArray(sExpectedPrefix);
            ID3Util.compareFilePrefix(oSourceFile, abyPrefix);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            if (aoID3Tag.length != 1) {
                ID3V2Test.fail((String)"There should be exactly one set of tags in this file.");
            }
            if (!(aoID3Tag[0] instanceof ID3V2_3_0Tag)) {
                ID3V2Test.fail((String)"Expected ID3V2_3_0Tag.");
            } else {
                int i;
                WXXXUrlLinkID3V2Frame[] aoWXXXUrlLinkID3V2Frame2;
                WOARUrlLinkID3V2Frame[] aoWOARUrlLinkID3V2Frame2;
                WCOMUrlLinkID3V2Frame[] aoWCOMUrlLinkID3V2Frame2;
                USLTID3V2Frame[] aoUSLTID3V2Frame2;
                UFIDID3V2Frame[] aoUFIDID3V2Frame2;
                TXXXTextInformationID3V2Frame[] aoTXXXID3V2Frame2;
                SYLTID3V2Frame[] aoSYLTID3V2Frame2;
                POPMID3V2Frame[] aoPOPMID3V2Frame2;
                PRIVID3V2Frame[] aoPRIVID3V2Frame2;
                LINKID3V2Frame[] aoLINKID3V2Frame2;
                GRIDID3V2Frame[] aoGRIDID3V2Frame2;
                GEOBID3V2Frame[] aoGEOBID3V2Frame2;
                ENCRID3V2Frame[] aoENCRID3V2Frame2;
                COMMID3V2Frame[] aoCOMMID3V2Frame2;
                APICID3V2Frame[] aoAPICID3V2Frame2;
                AENCID3V2Frame[] aoAENCID3V2Frame2;
                ID3V2_3_0Tag oReadID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                AENCID3V2Frame[] aoAENCID3V2Frame1 = oID3V2_3_0Tag.getAENCFrames();
                if (aoAENCID3V2Frame1.length != (aoAENCID3V2Frame2 = oReadID3V2_3_0Tag.getAENCFrames()).length) {
                    ID3V2Test.fail((String)(aoAENCID3V2Frame1.length + " AENC frame(s) written, " + aoAENCID3V2Frame2.length + " frame(s) read."));
                }
                for (int i2 = 0; i2 < aoAENCID3V2Frame1.length; ++i2) {
                    if (aoAENCID3V2Frame1[i2].equals(aoAENCID3V2Frame2[i2])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoAENCID3V2Frame1[i2].toString() + " and " + aoAENCID3V2Frame2[i2].toString() + "."));
                }
                APICID3V2Frame[] aoAPICID3V2Frame1 = oID3V2_3_0Tag.getAPICFrames();
                if (aoAPICID3V2Frame1.length != (aoAPICID3V2Frame2 = oReadID3V2_3_0Tag.getAPICFrames()).length) {
                    ID3V2Test.fail((String)(aoAPICID3V2Frame1.length + " APIC frame(s) written, " + aoAPICID3V2Frame2.length + " frame(s) read."));
                }
                for (int i3 = 0; i3 < aoAPICID3V2Frame1.length; ++i3) {
                    if (aoAPICID3V2Frame1[i3].equals(aoAPICID3V2Frame2[i3])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoAPICID3V2Frame1[i3].toString() + " and " + aoAPICID3V2Frame2[i3].toString() + "."));
                }
                COMMID3V2Frame[] aoCOMMID3V2Frame1 = oID3V2_3_0Tag.getCOMMFrames();
                if (aoCOMMID3V2Frame1.length != (aoCOMMID3V2Frame2 = oReadID3V2_3_0Tag.getCOMMFrames()).length) {
                    ID3V2Test.fail((String)(aoCOMMID3V2Frame1.length + " COMM frame(s) written, " + aoCOMMID3V2Frame2.length + " frame(s) read."));
                }
                for (int i4 = 0; i4 < aoCOMMID3V2Frame1.length; ++i4) {
                    if (aoCOMMID3V2Frame1[i4].equals(aoCOMMID3V2Frame2[i4])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoCOMMID3V2Frame1[i4].toString() + " and " + aoCOMMID3V2Frame2[i4].toString() + "."));
                }
                ENCRID3V2Frame[] aoENCRID3V2Frame1 = oID3V2_3_0Tag.getENCRFrames();
                if (aoENCRID3V2Frame1.length != (aoENCRID3V2Frame2 = oReadID3V2_3_0Tag.getENCRFrames()).length) {
                    ID3V2Test.fail((String)(aoENCRID3V2Frame1.length + " ENCR frame(s) written, " + aoENCRID3V2Frame2.length + " frame(s) read."));
                }
                for (int i5 = 0; i5 < aoENCRID3V2Frame1.length; ++i5) {
                    if (aoENCRID3V2Frame1[i5].equals(aoENCRID3V2Frame2[i5])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoENCRID3V2Frame1[i5].toString() + " and " + aoENCRID3V2Frame2[i5].toString() + "."));
                }
                GEOBID3V2Frame[] aoGEOBID3V2Frame1 = oID3V2_3_0Tag.getGEOBFrames();
                if (aoGEOBID3V2Frame1.length != (aoGEOBID3V2Frame2 = oReadID3V2_3_0Tag.getGEOBFrames()).length) {
                    ID3V2Test.fail((String)(aoGEOBID3V2Frame1.length + " GEOB frame(s) written, " + aoGEOBID3V2Frame2.length + " frame(s) read."));
                }
                for (int i6 = 0; i6 < aoGEOBID3V2Frame1.length; ++i6) {
                    if (aoGEOBID3V2Frame1[i6].equals(aoGEOBID3V2Frame2[i6])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoGEOBID3V2Frame1[i6].toString() + " and " + aoGEOBID3V2Frame2[i6].toString() + "."));
                }
                GRIDID3V2Frame[] aoGRIDID3V2Frame1 = oID3V2_3_0Tag.getGRIDFrames();
                if (aoGRIDID3V2Frame1.length != (aoGRIDID3V2Frame2 = oReadID3V2_3_0Tag.getGRIDFrames()).length) {
                    ID3V2Test.fail((String)(aoGRIDID3V2Frame1.length + " GRID frame(s) written, " + aoGRIDID3V2Frame2.length + " frame(s) read."));
                }
                for (int i7 = 0; i7 < aoGRIDID3V2Frame1.length; ++i7) {
                    if (aoGRIDID3V2Frame1[i7].equals(aoGRIDID3V2Frame2[i7])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoGRIDID3V2Frame1[i7].toString() + " and " + aoGRIDID3V2Frame2[i7].toString() + "."));
                }
                LINKID3V2Frame[] aoLINKID3V2Frame1 = oID3V2_3_0Tag.getLINKFrames();
                if (aoLINKID3V2Frame1.length != (aoLINKID3V2Frame2 = oReadID3V2_3_0Tag.getLINKFrames()).length) {
                    ID3V2Test.fail((String)(aoLINKID3V2Frame1.length + " LINK frame(s) written, " + aoLINKID3V2Frame2.length + " frame(s) read."));
                }
                for (int i8 = 0; i8 < aoLINKID3V2Frame1.length; ++i8) {
                    if (aoLINKID3V2Frame1[i8].equals(aoLINKID3V2Frame2[i8])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoLINKID3V2Frame1[i8].toString() + " and " + aoLINKID3V2Frame2[i8].toString() + "."));
                }
                PRIVID3V2Frame[] aoPRIVID3V2Frame1 = oID3V2_3_0Tag.getPRIVFrames();
                if (aoPRIVID3V2Frame1.length != (aoPRIVID3V2Frame2 = oReadID3V2_3_0Tag.getPRIVFrames()).length) {
                    ID3V2Test.fail((String)(aoPRIVID3V2Frame1.length + " PRIV frame(s) written, " + aoPRIVID3V2Frame2.length + " frame(s) read."));
                }
                for (int i9 = 0; i9 < aoPRIVID3V2Frame1.length; ++i9) {
                    if (aoPRIVID3V2Frame1[i9].equals(aoPRIVID3V2Frame2[i9])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoPRIVID3V2Frame1[i9].toString() + " and " + aoPRIVID3V2Frame2[i9].toString() + "."));
                }
                POPMID3V2Frame[] aoPOPMID3V2Frame1 = oID3V2_3_0Tag.getPOPMFrames();
                if (aoPOPMID3V2Frame1.length != (aoPOPMID3V2Frame2 = oReadID3V2_3_0Tag.getPOPMFrames()).length) {
                    ID3V2Test.fail((String)(aoPOPMID3V2Frame1.length + " POPM frame(s) written, " + aoPOPMID3V2Frame2.length + " frame(s) read."));
                }
                for (int i10 = 0; i10 < aoPOPMID3V2Frame1.length; ++i10) {
                    if (aoPOPMID3V2Frame1[i10].equals(aoPOPMID3V2Frame2[i10])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoPOPMID3V2Frame1[i10].toString() + " and " + aoPOPMID3V2Frame2[i10].toString() + "."));
                }
                SYLTID3V2Frame[] aoSYLTID3V2Frame1 = oID3V2_3_0Tag.getSYLTFrames();
                if (aoSYLTID3V2Frame1.length != (aoSYLTID3V2Frame2 = oReadID3V2_3_0Tag.getSYLTFrames()).length) {
                    ID3V2Test.fail((String)(aoSYLTID3V2Frame1.length + " SYLT frame(s) written, " + aoSYLTID3V2Frame2.length + " frame(s) read."));
                }
                for (int i11 = 0; i11 < aoSYLTID3V2Frame1.length; ++i11) {
                    if (aoSYLTID3V2Frame1[i11].equals(aoSYLTID3V2Frame2[i11])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoSYLTID3V2Frame1[i11].toString() + " and " + aoSYLTID3V2Frame2[i11].toString() + "."));
                }
                TXXXTextInformationID3V2Frame[] aoTXXXID3V2Frame1 = oID3V2_3_0Tag.getTXXXTextInformationFrames();
                if (aoTXXXID3V2Frame1.length != (aoTXXXID3V2Frame2 = oReadID3V2_3_0Tag.getTXXXTextInformationFrames()).length) {
                    ID3V2Test.fail((String)(aoTXXXID3V2Frame1.length + " TXXX frame(s) written, " + aoTXXXID3V2Frame2.length + " frame(s) read."));
                }
                for (int i12 = 0; i12 < aoTXXXID3V2Frame1.length; ++i12) {
                    if (aoTXXXID3V2Frame1[i12].equals(aoTXXXID3V2Frame2[i12])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoTXXXID3V2Frame1[i12].toString() + " and " + aoTXXXID3V2Frame2[i12].toString() + "."));
                }
                UFIDID3V2Frame[] aoUFIDID3V2Frame1 = oID3V2_3_0Tag.getUFIDFrames();
                if (aoUFIDID3V2Frame1.length != (aoUFIDID3V2Frame2 = oReadID3V2_3_0Tag.getUFIDFrames()).length) {
                    ID3V2Test.fail((String)(aoUFIDID3V2Frame1.length + " UFID frame(s) written, " + aoUFIDID3V2Frame2.length + " frame(s) read."));
                }
                for (int i13 = 0; i13 < aoUFIDID3V2Frame1.length; ++i13) {
                    if (aoUFIDID3V2Frame1[i13].equals(aoUFIDID3V2Frame2[i13])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoUFIDID3V2Frame1[i13].toString() + " and " + aoUFIDID3V2Frame2[i13].toString() + "."));
                }
                USLTID3V2Frame[] aoUSLTID3V2Frame1 = oID3V2_3_0Tag.getUSLTFrames();
                if (aoUSLTID3V2Frame1.length != (aoUSLTID3V2Frame2 = oReadID3V2_3_0Tag.getUSLTFrames()).length) {
                    ID3V2Test.fail((String)(aoUSLTID3V2Frame1.length + " USLT frame(s) written, " + aoUSLTID3V2Frame2.length + " frame(s) read."));
                }
                for (int i14 = 0; i14 < aoUSLTID3V2Frame1.length; ++i14) {
                    if (aoUSLTID3V2Frame1[i14].equals(aoUSLTID3V2Frame2[i14])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoUSLTID3V2Frame1[i14].toString() + " and " + aoUSLTID3V2Frame2[i14].toString() + "."));
                }
                WCOMUrlLinkID3V2Frame[] aoWCOMUrlLinkID3V2Frame1 = oID3V2_3_0Tag.getWCOMUrlLinkFrames();
                if (aoWCOMUrlLinkID3V2Frame1.length != (aoWCOMUrlLinkID3V2Frame2 = oReadID3V2_3_0Tag.getWCOMUrlLinkFrames()).length) {
                    ID3V2Test.fail((String)(aoWCOMUrlLinkID3V2Frame1.length + " WCOM frame(s) written, " + aoWCOMUrlLinkID3V2Frame2.length + " frame(s) read."));
                }
                for (int i15 = 0; i15 < aoWCOMUrlLinkID3V2Frame1.length; ++i15) {
                    if (aoWCOMUrlLinkID3V2Frame1[i15].equals(aoWCOMUrlLinkID3V2Frame2[i15])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoWCOMUrlLinkID3V2Frame1[i15].toString() + " and " + aoWCOMUrlLinkID3V2Frame2[i15].toString() + "."));
                }
                WOARUrlLinkID3V2Frame[] aoWOARUrlLinkID3V2Frame1 = oID3V2_3_0Tag.getWOARUrlLinkFrames();
                if (aoWOARUrlLinkID3V2Frame1.length != (aoWOARUrlLinkID3V2Frame2 = oReadID3V2_3_0Tag.getWOARUrlLinkFrames()).length) {
                    ID3V2Test.fail((String)(aoWOARUrlLinkID3V2Frame1.length + " WOAR frame(s) written, " + aoWOARUrlLinkID3V2Frame2.length + " frame(s) read."));
                }
                for (int i16 = 0; i16 < aoWOARUrlLinkID3V2Frame1.length; ++i16) {
                    if (aoWOARUrlLinkID3V2Frame1[i16].equals(aoWOARUrlLinkID3V2Frame2[i16])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoWOARUrlLinkID3V2Frame1[i16].toString() + " and " + aoWOARUrlLinkID3V2Frame2[i16].toString() + "."));
                }
                WXXXUrlLinkID3V2Frame[] aoWXXXUrlLinkID3V2Frame1 = oID3V2_3_0Tag.getWXXXUrlLinkFrames();
                if (aoWXXXUrlLinkID3V2Frame1.length != (aoWXXXUrlLinkID3V2Frame2 = oReadID3V2_3_0Tag.getWXXXUrlLinkFrames()).length) {
                    ID3V2Test.fail((String)(aoWXXXUrlLinkID3V2Frame1.length + " WXXX frame(s) written, " + aoWXXXUrlLinkID3V2Frame2.length + " frame(s) read."));
                }
                for (int i17 = 0; i17 < aoWXXXUrlLinkID3V2Frame1.length; ++i17) {
                    if (aoWXXXUrlLinkID3V2Frame1[i17].equals(aoWXXXUrlLinkID3V2Frame2[i17])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoWXXXUrlLinkID3V2Frame1[i17].toString() + " and " + aoWXXXUrlLinkID3V2Frame2[i17].toString() + "."));
                }
                ID3V2Frame[] aoID3V2Frame1 = oID3V2_3_0Tag.getSingleFrames();
                ID3V2Frame[] aoID3V2Frame2 = oReadID3V2_3_0Tag.getSingleFrames();
                HashSet<String> oTagFrameSet1 = new HashSet<String>();
                for (int i18 = 0; i18 < aoID3V2Frame1.length; ++i18) {
                    oTagFrameSet1.add(aoID3V2Frame1[i18].getClass().getName());
                }
                HashSet<String> oTagFrameSet2 = new HashSet<String>();
                for (i = 0; i < aoID3V2Frame2.length; ++i) {
                    oTagFrameSet2.add(aoID3V2Frame2[i].getClass().getName());
                }
                if (aoID3V2Frame1.length != aoID3V2Frame2.length || !((Object)oTagFrameSet1).equals(oTagFrameSet2)) {
                    int i19;
                    StringBuffer sbFail = new StringBuffer();
                    sbFail.append("Single frames written (");
                    for (i19 = 0; i19 < aoID3V2Frame1.length; ++i19) {
                        sbFail.append(new String(aoID3V2Frame1[i19].getClass().getName()) + ",");
                    }
                    if (aoID3V2Frame1.length > 0) {
                        sbFail = sbFail.deleteCharAt(sbFail.length() - 1);
                    }
                    sbFail.append("), single frames read (");
                    for (i19 = 0; i19 < aoID3V2Frame2.length; ++i19) {
                        sbFail.append(new String(aoID3V2Frame2[i19].getClass().getName()) + ",");
                    }
                    if (aoID3V2Frame2.length > 0) {
                        sbFail = sbFail.deleteCharAt(sbFail.length() - 1);
                    }
                    sbFail.append(")");
                    ID3V2Test.fail((String)sbFail.toString());
                }
                for (i = 0; i < aoID3V2Frame1.length; ++i) {
                    if (aoID3V2Frame1[i].equals(aoID3V2Frame2[i])) continue;
                    ID3V2Test.fail((String)("Tags do not match: " + aoID3V2Frame1[i].toString() + " and " + aoID3V2Frame2[i].toString() + "."));
                }
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTALBFrame() {
        String sPrefix;
        TALBTextInformationID3V2Frame oTALB;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTALB = new TALBTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTALBTextInformationFrame(oTALB);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TALB<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTALB = new TALBTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oTALB.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setTALBTextInformationFrame(oTALB);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>ATALB<bh:00><bh:00><bh:00>7<bh:00><bh:00><bh:01><bh:ff><bh:fe>a<bh:00>b<bh:00>c<bh:00>d<bh:00>e<bh:00>f<bh:00>g<bh:00>h<bh:00>i<bh:00>j<bh:00>k<bh:00>l<bh:00>m<bh:00>n<bh:00>o<bh:00>p<bh:00>q<bh:00>r<bh:00>s<bh:00>t<bh:00>u<bh:00>v<bh:00>w<bh:00>x<bh:00>y<bh:00>z<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testTBPMFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TBPMTextInformationID3V2Frame oTBPM = new TBPMTextInformationID3V2Frame(123456789);
            oID3V2_3_0Tag.setTBPMTextInformationFrame(oTBPM);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:14>TBPM<bh:00><bh:00><bh:00><bh:0a><bh:00><bh:00><bh:00>123456789";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTCOMFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TCOMTextInformationID3V2Frame oTCOM = new TCOMTextInformationID3V2Frame("abcdefg/hijklmnopq/rstuvwxyz");
            oID3V2_3_0Tag.setTCOMTextInformationFrame(oTCOM);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'TCOM<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>abcdefg/hijklmnopq/rstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTCONFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            ContentType oContentType = new ContentType();
            oContentType.setGenre(ContentType.Genre.Blues);
            oContentType.setGenre(ContentType.Genre.Rock);
            oContentType.setIsCover(true);
            oContentType.setIsRemix(true);
            oContentType.setRefinement("refinement");
            TCONTextInformationID3V2Frame oTCON = new TCONTextInformationID3V2Frame(oContentType);
            oID3V2_3_0Tag.setTCONTextInformationFrame(oTCON);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>$TCON<bh:00><bh:00><bh:00><bh:1a><bh:00><bh:00><bh:00>(0)(17)(CR)(RX)refinement";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTCOPFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TCOPTextInformationID3V2Frame oTCOP = new TCOPTextInformationID3V2Frame(1234, "abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTCOPTextInformationFrame(oTCOP);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>*TCOP<bh:00><bh:00><bh:00> <bh:00><bh:00><bh:00>1234 abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTDATFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TDATTextInformationID3V2Frame oTDAT = new TDATTextInformationID3V2Frame(25, 12);
            oID3V2_3_0Tag.setTDATTextInformationFrame(oTDAT);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>TDAT<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>2512";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTDLYFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TDLYTextInformationID3V2Frame oTDLY = new TDLYTextInformationID3V2Frame(12345);
            oID3V2_3_0Tag.setTDLYTextInformationFrame(oTDLY);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:10>TDLY<bh:00><bh:00><bh:00><bh:06><bh:00><bh:00><bh:00>12345";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTENCFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TENCTextInformationID3V2Frame oTENC = new TENCTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTENCTextInformationFrame(oTENC);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TENC<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTEXTFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TEXTTextInformationID3V2Frame oTEXT = new TEXTTextInformationID3V2Frame("abcdefg/hijklmnopq/rstuvwxyz");
            oID3V2_3_0Tag.setTEXTTextInformationFrame(oTEXT);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'TEXT<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>abcdefg/hijklmnopq/rstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTFLTFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TFLTTextInformationID3V2Frame oTFLT = new TFLTTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTFLTTextInformationFrame(oTFLT);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TFLT<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTIMEFrame() {
        String sPrefix;
        TIMETextInformationID3V2Frame oTIME;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTIME = new TIMETextInformationID3V2Frame(8, 5);
            oID3V2_3_0Tag.setTIMETextInformationFrame(oTIME);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>TIME<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>0805";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTIME = new TIMETextInformationID3V2Frame(8, 5);
            oTIME.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setTIMETextInformationFrame(oTIME);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:15>TIME<bh:00><bh:00><bh:00><bh:0b><bh:00><bh:00><bh:01><bh:ff><bh:fe>0<bh:00>8<bh:00>0<bh:00>5<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testTIT1Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TIT1TextInformationID3V2Frame oTIT1 = new TIT1TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTIT1TextInformationFrame(oTIT1);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TIT1<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTIT2Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TIT2TextInformationID3V2Frame oTIT2 = new TIT2TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTIT2TextInformationFrame(oTIT2);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TIT2<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTIT3Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TIT3TextInformationID3V2Frame oTIT3 = new TIT3TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTIT3TextInformationFrame(oTIT3);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TIT3<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTKEYFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TKEYTextInformationID3V2Frame oTKEY = new TKEYTextInformationID3V2Frame("C#m");
            oID3V2_3_0Tag.setTKEYTextInformationFrame(oTKEY);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>TKEY<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:00>C#m";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTLANFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TLANTextInformationID3V2Frame oTLAN = new TLANTextInformationID3V2Frame("eng");
            oID3V2_3_0Tag.setTLANTextInformationFrame(oTLAN);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>TLAN<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:00>eng";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTLENFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TLENTextInformationID3V2Frame oTLEN = new TLENTextInformationID3V2Frame(12345);
            oID3V2_3_0Tag.setTLENTextInformationFrame(oTLEN);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:10>TLEN<bh:00><bh:00><bh:00><bh:06><bh:00><bh:00><bh:00>12345";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTMEDFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TMEDTextInformationID3V2Frame oTMED = new TMEDTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTMEDTextInformationFrame(oTMED);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TMED<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTOALFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TOALTextInformationID3V2Frame oTOAL = new TOALTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTOALTextInformationFrame(oTOAL);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TOAL<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTOFNFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TOFNTextInformationID3V2Frame oTOFN = new TOFNTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTOFNTextInformationFrame(oTOFN);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TOFN<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTOLYFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TOLYTextInformationID3V2Frame oTOLY = new TOLYTextInformationID3V2Frame("abcdefg/hijklmnopq/rstuvwxyz");
            oID3V2_3_0Tag.setTOLYTextInformationFrame(oTOLY);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'TOLY<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>abcdefg/hijklmnopq/rstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTOPEFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TOPETextInformationID3V2Frame oTOPE = new TOPETextInformationID3V2Frame("abcdefg/hijklmnopq/rstuvwxyz");
            oID3V2_3_0Tag.setTOPETextInformationFrame(oTOPE);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'TOPE<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>abcdefg/hijklmnopq/rstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTORYFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TORYTextInformationID3V2Frame oTORY = new TORYTextInformationID3V2Frame(1999);
            oID3V2_3_0Tag.setTORYTextInformationFrame(oTORY);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>TORY<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>1999";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTOWNFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TOWNTextInformationID3V2Frame oTOWN = new TOWNTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTOWNTextInformationFrame(oTOWN);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TOWN<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPE1Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPE1TextInformationID3V2Frame oTPE1 = new TPE1TextInformationID3V2Frame("abcdefg/hijklmnopq/rstuvwxyz");
            oID3V2_3_0Tag.setTPE1TextInformationFrame(oTPE1);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'TPE1<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>abcdefg/hijklmnopq/rstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPE2Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPE2TextInformationID3V2Frame oTPE2 = new TPE2TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTPE2TextInformationFrame(oTPE2);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TPE2<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPE3Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPE3TextInformationID3V2Frame oTPE3 = new TPE3TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTPE3TextInformationFrame(oTPE3);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TPE3<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPE4Frame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPE4TextInformationID3V2Frame oTPE4 = new TPE4TextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTPE4TextInformationFrame(oTPE4);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TPE4<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPOSFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPOSTextInformationID3V2Frame oTPOS = new TPOSTextInformationID3V2Frame(12);
            oID3V2_3_0Tag.setTPOSTextInformationFrame(oTPOS);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0d>TPOS<bh:00><bh:00><bh:00><bh:03><bh:00><bh:00><bh:00>12";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
            oTPOS = new TPOSTextInformationID3V2Frame(12, 34);
            oID3V2_3_0Tag.setTPOSTextInformationFrame(oTPOS);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:10>TPOS<bh:00><bh:00><bh:00><bh:06><bh:00><bh:00><bh:00>12/34";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTPUBFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TPUBTextInformationID3V2Frame oTPUB = new TPUBTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTPUBTextInformationFrame(oTPUB);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TPUB<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTRCKFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TRCKTextInformationID3V2Frame oTRCK = new TRCKTextInformationID3V2Frame(12);
            oID3V2_3_0Tag.setTRCKTextInformationFrame(oTRCK);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0d>TRCK<bh:00><bh:00><bh:00><bh:03><bh:00><bh:00><bh:00>12";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
            oTRCK = new TRCKTextInformationID3V2Frame(12, 34);
            oID3V2_3_0Tag.setTRCKTextInformationFrame(oTRCK);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:10>TRCK<bh:00><bh:00><bh:00><bh:06><bh:00><bh:00><bh:00>12/34";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTRDAFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TRDATextInformationID3V2Frame oTRDA = new TRDATextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTRDATextInformationFrame(oTRDA);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TRDA<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTRSNFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TRSNTextInformationID3V2Frame oTRSN = new TRSNTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTRSNTextInformationFrame(oTRSN);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TRSN<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTRSOFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TRSOTextInformationID3V2Frame oTRSO = new TRSOTextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTRSOTextInformationFrame(oTRSO);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TRSO<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTSIZFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TSIZTextInformationID3V2Frame oTSIZ = new TSIZTextInformationID3V2Frame(12345);
            oID3V2_3_0Tag.setTSIZTextInformationFrame(oTSIZ);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:10>TSIZ<bh:00><bh:00><bh:00><bh:06><bh:00><bh:00><bh:00>12345";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTSRCFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TSRCTextInformationID3V2Frame oTSRC = new TSRCTextInformationID3V2Frame("123456789012");
            oID3V2_3_0Tag.setTSRCTextInformationFrame(oTSRC);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:17>TSRC<bh:00><bh:00><bh:00><bh:0d><bh:00><bh:00><bh:00>123456789012";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTSSEFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TSSETextInformationID3V2Frame oTSSE = new TSSETextInformationID3V2Frame("abcdefghijklmnopqrstuvwxyz");
            oID3V2_3_0Tag.setTSSETextInformationFrame(oTSSE);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>%TSSE<bh:00><bh:00><bh:00><bh:1b><bh:00><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testTXXXFrame() {
        String sPrefix;
        TXXXTextInformationID3V2Frame oTXXX;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTXXX = new TXXXTextInformationID3V2Frame("description", "information");
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX);
            oTXXX = new TXXXTextInformationID3V2Frame("description2", "information2");
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>FTXXX<bh:00><bh:00><bh:00><bh:18><bh:00><bh:00><bh:00>description<bh:00>informationTXXX<bh:00><bh:00><bh:00><bh:1a><bh:00><bh:00><bh:00>description2<bh:00>information2";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oTXXX = new TXXXTextInformationID3V2Frame("description", "information");
            oTXXX.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX);
            oTXXX = new TXXXTextInformationID3V2Frame("description2", "information2");
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>aTXXX<bh:00><bh:00><bh:00>3<bh:00><bh:00><bh:01><bh:ff><bh:fe>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00><bh:00><bh:00><bh:ff><bh:fe>i<bh:00>n<bh:00>f<bh:00>o<bh:00>r<bh:00>m<bh:00>a<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00>TXXX<bh:00><bh:00><bh:00><bh:1a><bh:00><bh:00><bh:00>description2<bh:00>information2";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testTYERFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            TYERTextInformationID3V2Frame oTYER = new TYERTextInformationID3V2Frame(1999);
            oID3V2_3_0Tag.setTYERTextInformationFrame(oTYER);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>TYER<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>1999";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWCOMFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WCOMUrlLinkID3V2Frame oWCOM = new WCOMUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.addWCOMUrlLinkFrame(oWCOM);
            oWCOM = new WCOMUrlLinkID3V2Frame("http://www.grebenc.ca");
            oID3V2_3_0Tag.addWCOMUrlLinkFrame(oWCOM);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>FWCOM<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.orgWCOM<bh:00><bh:00><bh:00><bh:15><bh:00><bh:00>http://www.grebenc.ca";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWCOPFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WCOPUrlLinkID3V2Frame oWCOP = new WCOPUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWCOPUrlLinkFrame(oWCOP);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WCOP<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWOAFFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WOAFUrlLinkID3V2Frame oWOAF = new WOAFUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWOAFUrlLinkFrame(oWOAF);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WOAF<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWOARFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WOARUrlLinkID3V2Frame oWOAR = new WOARUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.addWOARUrlLinkFrame(oWOAR);
            oWOAR = new WOARUrlLinkID3V2Frame("http://www.grebenc.ca");
            oID3V2_3_0Tag.addWOARUrlLinkFrame(oWOAR);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>FWOAR<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.orgWOAR<bh:00><bh:00><bh:00><bh:15><bh:00><bh:00>http://www.grebenc.ca";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWOASFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WOASUrlLinkID3V2Frame oWOAS = new WOASUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWOASUrlLinkFrame(oWOAS);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WOAS<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWORSFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WORSUrlLinkID3V2Frame oWORS = new WORSUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWORSUrlLinkFrame(oWORS);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WORS<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWPAYFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WPAYUrlLinkID3V2Frame oWPAY = new WPAYUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWPAYUrlLinkFrame(oWPAY);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WPAY<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWPUBFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            WPUBUrlLinkID3V2Frame oWPUB = new WPUBUrlLinkID3V2Frame("http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.setWPUBUrlLinkFrame(oWPUB);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'WPUB<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testWXXXFrame() {
        String sPrefix;
        WXXXUrlLinkID3V2Frame oWXXX;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oWXXX = new WXXXUrlLinkID3V2Frame("description", "http://jid3.blinkenlights.org");
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX);
            oWXXX = new WXXXUrlLinkID3V2Frame("another description", "http://www.grebenc.ca");
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>hWXXX<bh:00><bh:00><bh:00>*<bh:00><bh:00><bh:00>another description<bh:00>http://www.grebenc.caWXXX<bh:00><bh:00><bh:00>*<bh:00><bh:00><bh:00>description<bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8559-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oWXXX = new WXXXUrlLinkID3V2Frame("description", "http://jid3.blinkenlights.org");
            oWXXX.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX);
            oWXXX = new WXXXUrlLinkID3V2Frame("another description", "http://www.grebenc.ca");
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>vWXXX<bh:00><bh:00><bh:00>*<bh:00><bh:00><bh:00>another description<bh:00>http://www.grebenc.caWXXX<bh:00><bh:00><bh:00>8<bh:00><bh:00><bh:01><bh:ff><bh:fe>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00><bh:00><bh:00>http://jid3.blinkenlights.org";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testAENCFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.addAENCFrame(new AENCID3V2Frame("owner identifier", 123, 456, new byte[]{1, 2, 3, 4, 5}));
            oID3V2_3_0Tag.addAENCFrame(new AENCID3V2Frame("owner identifier 2", 234, 567, new byte[]{6, 7, 8, 9, 10}));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>JAENC<bh:00><bh:00><bh:00><bh:1a><bh:00><bh:00>owner identifier<bh:00><bh:00>{<bh:01><bh:c8><bh:01><bh:02><bh:03><bh:04><bh:05>AENC<bh:00><bh:00><bh:00><bh:1c><bh:00><bh:00>owner identifier 2<bh:00><bh:00><bh:ea><bh:02>7<bh:06><bh:07><bh:08><bh:09><bh:0a>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testAPICFrame() {
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.addAPICFrame(new APICID3V2Frame("image/png", APICID3V2Frame.PictureType.Artist, "Artist image.", new byte[]{1, 2, 3, 4, 5}));
            oID3V2_3_0Tag.addAPICFrame(new APICID3V2Frame("image/jpeg", APICID3V2Frame.PictureType.FrontCover, "Front cover.", new byte[]{5, 4, 3, 2, 1}));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>RAPIC<bh:00><bh:00><bh:00><bh:1f><bh:00><bh:00><bh:00>image/png<bh:00><bh:08>Artist image.<bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>APIC<bh:00><bh:00><bh:00><bh:1f><bh:00><bh:00><bh:00>image/jpeg<bh:00><bh:03>Front cover.<bh:00><bh:05><bh:04><bh:03><bh:02><bh:01>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            APICID3V2Frame oAPIC = new APICID3V2Frame("image/png", APICID3V2Frame.PictureType.Artist, "Artist image.", new byte[]{1, 2, 3, 4, 5});
            oAPIC.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addAPICFrame(oAPIC);
            oID3V2_3_0Tag.addAPICFrame(new APICID3V2Frame("image/jpeg", APICID3V2Frame.PictureType.FrontCover, "Front cover.", new byte[]{5, 4, 3, 2, 1}));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>bAPIC<bh:00><bh:00><bh:00>/<bh:00><bh:00><bh:01>image/png<bh:00><bh:08><bh:ff><bh:fe>A<bh:00>r<bh:00>t<bh:00>i<bh:00>s<bh:00>t<bh:00> <bh:00>i<bh:00>m<bh:00>a<bh:00>g<bh:00>e<bh:00>.<bh:00><bh:00><bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>APIC<bh:00><bh:00><bh:00><bh:1f><bh:00><bh:00><bh:00>image/jpeg<bh:00><bh:03>Front cover.<bh:00><bh:05><bh:04><bh:03><bh:02><bh:01>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testCOMMFrame() {
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.addCOMMFrame(new COMMID3V2Frame("eng", "short description", "actual text"));
            oID3V2_3_0Tag.addCOMMFrame(new COMMID3V2Frame("rus", "next description", "next actual text"));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>ZCOMM<bh:00><bh:00><bh:00>!<bh:00><bh:00><bh:00>engshort description<bh:00>actual textCOMM<bh:00><bh:00><bh:00>%<bh:00><bh:00><bh:00>rusnext description<bh:00>next actual text";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8559-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            COMMID3V2Frame oCOMM = new COMMID3V2Frame("eng", "short description", "actual text");
            oCOMM.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addCOMMFrame(oCOMM);
            oID3V2_3_0Tag.addCOMMFrame(new COMMID3V2Frame("rus", "next description", "next actual text"));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>{COMM<bh:00><bh:00><bh:00>B<bh:00><bh:00><bh:01>eng<bh:ff><bh:fe>s<bh:00>h<bh:00>o<bh:00>r<bh:00>t<bh:00> <bh:00>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00><bh:00><bh:00><bh:ff><bh:fe>a<bh:00>c<bh:00>t<bh:00>u<bh:00>a<bh:00>l<bh:00> <bh:00>t<bh:00>e<bh:00>x<bh:00>t<bh:00>COMM<bh:00><bh:00><bh:00>%<bh:00><bh:00><bh:00>rusnext description<bh:00>next actual text";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testCOMRFrame() {
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.setCOMRFrame(new COMRID3V2Frame("cad12.99", "25250101", "http://jid3.blinkenlights.org", 3, "seller", "description", "image/png", new byte[]{1, 2, 3, 4, 5}));
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>]COMR<bh:00><bh:00><bh:00>S<bh:00><bh:00><bh:00>cad12.99<bh:00>25250101http://jid3.blinkenlights.org<bh:00><bh:03>seller<bh:00>description<bh:00>image/png<bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            COMRID3V2Frame oCOMR = new COMRID3V2Frame("cad12.99", "25250101", "http://jid3.blinkenlights.org", 3, "seller", "description", "image/png", new byte[]{1, 2, 3, 4, 5});
            oCOMR.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setCOMRFrame(oCOMR);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>tCOMR<bh:00><bh:00><bh:00>j<bh:00><bh:00><bh:01>cad12.99<bh:00>25250101http://jid3.blinkenlights.org<bh:00><bh:03><bh:ff><bh:fe>s<bh:00>e<bh:00>l<bh:00>l<bh:00>e<bh:00>r<bh:00><bh:00><bh:00><bh:ff><bh:fe>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00><bh:00><bh:00>image/png<bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testENCRFrame() {
        String sPrefix;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.addENCRFrame(new ENCRID3V2Frame("http://jid3.blinkenlights.org", -128, new byte[]{1, 2, 3, 4, 5}));
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>.ENCR<bh:00><bh:00><bh:00>$<bh:00><bh:00>http://jid3.blinkenlights.org<bh:00><bh:80><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oID3V2_3_0Tag.addENCRFrame(new ENCRID3V2Frame("", -128, new byte[]{1, 2, 3, 4, 5}));
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:11>ENCR<bh:00><bh:00><bh:00><bh:07><bh:00><bh:00><bh:00><bh:80><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testEQUAFrame() {
        try {
            EQUAID3V2Frame oEQUA;
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            EQUAID3V2Frame eQUAID3V2Frame = oEQUA = new EQUAID3V2Frame(16);
            eQUAID3V2Frame.getClass();
            oEQUA.setAdjustment(new EQUAID3V2Frame.Adjustment(eQUAID3V2Frame, true, 16383, new byte[]{1, 2}));
            EQUAID3V2Frame eQUAID3V2Frame2 = oEQUA;
            eQUAID3V2Frame2.getClass();
            oEQUA.setAdjustment(new EQUAID3V2Frame.Adjustment(eQUAID3V2Frame2, false, Short.MAX_VALUE, new byte[]{3, 4}));
            oID3V2_3_0Tag.setEQUAFrame(oEQUA);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:13>EQUA<bh:00><bh:00><bh:00><bh:09><bh:00><bh:00><bh:10><bh:7f><bh:ff><bh:03><bh:04><bh:bf><bh:ff><bh:01><bh:02>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testETCOFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            ETCOID3V2Frame oETCO = new ETCOID3V2Frame(ETCOID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS);
            oETCO.addEvent(new ETCOID3V2Frame.Event(ETCOID3V2Frame.EventType.END_OF_INITIAL_SILENCE, 12));
            oETCO.addEvent(new ETCOID3V2Frame.Event(ETCOID3V2Frame.EventType.OUTRO_START, 23));
            oID3V2_3_0Tag.setETCOFrame(oETCO);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:15>ETCO<bh:00><bh:00><bh:00><bh:0b><bh:00><bh:00><bh:02><bh:01><bh:00><bh:00><bh:00><bh:0c><bh:04><bh:00><bh:00><bh:00><bh:17>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testGEOBFrame() {
        String sPrefix;
        GEOBID3V2Frame oGEOB;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oGEOB = new GEOBID3V2Frame("image/png", "filename", "content description", new byte[]{1, 2, 3, 4, 5});
            oID3V2_3_0Tag.addGEOBFrame(oGEOB);
            oGEOB = new GEOBID3V2Frame("image/jpeg", "filename2", "another content description", new byte[]{5, 4, 3, 2, 1});
            oID3V2_3_0Tag.addGEOBFrame(oGEOB);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>xGEOB<bh:00><bh:00><bh:00>7<bh:00><bh:00><bh:00>image/jpeg<bh:00>filename2<bh:00>another content description<bh:00><bh:05><bh:04><bh:03><bh:02><bh:01>GEOB<bh:00><bh:00><bh:00>-<bh:00><bh:00><bh:00>image/png<bh:00>filename<bh:00>content description<bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8559-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oGEOB = new GEOBID3V2Frame("image/png", "filename", "content description", new byte[]{1, 2, 3, 4, 5});
            oGEOB.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addGEOBFrame(oGEOB);
            oGEOB = new GEOBID3V2Frame("image/jpeg", "filename2", "another content description", new byte[]{5, 4, 3, 2, 1});
            oID3V2_3_0Tag.addGEOBFrame(oGEOB);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:01><bh:19>GEOB<bh:00><bh:00><bh:00>7<bh:00><bh:00><bh:00>image/jpeg<bh:00>filename2<bh:00>another content description<bh:00><bh:05><bh:04><bh:03><bh:02><bh:01>GEOB<bh:00><bh:00><bh:00>N<bh:00><bh:00><bh:01>image/png<bh:00><bh:ff><bh:fe>f<bh:00>i<bh:00>l<bh:00>e<bh:00>n<bh:00>a<bh:00>m<bh:00>e<bh:00><bh:00><bh:00><bh:ff><bh:fe>c<bh:00>o<bh:00>n<bh:00>t<bh:00>e<bh:00>n<bh:00>t<bh:00> <bh:00>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>i<bh:00>o<bh:00>n<bh:00><bh:00><bh:00><bh:01><bh:02><bh:03><bh:04><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testGRIDFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            GRIDID3V2Frame oGRID = new GRIDID3V2Frame("http://jid3.blinkenlights.org", -120, new byte[]{1, 2, 3, 4, 5});
            oID3V2_3_0Tag.addGRIDFrame(oGRID);
            oGRID = new GRIDID3V2Frame("http://abcd.blinkenlights.org", 34, new byte[]{5, 4, 3, 2, 1});
            oID3V2_3_0Tag.addGRIDFrame(oGRID);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:5c>GRID<bh:00><bh:00><bh:00>$<bh:00><bh:00>http://jid3.blinkenlights.org<bh:00><bh:88><bh:01><bh:02><bh:03><bh:04><bh:05>GRID<bh:00><bh:00><bh:00>$<bh:00><bh:00>http://abcd.blinkenlights.org<bh:00>\"<bh:05><bh:04><bh:03><bh:02><bh:01>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testIPLSFrame() {
        String sPrefix;
        IPLSID3V2Frame oIPLS;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oIPLS = new IPLSID3V2Frame();
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement1", "person1"));
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement1", "person2"));
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement2", "person3"));
            oID3V2_3_0Tag.setIPLSFrame(oIPLS);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>JIPLS<bh:00><bh:00><bh:00>@<bh:00><bh:00><bh:00>involvement1<bh:00>person1<bh:00>involvement1<bh:00>person2<bh:00>involvement2<bh:00>person3<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oIPLS = new IPLSID3V2Frame();
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement1", "person1"));
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement1", "person2"));
            oIPLS.addInvolvedPerson(new IPLSID3V2Frame.InvolvedPerson("involvement2", "person3"));
            oIPLS.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setIPLSFrame(oIPLS);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:01><bh:15>IPLS<bh:00><bh:00><bh:00><bh:8b><bh:00><bh:00><bh:01><bh:ff><bh:fe>i<bh:00>n<bh:00>v<bh:00>o<bh:00>l<bh:00>v<bh:00>e<bh:00>m<bh:00>e<bh:00>n<bh:00>t<bh:00>1<bh:00><bh:00><bh:00><bh:ff><bh:fe>p<bh:00>e<bh:00>r<bh:00>s<bh:00>o<bh:00>n<bh:00>1<bh:00><bh:00><bh:00><bh:ff><bh:fe>i<bh:00>n<bh:00>v<bh:00>o<bh:00>l<bh:00>v<bh:00>e<bh:00>m<bh:00>e<bh:00>n<bh:00>t<bh:00>1<bh:00><bh:00><bh:00><bh:ff><bh:fe>p<bh:00>e<bh:00>r<bh:00>s<bh:00>o<bh:00>n<bh:00>2<bh:00><bh:00><bh:00><bh:ff><bh:fe>i<bh:00>n<bh:00>v<bh:00>o<bh:00>l<bh:00>v<bh:00>e<bh:00>m<bh:00>e<bh:00>n<bh:00>t<bh:00>2<bh:00><bh:00><bh:00><bh:ff><bh:fe>p<bh:00>e<bh:00>r<bh:00>s<bh:00>o<bh:00>n<bh:00>3<bh:00><bh:00><bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testLINKFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            LINKID3V2Frame oLINK = new LINKID3V2Frame("TAG1".getBytes(), "filelocation1", "additionaldata1");
            oID3V2_3_0Tag.addLINKFrame(oLINK);
            oLINK = new LINKID3V2Frame("TAG2".getBytes(), "filelocation2", "additionaldata2");
            oID3V2_3_0Tag.addLINKFrame(oLINK);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>VLINK<bh:00><bh:00><bh:00>!<bh:00><bh:00>TAG1filelocation1<bh:00>additionaldata1LINK<bh:00><bh:00><bh:00>!<bh:00><bh:00>TAG2filelocation2<bh:00>additionaldata2";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testMCDIFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            MCDIID3V2Frame oMCDI = new MCDIID3V2Frame(new byte[]{1, 2, 3, 4});
            oID3V2_3_0Tag.setMCDIFrame(oMCDI);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>MCDI<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:01><bh:02><bh:03><bh:04>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testMLLTFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            MLLTID3V2Frame oMLLT = new MLLTID3V2Frame(new byte[]{1, 2, 3, 4});
            oID3V2_3_0Tag.setMLLTFrame(oMLLT);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>MLLT<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:01><bh:02><bh:03><bh:04>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testOWNEFrame() {
        String sPrefix;
        OWNEID3V2Frame oOWNE;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oOWNE = new OWNEID3V2Frame("cad12.34", "20000102", "seller");
            oID3V2_3_0Tag.setOWNEFrame(oOWNE);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>\"OWNE<bh:00><bh:00><bh:00><bh:18><bh:00><bh:00><bh:00>cad12.34<bh:00>20000102seller";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8559-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oOWNE = new OWNEID3V2Frame("cad12.34", "20000102", "seller");
            oOWNE.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setOWNEFrame(oOWNE);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>*OWNE<bh:00><bh:00><bh:00> <bh:00><bh:00><bh:01>cad12.34<bh:00>20000102<bh:ff><bh:fe>s<bh:00>e<bh:00>l<bh:00>l<bh:00>e<bh:00>r<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testPRIVFrame() {
        try {
            ID3Tag.useStrict(true);
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            PRIVID3V2Frame oPRIV = new PRIVID3V2Frame("abcdefghijklmnopqrstuvwxyz", new byte[]{1, 2, 3, 4});
            oID3V2_3_0Tag.addPRIVFrame(oPRIV);
            try {
                oID3V2_3_0Tag.addPRIVFrame(oPRIV);
                ID3V2Test.fail((String)"Adding the same PRIV frame to a tag twice should have generated an exception.");
            }
            catch (Exception e) {
                // empty catch block
            }
            oPRIV = new PRIVID3V2Frame("owner identifier", "private data".getBytes());
            oID3V2_3_0Tag.addPRIVFrame(oPRIV);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>PPRIV<bh:00><bh:00><bh:00><bh:1f><bh:00><bh:00>abcdefghijklmnopqrstuvwxyz<bh:00><bh:01><bh:02><bh:03><bh:04>PRIV<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00>owner identifier<bh:00>private data";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testPCNTFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            PCNTID3V2Frame oPCNT = new PCNTID3V2Frame(42);
            oID3V2_3_0Tag.setPCNTFrame(oPCNT);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>PCNT<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:00><bh:00><bh:00>*";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testPOPMFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            POPMID3V2Frame oPOPM = new POPMID3V2Frame("user@domain.com", 42, 12345);
            oID3V2_3_0Tag.addPOPMFrame(oPOPM);
            oPOPM = new POPMID3V2Frame("user@otherdomain.com", 43);
            oID3V2_3_0Tag.addPOPMFrame(oPOPM);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>?POPM<bh:00><bh:00><bh:00><bh:15><bh:00><bh:00>user@domain.com<bh:00>*<bh:00><bh:00>09POPM<bh:00><bh:00><bh:00><bh:16><bh:00><bh:00>user@otherdomain.com<bh:00>+";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testPOSSFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            POSSID3V2Frame oPOSS = new POSSID3V2Frame(POSSID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, 12345);
            oID3V2_3_0Tag.setPOSSFrame(oPOSS);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>POSS<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:02><bh:00><bh:00>09";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testRBUFFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            RBUFID3V2Frame oRBUF = new RBUFID3V2Frame(123456, true, 42);
            oID3V2_3_0Tag.setRBUFFrame(oRBUF);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:12>RBUF<bh:00><bh:00><bh:00><bh:08><bh:00><bh:00><bh:01><bh:e2>@<bh:01><bh:00><bh:00><bh:00>*";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
            oRBUF = new RBUFID3V2Frame(123456, false);
            oID3V2_3_0Tag.setRBUFFrame(oRBUF);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>RBUF<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:01><bh:e2>@<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testRVADFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            RVADID3V2Frame oRVAD = new RVADID3V2Frame(new byte[]{1, 2, 3, 4});
            oID3V2_3_0Tag.setRVADFrame(oRVAD);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0e>RVAD<bh:00><bh:00><bh:00><bh:04><bh:00><bh:00><bh:01><bh:02><bh:03><bh:04>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testRVRBFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            RVRBID3V2Frame oRVRB = new RVRBID3V2Frame(12345, 54321, 1, 2, 3, 4, 5, 6, 7, 8);
            oID3V2_3_0Tag.setRVRBFrame(oRVRB);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:16>RVRB<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>09<bh:d4>1<bh:01><bh:02><bh:03><bh:04><bh:05><bh:06><bh:07><bh:08>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testSYLTFrame() {
        String sPrefix;
        SYLTID3V2Frame oSYLT;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oSYLT = new SYLTID3V2Frame("eng", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, SYLTID3V2Frame.ContentType.LYRICS, "content descriptor");
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("one", 1));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("three", 3));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("two", 2));
            oID3V2_3_0Tag.addSYLTFrame(oSYLT);
            oSYLT = new SYLTID3V2Frame("rus", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MPEG_FRAMES, SYLTID3V2Frame.ContentType.TRIVIA, "another description");
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("abc", 4));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("def", 5));
            oID3V2_3_0Tag.addSYLTFrame(oSYLT);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>qSYLT<bh:00><bh:00><bh:00>3<bh:00><bh:00><bh:00>eng<bh:02><bh:01>content descriptor<bh:00>one<bh:00><bh:00><bh:00><bh:00><bh:01>two<bh:00><bh:00><bh:00><bh:00><bh:02>three<bh:00><bh:00><bh:00><bh:00><bh:03>SYLT<bh:00><bh:00><bh:00>*<bh:00><bh:00><bh:00>rus<bh:01><bh:06>another description<bh:00>abc<bh:00><bh:00><bh:00><bh:00><bh:04>def<bh:00><bh:00><bh:00><bh:00><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oSYLT = new SYLTID3V2Frame("eng", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, SYLTID3V2Frame.ContentType.LYRICS, "content descriptor");
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("one", 1));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("three", 3));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("two", 2));
            oSYLT.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addSYLTFrame(oSYLT);
            oSYLT = new SYLTID3V2Frame("rus", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MPEG_FRAMES, SYLTID3V2Frame.ContentType.TRIVIA, "another description");
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("abc", 4));
            oSYLT.addSyncEntry(new SYLTID3V2Frame.SyncEntry("def", 5));
            oID3V2_3_0Tag.addSYLTFrame(oSYLT);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:01><bh:1a>SYLT<bh:00><bh:00><bh:00><bh:5c><bh:00><bh:00><bh:01>eng<bh:02><bh:01><bh:ff><bh:fe>c<bh:00>o<bh:00>n<bh:00>t<bh:00>e<bh:00>n<bh:00>t<bh:00> <bh:00>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>o<bh:00>r<bh:00><bh:00><bh:00><bh:ff><bh:fe>o<bh:00>n<bh:00>e<bh:00><bh:00><bh:00><bh:00><bh:00><bh:00><bh:01><bh:ff><bh:fe>t<bh:00>w<bh:00>o<bh:00><bh:00><bh:00><bh:00><bh:00><bh:00><bh:02><bh:ff><bh:fe>t<bh:00>h<bh:00>r<bh:00>e<bh:00>e<bh:00><bh:00><bh:00><bh:00><bh:00><bh:00><bh:03>SYLT<bh:00><bh:00><bh:00>*<bh:00><bh:00><bh:00>rus<bh:01><bh:06>another description<bh:00>abc<bh:00><bh:00><bh:00><bh:00><bh:04>def<bh:00><bh:00><bh:00><bh:00><bh:05>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testSYTCFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            SYTCID3V2Frame oSYTC = new SYTCID3V2Frame(SYTCID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS);
            oSYTC.addTempoChange(new SYTCID3V2Frame.TempoChange(12, 1));
            oSYTC.addTempoChange(new SYTCID3V2Frame.TempoChange(255, 2));
            oSYTC.addTempoChange(new SYTCID3V2Frame.TempoChange(510, 3));
            oID3V2_3_0Tag.setSYTCFrame(oSYTC);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:1c>SYTC<bh:00><bh:00><bh:00><bh:12><bh:00><bh:00><bh:02><bh:0c><bh:00><bh:00><bh:00><bh:01><bh:ff><bh:00><bh:00><bh:00><bh:00><bh:02><bh:ff><bh:ff><bh:00><bh:00><bh:00><bh:03>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testUFIDFrame() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            UFIDID3V2Frame oUFID = new UFIDID3V2Frame("owner identifier", new byte[]{1, 2, 3, 4});
            oID3V2_3_0Tag.addUFIDFrame(oUFID);
            oUFID = new UFIDID3V2Frame("owner two", new byte[]{4, 3, 2, 1});
            oID3V2_3_0Tag.addUFIDFrame(oUFID);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>7UFID<bh:00><bh:00><bh:00><bh:15><bh:00><bh:00>owner identifier<bh:00><bh:01><bh:02><bh:03><bh:04>UFID<bh:00><bh:00><bh:00><bh:0e><bh:00><bh:00>owner two<bh:00><bh:04><bh:03><bh:02><bh:01>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testUSERFrame() {
        String sPrefix;
        USERID3V2Frame oUSER;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oUSER = new USERID3V2Frame("eng", "Terms of use.");
            oID3V2_3_0Tag.setUSERFrame(oUSER);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:1b>USER<bh:00><bh:00><bh:00><bh:11><bh:00><bh:00><bh:00>engTerms of use.";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("ISO-8859-1 test: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oUSER = new USERID3V2Frame("eng", "Terms of use.");
            oUSER.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.setUSERFrame(oUSER);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>*USER<bh:00><bh:00><bh:00> <bh:00><bh:00><bh:01>eng<bh:ff><bh:fe>T<bh:00>e<bh:00>r<bh:00>m<bh:00>s<bh:00> <bh:00>o<bh:00>f<bh:00> <bh:00>u<bh:00>s<bh:00>e<bh:00>.<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unicode test: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testUSLTFrame() {
        String sPrefix;
        USLTID3V2Frame oUSLT;
        ID3V2_3_0Tag oID3V2_3_0Tag;
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oUSLT = new USLTID3V2Frame("eng", "content descriptor", "lyrics");
            oID3V2_3_0Tag.addUSLTFrame(oUSLT);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'USLT<bh:00><bh:00><bh:00><bh:1d><bh:00><bh:00><bh:00>engcontent descriptor<bh:00>lyrics";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
        try {
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oUSLT = new USLTID3V2Frame("eng", "content descriptor", "lyrics");
            oUSLT.setTextEncoding(TextEncoding.UNICODE);
            oID3V2_3_0Tag.addUSLTFrame(oUSLT);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>DUSLT<bh:00><bh:00><bh:00>:<bh:00><bh:00><bh:01>eng<bh:ff><bh:fe>c<bh:00>o<bh:00>n<bh:00>t<bh:00>e<bh:00>n<bh:00>t<bh:00> <bh:00>d<bh:00>e<bh:00>s<bh:00>c<bh:00>r<bh:00>i<bh:00>p<bh:00>t<bh:00>o<bh:00>r<bh:00><bh:00><bh:00><bh:ff><bh:fe>l<bh:00>y<bh:00>r<bh:00>i<bh:00>c<bh:00>s<bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testUnsynchronization() {
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            PRIVID3V2Frame oPRIV = new PRIVID3V2Frame("owner", new byte[]{1, 2, -1, -16, 3, 4});
            oID3V2_3_0Tag.addPRIVFrame(oPRIV);
            oID3V2_3_0Tag.setUnsynchronization(true);
            String sPrefix = "ID3<bh:03><bh:00><bh:80><bh:00><bh:00><bh:00><bh:17>PRIV<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>owner<bh:00><bh:01><bh:02><bh:ff><bh:00><bh:f0><bh:03><bh:04>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
            oID3V2_3_0Tag.setUnsynchronization(false);
            sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:16>PRIV<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>owner<bh:00><bh:01><bh:02><bh:ff><bh:f0><bh:03><bh:04>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
            oID3V2_3_0Tag = new ID3V2_3_0Tag();
            oPRIV = new PRIVID3V2Frame("owner", new byte[]{1, 2, -1, -16, 3, -1});
            oID3V2_3_0Tag.addPRIVFrame(oPRIV);
            oID3V2_3_0Tag.setUnsynchronization(true);
            sPrefix = "ID3<bh:03><bh:00><bh:80><bh:00><bh:00><bh:00><bh:18>PRIV<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>owner<bh:00><bh:01><bh:02><bh:ff><bh:00><bh:f0><bh:03><bh:ff><bh:00>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testConveienceMethods() {
        try {
            ID3Util.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V2Tag oID3V2Tag = new ID3V2_3_0Tag();
            oID3V2Tag.setArtist("Artist");
            oID3V2Tag.setTitle("Song Title");
            oID3V2Tag.setAlbum("Album");
            oID3V2Tag.setYear(2004);
            oID3V2Tag.setTrackNumber(3, 9);
            oID3V2Tag.setGenre("Blues");
            oMediaFile.setID3Tag(oID3V2Tag);
            ((MediaFile)oMediaFile).sync();
            oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            oID3V2Tag = (ID3V2Tag)aoID3Tag[0];
            if (!oID3V2Tag.getArtist().equals("Artist")) {
                ID3V2Test.fail((String)("Set/get artist by convenience methods do not return what was set.  Returned [" + oID3V2Tag.getArtist() + "]"));
            }
            if (!oID3V2Tag.getTitle().equals("Song Title")) {
                ID3V2Test.fail((String)("Set/get song title by convenience methods do not return what was set.  Returned [" + oID3V2Tag.getTitle() + "]"));
            }
            if (!oID3V2Tag.getAlbum().equals("Album")) {
                ID3V2Test.fail((String)("Set/get album by convenience methods do not return what was set.  Returned [" + oID3V2Tag.getAlbum() + "]"));
            }
            if (oID3V2Tag.getYear() != 2004) {
                ID3V2Test.fail((String)("Set/get year by convenience methods do not return what was set.  Returned [" + oID3V2Tag.getYear() + "]"));
            }
            if (oID3V2Tag.getTrackNumber() != 3 || oID3V2Tag.getTotalTracks() != 9) {
                ID3V2Test.fail((String)("Set/get track number convenience methods do not return what was set.  Returned [" + oID3V2Tag.getTrackNumber() + "/" + oID3V2Tag.getTotalTracks() + "]"));
            }
            if (!oID3V2Tag.getGenre().equals("Blues")) {
                ID3V2Test.fail((String)("Set/get genre convenience methods do not return what was set.  Returned [" + oID3V2Tag.getGenre() + "]"));
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testIFileSource() {
        try {
            ID3Util.copy(AllTests.s_RootPath + "v1_1tags.mp3", AllTests.s_RootPath + "id3_v1_1_tagtest.mp3");
            File oFile = new File(AllTests.s_RootPath + "id3_v1_1_tagtest.mp3");
            FileSource oFileSource = new FileSource(oFile);
            MP3File oMP3File = new MP3File(oFileSource);
            ID3V1Tag oID3Tag = oMP3File.getID3V1Tag();
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testExtendedHeader() {
        try {
            ID3Util.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V2Tag oID3V2Tag = new ID3V2_3_0Tag();
            oID3V2Tag.setArtist("Artist");
            oID3V2Tag.setExtendedHeader(true);
            oID3V2Tag.setCRC(true);
            oID3V2Tag.setPaddingLength(5);
            oMediaFile.setID3Tag(oID3V2Tag);
            ((MediaFile)oMediaFile).sync();
            oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            oID3V2Tag = (ID3V2Tag)aoID3Tag[0];
            if (!oID3V2Tag.getExtendedHeader()) {
                ID3V2Test.fail((String)"Set extended header before writing.  Not set on reading back.");
            }
            if (!oID3V2Tag.getCRC()) {
                ID3V2Test.fail((String)"Set CRC before writing.  Not set on reading back.");
            }
            if (!oID3V2Tag.getArtist().equals("Artist")) {
                ID3V2Test.fail((String)("Unexpected artist value.  Returned [" + oID3V2Tag.getArtist() + "]"));
            }
            oMediaFile = new MP3File(oSourceFile);
            oID3V2Tag = new ID3V2_3_0Tag();
            oID3V2Tag.setArtist("Artist");
            oID3V2Tag.setExtendedHeader(true);
            oID3V2Tag.setPaddingLength(5);
            oMediaFile.setID3Tag(oID3V2Tag);
            ((MediaFile)oMediaFile).sync();
            oMediaFile = new MP3File(oSourceFile);
            aoID3Tag = ((MediaFile)oMediaFile).getTags();
            oID3V2Tag = (ID3V2Tag)aoID3Tag[0];
            if (!oID3V2Tag.getExtendedHeader()) {
                ID3V2Test.fail((String)"Set extended header before writing.  Not set on reading back.");
            }
            if (oID3V2Tag.getCRC()) {
                ID3V2Test.fail((String)"Did not set CRC before writing.  CRC set on reading back.");
            }
            if (!oID3V2Tag.getArtist().equals("Artist")) {
                ID3V2Test.fail((String)("Unexpected artist value.  Returned [" + oID3V2Tag.getArtist() + "]"));
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testFailOnZeroFrames() {
        try {
            ID3Util.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V2_3_0Tag oID3V2Tag = new ID3V2_3_0Tag();
            oMediaFile.setID3Tag(oID3V2Tag);
            try {
                ((MediaFile)oMediaFile).sync();
            }
            catch (Exception e2) {
                return;
            }
            ID3V2Test.fail((String)"We successfully sync'ed a v2 tag with no frames, when we should have failed.");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseStrict() {
        try {
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>TYER<bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>abcd";
            String sSourceFile = AllTests.s_RootPath + "id3_v2_3_0_invalid.mp3";
            FileInputStream oFIS = null;
            FileOutputStream oFOS = null;
            try {
                int iNumRead;
                oFIS = new FileInputStream(AllTests.s_RootPath + "notags.mp3");
                oFOS = new FileOutputStream(sSourceFile);
                oFOS.write(ID3Util.convertFrhedToByteArray(sPrefix));
                byte[] abyBuffer = new byte[16384];
                while ((iNumRead = oFIS.read(abyBuffer)) != -1) {
                    oFOS.write(abyBuffer, 0, iNumRead);
                }
                oFOS.flush();
            }
            finally {
                try {
                    oFIS.close();
                }
                catch (Exception e) {}
                try {
                    oFOS.close();
                }
                catch (Exception e) {}
            }
            ID3Tag.useStrict(false);
            MP3File oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
                ID3V2_3_0Tag oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                if (oID3V2_3_0Tag.getTYERTextInformationFrame() != null) {
                    ID3V2Test.fail((String)"The invalid TYER frame should have been ignored when read in non-strict mode.");
                }
            }
            catch (Exception e) {
                ID3V2Test.fail((String)("With non-strict setting, reading this invalid file should not have generated an exception: " + ID3Exception.getStackTrace(e)));
            }
            ID3Tag.useStrict(true);
            oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ((MediaFile)oMediaFile).getTags();
                ID3V2Test.fail((String)"With strict setting, reading this invalid file should have generated an exception.");
            }
            catch (InvalidFrameID3Exception e) {}
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidFrameId() {
        try {
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00><bh:0f>COM <bh:00><bh:00><bh:00><bh:05><bh:00><bh:00><bh:00>abcd";
            String sSourceFile = AllTests.s_RootPath + "id3_v2_3_0_invalid.mp3";
            FileInputStream oFIS = null;
            FileOutputStream oFOS = null;
            try {
                int iNumRead;
                oFIS = new FileInputStream(AllTests.s_RootPath + "notags.mp3");
                oFOS = new FileOutputStream(sSourceFile);
                oFOS.write(ID3Util.convertFrhedToByteArray(sPrefix));
                byte[] abyBuffer = new byte[16384];
                while ((iNumRead = oFIS.read(abyBuffer)) != -1) {
                    oFOS.write(abyBuffer, 0, iNumRead);
                }
                oFOS.flush();
            }
            finally {
                try {
                    oFIS.close();
                }
                catch (Exception e) {}
                try {
                    oFOS.close();
                }
                catch (Exception e) {}
            }
            ID3Tag.useStrict(false);
            MP3File oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
                ID3V2_3_0Tag oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                UnknownID3V2Frame[] aoUnknownID3V2Frame = oID3V2_3_0Tag.getUnknownFrames();
                if (aoUnknownID3V2Frame.length != 1) {
                    ID3V2Test.fail((String)"There should be one unknown frame in this tag when read in non-strict mode.");
                }
                if (!new String(aoUnknownID3V2Frame[0].getFrameId()).equals("COM ")) {
                    ID3V2Test.fail((String)"The one unknown frame in this tag should have a frame ID of 'COM '.");
                }
            }
            catch (Exception e) {
                ID3V2Test.fail((String)("With non-strict setting, reading this invalid file should not have generated an exception: " + ID3Exception.getStackTrace(e)));
            }
            ID3Tag.useStrict(true);
            oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ((MediaFile)oMediaFile).getTags();
                ID3V2Test.fail((String)"With strict setting, reading this invalid file should have generated an exception.");
            }
            catch (InvalidFrameID3Exception e) {}
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testWriteUnknownFrame() {
        ID3Tag.useStrict(false);
        try {
            ID3Util.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v2_3_0_tagtest.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            byte[] abyFrameData = new byte[]{1, 2, 3, 4};
            UnknownID3V2Frame oUnknownID3V2Frame = new UnknownID3V2Frame("ABCD", abyFrameData);
            oID3V2_3_0Tag.addUnknownFrame(oUnknownID3V2Frame);
            oMediaFile.setID3Tag(oID3V2_3_0Tag);
            ((MediaFile)oMediaFile).sync();
            oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
            UnknownID3V2Frame[] aoUnknownID3V2Frame = oID3V2_3_0Tag.getUnknownFrames();
            if (aoUnknownID3V2Frame.length != 1) {
                ID3V2Test.fail((String)"Expected to find one unknown frame after reading tag back.");
            }
            if (!oUnknownID3V2Frame.equals(aoUnknownID3V2Frame[0])) {
                ID3V2Test.fail((String)"Unknown tag before and after writing are not identical.");
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testReadRandomMP3s() {
        ID3Tag.useStrict(false);
        try {
            File oSourceDir = new File("c:/temp/mp3");
            this.recurseDirectoryForMP3s(oSourceDir);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    private void recurseDirectoryForMP3s(File oDirectory) throws Exception {
        File[] aoMP3File = this.getMP3FileList(oDirectory);
        for (int i = 0; i < aoMP3File.length; ++i) {
            MP3File oMP3File = new MP3File(aoMP3File[i]);
            try {
                oMP3File.getTags();
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failed reading MP3 tags from " + aoMP3File[i] + ".", e);
            }
        }
        File[] aoDirectory = this.getSubDirectories(oDirectory);
        for (int i = 0; i < aoDirectory.length; ++i) {
            System.out.println("Recursing into subdirectory: " + aoDirectory[i].getAbsolutePath());
            this.recurseDirectoryForMP3s(aoDirectory[i]);
        }
    }

    private File[] getMP3FileList(File oDirectory) {
        File[] aoMP3File = oDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File oFile, String sName) {
                return sName.toLowerCase().endsWith(".mp3");
            }
        });
        return aoMP3File;
    }

    private File[] getSubDirectories(File oDirectory) {
        File[] aoDirectory = oDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File oFile, String sName) {
                File oPotential = new File(oFile, sName);
                return oPotential.isDirectory();
            }
        });
        return aoDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadDuplicateFrames() {
        try {
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>8COMM<bh:00><bh:00><bh:00><bh:12><bh:00><bh:00><bh:00>engabcd<bh:00>Comment 1COMM<bh:00><bh:00><bh:00><bh:12><bh:00><bh:00><bh:00>engabcd<bh:00>Comment 2";
            String sSourceFile = AllTests.s_RootPath + "id3_v2_3_0_duplicate.mp3";
            FileInputStream oFIS = null;
            FileOutputStream oFOS = null;
            try {
                int iNumRead;
                oFIS = new FileInputStream(AllTests.s_RootPath + "notags.mp3");
                oFOS = new FileOutputStream(sSourceFile);
                oFOS.write(ID3Util.convertFrhedToByteArray(sPrefix));
                byte[] abyBuffer = new byte[16384];
                while ((iNumRead = oFIS.read(abyBuffer)) != -1) {
                    oFOS.write(abyBuffer, 0, iNumRead);
                }
                oFOS.flush();
            }
            finally {
                try {
                    oFIS.close();
                }
                catch (Exception e) {}
                try {
                    oFOS.close();
                }
                catch (Exception e) {}
            }
            ID3Tag.useStrict(false);
            MP3File oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
                ID3V2_3_0Tag oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                COMMID3V2Frame[] aoCOMMID3V2Frame = oID3V2_3_0Tag.getCOMMFrames();
                if (aoCOMMID3V2Frame.length != 1) {
                    ID3V2Test.fail((String)"In non-strict mode, exactly one of the duplicate COMM frames in this file should have been kept.");
                }
                if (!aoCOMMID3V2Frame[0].getActualText().equals("Comment 2")) {
                    ID3V2Test.fail((String)"In non-strict mode, when duplicate COMM frames are ignored, the last one read should be kept.");
                }
            }
            catch (Exception e) {
                ID3V2Test.fail((String)("With non-strict setting, reading this invalid file should not have generated an exception: " + ID3Exception.getStackTrace(e)));
            }
            ID3Tag.useStrict(true);
            oMediaFile = new MP3File(new File(sSourceFile));
            try {
                ((MediaFile)oMediaFile).getTags();
                ID3V2Test.fail((String)"With strict setting, reading a file with duplicate COMM frames should have generated an exception.");
            }
            catch (ID3Exception e) {}
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    public void testFrameConflicts() {
        ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
        AENCID3V2Frame oAENC1 = null;
        AENCID3V2Frame oAENC2 = null;
        AENCID3V2Frame oAENC3 = null;
        try {
            oAENC1 = new AENCID3V2Frame("owner1", 1, 2, new byte[]{1});
            oID3V2_3_0Tag.addAENCFrame(oAENC1);
            oAENC2 = new AENCID3V2Frame("owner2", 3, 4, new byte[]{2});
            oID3V2_3_0Tag.addAENCFrame(oAENC2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two AENC frames.");
        }
        try {
            oAENC2.setOwnerIdentifier("owner1");
            ID3V2Test.fail((String)"We should not have been able to set two AENC frames with the same owner identifier.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oAENC1.setOwnerIdentifier("owner3");
            oAENC3 = new AENCID3V2Frame("owner3", 1, 2, new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third AENC frmaes.");
        }
        try {
            oID3V2_3_0Tag.addAENCFrame(oAENC3);
            ID3V2Test.fail((String)"We should not have been able to add a new AENC frame with the same owner identifier as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        APICID3V2Frame oAPIC1 = null;
        APICID3V2Frame oAPIC2 = null;
        APICID3V2Frame oAPIC3 = null;
        try {
            oAPIC1 = new APICID3V2Frame("image/gif", APICID3V2Frame.PictureType.Artist, "artist1", new byte[]{1});
            oID3V2_3_0Tag.addAPICFrame(oAPIC1);
            oAPIC2 = new APICID3V2Frame("image/gif", APICID3V2Frame.PictureType.Artist, "artist2", new byte[]{2});
            oID3V2_3_0Tag.addAPICFrame(oAPIC2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two APIC frames.");
        }
        try {
            oAPIC2.setDescription("artist1");
            ID3V2Test.fail((String)"We should not have been able to set two APIC frames with the same description.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oAPIC1.setDescription("artist3");
            oAPIC3 = new APICID3V2Frame("image/gif", APICID3V2Frame.PictureType.Artist, "artist3", new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third APIC frmaes.");
        }
        try {
            oID3V2_3_0Tag.addAPICFrame(oAPIC3);
            ID3V2Test.fail((String)"We should not have been able to add a new APIC frame with the same description as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        COMMID3V2Frame oCOMM1 = null;
        COMMID3V2Frame oCOMM2 = null;
        COMMID3V2Frame oCOMM3 = null;
        try {
            oCOMM1 = new COMMID3V2Frame("eng", "short1", "Comment 1.");
            oID3V2_3_0Tag.addCOMMFrame(oCOMM1);
            oCOMM2 = new COMMID3V2Frame("eng", "short2", "Comment 2.");
            oID3V2_3_0Tag.addCOMMFrame(oCOMM2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two COMM frames.");
        }
        try {
            oCOMM2.setComment("eng", "short1", "Comment 2.");
            ID3V2Test.fail((String)"We should not have been able to set two COMM frames with the same language and short description.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oCOMM1.setComment("eng", "short3", "Comment 1.");
            oCOMM3 = new COMMID3V2Frame("eng", "short3", "Comment 3.");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third COMM frmaes.");
        }
        try {
            oID3V2_3_0Tag.addCOMMFrame(oCOMM3);
            ID3V2Test.fail((String)"We should not have been able to add a new COMM frame with the same language and short description as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        ENCRID3V2Frame oENCR1 = null;
        ENCRID3V2Frame oENCR2 = null;
        ENCRID3V2Frame oENCR3 = null;
        try {
            oENCR1 = new ENCRID3V2Frame("owner1", -127, new byte[]{1});
            oID3V2_3_0Tag.addENCRFrame(oENCR1);
            oENCR2 = new ENCRID3V2Frame("owner2", -126, new byte[]{2});
            oID3V2_3_0Tag.addENCRFrame(oENCR2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two ENCR frames.");
        }
        try {
            oENCR2.setEncryptionDetails("owner1", (byte)-127, new byte[]{1});
            ID3V2Test.fail((String)"We should not have been able to set two ENCR frames with the same method symbol and owner identifier.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oENCR1.setEncryptionDetails("owner3", (byte)-127, new byte[]{1});
            oENCR3 = new ENCRID3V2Frame("owner3", -125, new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third ENCR frmaes.");
        }
        try {
            oID3V2_3_0Tag.addENCRFrame(oENCR3);
            ID3V2Test.fail((String)"We should not have been able to add a new ENCR frame with the same owner identifier as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oENCR1.setEncryptionDetails("owner1", (byte)-127, new byte[]{1});
            oENCR3 = new ENCRID3V2Frame("owner3", -127, new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and recreate the third ENCR frmaes.");
        }
        try {
            oID3V2_3_0Tag.addENCRFrame(oENCR3);
            ID3V2Test.fail((String)"We should not have been able to add a new ENCR frame with the same method symbol as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        GEOBID3V2Frame oGEOB1 = null;
        GEOBID3V2Frame oGEOB2 = null;
        GEOBID3V2Frame oGEOB3 = null;
        try {
            oGEOB1 = new GEOBID3V2Frame("text/html", "filename1.html", "contentdescription1", new byte[]{1});
            oID3V2_3_0Tag.addGEOBFrame(oGEOB1);
            oGEOB2 = new GEOBID3V2Frame("text/html", "filename2.html", "contentdescription2", new byte[]{2});
            oID3V2_3_0Tag.addGEOBFrame(oGEOB2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two GEOB frames.");
        }
        try {
            oGEOB2.setEncapsulatedObject("text/html", "filename2.html", "contentdescription1", new byte[]{2});
            ID3V2Test.fail((String)"We should not have been able to set two GEOB frames with the same content description.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oGEOB1.setEncapsulatedObject("text/html", "filename1.html", "contentdescription3", new byte[]{1});
            oGEOB3 = new GEOBID3V2Frame("text/html", "filename3.html", "contentdescription3", new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third GEOB frmaes.");
        }
        try {
            oID3V2_3_0Tag.addGEOBFrame(oGEOB3);
            ID3V2Test.fail((String)"We should not have been able to add a new GEOB frame with the same content description as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        GRIDID3V2Frame oGRID1 = null;
        GRIDID3V2Frame oGRID2 = null;
        GRIDID3V2Frame oGRID3 = null;
        try {
            oGRID1 = new GRIDID3V2Frame("owner1", 1, new byte[]{1});
            oID3V2_3_0Tag.addGRIDFrame(oGRID1);
            oGRID2 = new GRIDID3V2Frame("owner2", 2, new byte[]{2});
            oID3V2_3_0Tag.addGRIDFrame(oGRID2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two GRID frames.");
        }
        try {
            oGRID2.setGroupIdentificationRegistration("owner1", (byte)1, new byte[]{2});
            ID3V2Test.fail((String)"We should not have been able to set two GRID frames with the same group symbol and owner identifier.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oGRID1.setGroupIdentificationRegistration("owner3", (byte)1, new byte[]{1});
            oGRID3 = new GRIDID3V2Frame("owner3", 3, new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third GRID frmaes.");
        }
        try {
            oID3V2_3_0Tag.addGRIDFrame(oGRID3);
            ID3V2Test.fail((String)"We should not have been able to add a new GRID frame with the same owner identifier as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oGRID1.setGroupIdentificationRegistration("owner1", (byte)1, new byte[]{1});
            oGRID3 = new GRIDID3V2Frame("owner3", 1, new byte[]{3});
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and recreate the third GRID frmaes.");
        }
        try {
            oID3V2_3_0Tag.addGRIDFrame(oGRID3);
            ID3V2Test.fail((String)"We should not have been able to add a new GRID frame with the same method symbol as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        LINKID3V2Frame oLINK1 = null;
        LINKID3V2Frame oLINK2 = null;
        LINKID3V2Frame oLINK3 = null;
        try {
            oLINK1 = new LINKID3V2Frame("ABCD".getBytes(), "http://www.a.com", "additional1");
            oID3V2_3_0Tag.addLINKFrame(oLINK1);
            oLINK2 = new LINKID3V2Frame("EFGH".getBytes(), "http://www.b.com", "additional2");
            oID3V2_3_0Tag.addLINKFrame(oLINK2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two LINK frames.");
        }
        try {
            oLINK2.setContents("ABCD".getBytes(), "http://www.a.com", "additional1");
            ID3V2Test.fail((String)"We should not have been able to set two LINK frames with the same contents.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oLINK1.setContents("IJKL".getBytes(), "http://www.c.com", "additional3");
            oLINK3 = new LINKID3V2Frame("IJKL".getBytes(), "http://www.c.com", "additional3");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to modify the first and create the third LINK frmaes.");
        }
        try {
            oID3V2_3_0Tag.addLINKFrame(oLINK3);
            ID3V2Test.fail((String)"We should not have been able to add a new LINK frame with the same contents as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        POPMID3V2Frame oPOPM1 = null;
        POPMID3V2Frame oPOPM2 = null;
        POPMID3V2Frame oPOPM3 = null;
        try {
            oPOPM1 = new POPMID3V2Frame("a@b.com", 1, 1);
            oID3V2_3_0Tag.addPOPMFrame(oPOPM1);
            oPOPM2 = new POPMID3V2Frame("b@c.com", 2, 2);
            oID3V2_3_0Tag.addPOPMFrame(oPOPM2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)"We should have been able to create the first two POPM frames.");
        }
        try {
            oPOPM2.setPopularity("a@b.com", 2, 2);
            ID3V2Test.fail((String)"We should not have been able to set two POPM frames with the same email address.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oPOPM1.setPopularity("c@d.com", 3, 3);
            oPOPM3 = new POPMID3V2Frame("c@d.com", 3, 3);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third POPM frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addPOPMFrame(oPOPM3);
            ID3V2Test.fail((String)"We should not have been able to add a new POPM frame with the same email address as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        PRIVID3V2Frame oPRIV1 = null;
        PRIVID3V2Frame oPRIV2 = null;
        PRIVID3V2Frame oPRIV3 = null;
        try {
            oPRIV1 = new PRIVID3V2Frame("http://www.a.com", "additional1".getBytes());
            oID3V2_3_0Tag.addPRIVFrame(oPRIV1);
            oPRIV2 = new PRIVID3V2Frame("http://www.b.com", "additional2".getBytes());
            oID3V2_3_0Tag.addPRIVFrame(oPRIV2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two PRIV frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oPRIV2.setPrivateInformation("http://www.a.com", "additional1".getBytes());
            ID3V2Test.fail((String)"We should not have been able to set two PRIV frames with the same contents.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oPRIV1.setPrivateInformation("http://www.c.com", "additional3".getBytes());
            oPRIV3 = new PRIVID3V2Frame("http://www.c.com", "additional3".getBytes());
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third PRIV frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addPRIVFrame(oPRIV3);
            ID3V2Test.fail((String)"We should not have been able to add a new PRIV frame with the same contents as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        SYLTID3V2Frame oSYLT1 = null;
        SYLTID3V2Frame oSYLT2 = null;
        SYLTID3V2Frame oSYLT3 = null;
        try {
            oSYLT1 = new SYLTID3V2Frame("eng", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, SYLTID3V2Frame.ContentType.CHORD, "contentdescriptor1");
            oID3V2_3_0Tag.addSYLTFrame(oSYLT1);
            oSYLT2 = new SYLTID3V2Frame("eng", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, SYLTID3V2Frame.ContentType.CHORD, "contentdescriptor2");
            oID3V2_3_0Tag.addSYLTFrame(oSYLT2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two SYLT frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oSYLT2.setContentDescriptor("contentdescriptor1");
            ID3V2Test.fail((String)"We should not have been able to set two SYLT frames with the same language and content descriptor.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oSYLT1.setContentDescriptor("contentdescriptor3");
            oSYLT3 = new SYLTID3V2Frame("eng", SYLTID3V2Frame.TimestampFormat.ABSOLUTE_MILLISECONDS, SYLTID3V2Frame.ContentType.CHORD, "contentdescriptor3");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third SYLT frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addSYLTFrame(oSYLT3);
            ID3V2Test.fail((String)"We should not have been able to add a new SYLT frame with the same language and content descriptor as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        TXXXTextInformationID3V2Frame oTXXX1 = null;
        TXXXTextInformationID3V2Frame oTXXX2 = null;
        TXXXTextInformationID3V2Frame oTXXX3 = null;
        try {
            oTXXX1 = new TXXXTextInformationID3V2Frame("description1", "information1");
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX1);
            oTXXX2 = new TXXXTextInformationID3V2Frame("description2", "information2");
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two TXXX frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oTXXX2.setDescriptionAndInformation("description1", "information2");
            ID3V2Test.fail((String)"We should not have been able to set two TXXX frames with the same description.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oTXXX1.setDescriptionAndInformation("description3", "information1");
            oTXXX3 = new TXXXTextInformationID3V2Frame("description3", "information3");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third TXXX frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addTXXXTextInformationFrame(oTXXX3);
            ID3V2Test.fail((String)"We should not have been able to add a new TXXX frame with the same description as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        UFIDID3V2Frame oUFID1 = null;
        UFIDID3V2Frame oUFID2 = null;
        UFIDID3V2Frame oUFID3 = null;
        try {
            oUFID1 = new UFIDID3V2Frame("owner1", "identifier1".getBytes());
            oID3V2_3_0Tag.addUFIDFrame(oUFID1);
            oUFID2 = new UFIDID3V2Frame("owner2", "identifier2".getBytes());
            oID3V2_3_0Tag.addUFIDFrame(oUFID2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two UFID frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oUFID2.setUniqueIdentifier("owner1", "identifier2".getBytes());
            ID3V2Test.fail((String)"We should not have been able to set two UFID frames with the same owner identifier.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oUFID1.setUniqueIdentifier("owner3", "identifier1".getBytes());
            oUFID3 = new UFIDID3V2Frame("owner3", "identifier3".getBytes());
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third UFID frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addUFIDFrame(oUFID3);
            ID3V2Test.fail((String)"We should not have been able to add a new UFID frame with the same owner identifier as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        USLTID3V2Frame oUSLT1 = null;
        USLTID3V2Frame oUSLT2 = null;
        USLTID3V2Frame oUSLT3 = null;
        try {
            oUSLT1 = new USLTID3V2Frame("eng", "contentdescriptor1", "lyrics1");
            oID3V2_3_0Tag.addUSLTFrame(oUSLT1);
            oUSLT2 = new USLTID3V2Frame("eng", "contentdescriptor2", "lyrics2");
            oID3V2_3_0Tag.addUSLTFrame(oUSLT2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two USLT frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oUSLT2.setContentDescriptor("contentdescriptor1");
            ID3V2Test.fail((String)"We should not have been able to set two USLT frames with the same language and content descriptor.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oUSLT1.setContentDescriptor("contentdescriptor3");
            oUSLT3 = new USLTID3V2Frame("eng", "contentdescriptor3", "lyrics3");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third USLT frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addUSLTFrame(oUSLT3);
            ID3V2Test.fail((String)"We should not have been able to add a new USLT frame with the same language and content descriptor as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        WCOMUrlLinkID3V2Frame oWCOM1 = null;
        WCOMUrlLinkID3V2Frame oWCOM2 = null;
        WCOMUrlLinkID3V2Frame oWCOM3 = null;
        try {
            oWCOM1 = new WCOMUrlLinkID3V2Frame("http://www.a.com");
            oID3V2_3_0Tag.addWCOMUrlLinkFrame(oWCOM1);
            oWCOM2 = new WCOMUrlLinkID3V2Frame("http://www.b.com");
            oID3V2_3_0Tag.addWCOMUrlLinkFrame(oWCOM2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two WCOM frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oWCOM2.setCommercialInformation("http://www.a.com");
            ID3V2Test.fail((String)"We should not have been able to set two WCOM frames with the same URL.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oWCOM1.setCommercialInformation("http://www.c.com");
            oWCOM3 = new WCOMUrlLinkID3V2Frame("http://www.c.com");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third WCOM frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addWCOMUrlLinkFrame(oWCOM3);
            ID3V2Test.fail((String)"We should not have been able to add a new WCOM frame with the same URL as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        WOARUrlLinkID3V2Frame oWOAR1 = null;
        WOARUrlLinkID3V2Frame oWOAR2 = null;
        WOARUrlLinkID3V2Frame oWOAR3 = null;
        try {
            oWOAR1 = new WOARUrlLinkID3V2Frame("http://www.a.com");
            oID3V2_3_0Tag.addWOARUrlLinkFrame(oWOAR1);
            oWOAR2 = new WOARUrlLinkID3V2Frame("http://www.b.com");
            oID3V2_3_0Tag.addWOARUrlLinkFrame(oWOAR2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two WOAR frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oWOAR2.setOfficialArtistWebPage("http://www.a.com");
            ID3V2Test.fail((String)"We should not have been able to set two WOAR frames with the same URL.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oWOAR1.setOfficialArtistWebPage("http://www.c.com");
            oWOAR3 = new WOARUrlLinkID3V2Frame("http://www.c.com");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third WOAR frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addWOARUrlLinkFrame(oWOAR3);
            ID3V2Test.fail((String)"We should not have been able to add a new WOAR frame with the same URL as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
        WXXXUrlLinkID3V2Frame oWXXX1 = null;
        WXXXUrlLinkID3V2Frame oWXXX2 = null;
        WXXXUrlLinkID3V2Frame oWXXX3 = null;
        try {
            oWXXX1 = new WXXXUrlLinkID3V2Frame("description1", "http://www.a.com");
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX1);
            oWXXX2 = new WXXXUrlLinkID3V2Frame("description2", "http://www.b.com");
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX2);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to create the first two WXXX frames: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oWXXX2.setDescriptionAndUrl("description1", "http://www.b.com");
            ID3V2Test.fail((String)"We should not have been able to set two WXXX frames with the same description.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oWXXX1.setDescriptionAndUrl("description3", "http://www.a.com");
            oWXXX3 = new WXXXUrlLinkID3V2Frame("description3", "http://www.c.com");
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("We should have been able to modify the first and create the third WXXX frmaes: " + ID3Exception.getStackTrace(e)));
        }
        try {
            oID3V2_3_0Tag.addWXXXUrlLinkFrame(oWXXX3);
            ID3V2Test.fail((String)"We should not have been able to add a new WXXX frame with the same description as an existing frame.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testEncryption1() {
        ROTCryptoAgent oROTAgent = new ROTCryptoAgent();
        ID3Encryption.getInstance().registerCryptoAgent(oROTAgent);
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            ENCRID3V2Frame oENCR = new ENCRID3V2Frame(oROTAgent.getOwnerIdentifier(), -119, new byte[]{1});
            oID3V2_3_0Tag.addENCRFrame(oENCR);
            TPE1TextInformationID3V2Frame oTPE1 = new TPE1TextInformationID3V2Frame("hello");
            oTPE1.setEncryption((byte)-119);
            oID3V2_3_0Tag.setTPE1TextInformationFrame(oTPE1);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'ENCR<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>jid3-rot1<bh:00><bh:89><bh:01>TPE1<bh:00><bh:00><bh:00><bh:07><bh:00>@<bh:89><bh:01>ifmmp";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testEncryption2() {
        ExpandCryptoAgent oExpandAgent = new ExpandCryptoAgent();
        ID3Encryption.getInstance().registerCryptoAgent(oExpandAgent);
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            ENCRID3V2Frame oENCR = new ENCRID3V2Frame(oExpandAgent.getOwnerIdentifier(), -119, new byte[]{1});
            oID3V2_3_0Tag.addENCRFrame(oENCR);
            TPE1TextInformationID3V2Frame oTPE1 = new TPE1TextInformationID3V2Frame("hello");
            oTPE1.setEncryption((byte)-119);
            oID3V2_3_0Tag.setTPE1TextInformationFrame(oTPE1);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>6ENCR<bh:00><bh:00><bh:00><bh:09><bh:00><bh:00>expand<bh:00><bh:89><bh:01>TPE1<bh:00><bh:00><bh:00><bh:19><bh:00>@<bh:89><bh:00><bh:00><bh:00><bh:00><bh:00><bh:00><bh:00>h<bh:00><bh:00><bh:00>e<bh:00><bh:00><bh:00>l<bh:00><bh:00><bh:00>l<bh:00><bh:00><bh:00>o";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    public void testEncryptionWithCompression() {
        ROTCryptoAgent oROTAgent = new ROTCryptoAgent();
        ID3Encryption.getInstance().registerCryptoAgent(oROTAgent);
        try {
            ID3V2_3_0Tag oID3V2_3_0Tag = new ID3V2_3_0Tag();
            ENCRID3V2Frame oENCR = new ENCRID3V2Frame(oROTAgent.getOwnerIdentifier(), -119, new byte[]{1});
            oID3V2_3_0Tag.addENCRFrame(oENCR);
            TPE1TextInformationID3V2Frame oTPE1 = new TPE1TextInformationID3V2Frame("hello");
            oTPE1.setEncryption((byte)-119);
            oID3V2_3_0Tag.setTPE1TextInformationFrame(oTPE1);
            oTPE1.setCompressionFlag(true);
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>3ENCR<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>jid3-rot1<bh:00><bh:89><bh:01>TPE1<bh:00><bh:00><bh:00><bh:13><bh:00><bh:c0><bh:00><bh:00><bh:00><bh:06><bh:89>y<bh:9d>d<bh:c9>I<bh:ce><bh:ca><bh:ca><bh:08><bh:01><bh:07>.<bh:03><bh:16>";
            this.runTagVerifyTest(oID3V2_3_0Tag, sPrefix);
        }
        catch (Exception e) {
            ID3V2Test.fail((String)ID3Exception.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncryptionNotSupported() {
        try {
            EncryptedID3V2Frame[] aoEncrypted;
            TPE1TextInformationID3V2Frame oTPE1;
            ID3V2_3_0Tag oID3V2_3_0Tag;
            ID3Tag[] aoID3Tag;
            String sPrefix = "ID3<bh:03><bh:00><bh:00><bh:00><bh:00><bh:00>'ENCR<bh:00><bh:00><bh:00><bh:0c><bh:00><bh:00>jid3-????<bh:00><bh:89><bh:01>TPE1<bh:00><bh:00><bh:00><bh:06><bh:00>@<bh:89><bh:01>ifmmp";
            String sSourceFile = AllTests.s_RootPath + "id3_v2_3_0_encrypted.mp3";
            FileInputStream oFIS = null;
            FileOutputStream oFOS = null;
            try {
                int iNumRead;
                oFIS = new FileInputStream(AllTests.s_RootPath + "notags.mp3");
                oFOS = new FileOutputStream(sSourceFile);
                oFOS.write(ID3Util.convertFrhedToByteArray(sPrefix));
                byte[] abyBuffer = new byte[16384];
                while ((iNumRead = oFIS.read(abyBuffer)) != -1) {
                    oFOS.write(abyBuffer, 0, iNumRead);
                }
                oFOS.flush();
            }
            finally {
                try {
                    oFIS.close();
                }
                catch (Exception e) {}
                try {
                    oFOS.close();
                }
                catch (Exception e) {}
            }
            ID3Tag.useStrict(false);
            MP3File oMediaFile = new MP3File(new File(sSourceFile));
            try {
                aoID3Tag = ((MediaFile)oMediaFile).getTags();
                oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                oTPE1 = oID3V2_3_0Tag.getTPE1TextInformationFrame();
                if (oTPE1 != null) {
                    ID3V2Test.fail((String)"In non-strict mode, we should not have been able to read a frame encrypted with a method that is not registered.");
                }
                if ((aoEncrypted = oID3V2_3_0Tag.getEncryptedFrames()).length != 1) {
                    ID3V2Test.fail((String)"In non-strict mode, we should be able to access a frame still encrypted with a method that is not registered.");
                }
                if (!new String(aoEncrypted[0].getEncryptedFrameId()).equals("TPE1")) {
                    ID3V2Test.fail((String)"In non-strict mode, the encrypted frame we read should have been a TPE1 frame.");
                }
            }
            catch (Exception e) {
                ID3V2Test.fail((String)("With non-strict setting, reading this file with an unsupported encrypted frame should not have generated an exception: " + ID3Exception.getStackTrace(e)));
            }
            ID3Tag.useStrict(true);
            oMediaFile = new MP3File(new File(sSourceFile));
            try {
                aoID3Tag = ((MediaFile)oMediaFile).getTags();
                oID3V2_3_0Tag = (ID3V2_3_0Tag)aoID3Tag[0];
                oTPE1 = oID3V2_3_0Tag.getTPE1TextInformationFrame();
                if (oTPE1 != null) {
                    ID3V2Test.fail((String)"In strict mode, we should not have been able to read a frame encrypted with a method that is not registered.");
                }
                if ((aoEncrypted = oID3V2_3_0Tag.getEncryptedFrames()).length != 1) {
                    ID3V2Test.fail((String)"In strict mode, we should be able to access a frame still encrypted with a method that is not registered.");
                }
                if (!new String(aoEncrypted[0].getEncryptedFrameId()).equals("TPE1")) {
                    ID3V2Test.fail((String)"In strict mode, the encrypted frame we read should have been a TPE1 frame.");
                }
            }
            catch (Exception e) {
                ID3V2Test.fail((String)("With strict setting, reading this file with an unsupported encrypted frame should not have generated an exception: " + ID3Exception.getStackTrace(e)));
            }
        }
        catch (Exception e) {
            ID3V2Test.fail((String)("Unexpected " + e.getClass().getName() + " exception: " + ID3Exception.getStackTrace(e)));
        }
    }

    public class DummyCryptoAgent
    implements ICryptoAgent {
        public byte[] decrypt(byte[] abyEncryptedData, byte[] abyEncryptionData) throws ID3CryptException {
            return abyEncryptedData;
        }

        public byte[] encrypt(byte[] abyRawData, byte[] abyEncryptionData) throws ID3CryptException {
            return abyRawData;
        }

        public String getOwnerIdentifier() {
            return "dummy";
        }
    }

    public class ExpandCryptoAgent
    implements ICryptoAgent {
        public byte[] decrypt(byte[] abyEncryptedData, byte[] abyEncryptionData) throws ID3CryptException {
            ByteArrayInputStream oBAIS = new ByteArrayInputStream(abyEncryptedData);
            ID3DataInputStream oIDIS = new ID3DataInputStream(oBAIS);
            ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
            try {
                while (oIDIS.available() > 0) {
                    oBAOS.write(oIDIS.readBE32());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return oBAOS.toByteArray();
        }

        public byte[] encrypt(byte[] abyRawData, byte[] abyEncryptionData) throws ID3CryptException {
            ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
            ID3DataOutputStream oIDOS = new ID3DataOutputStream(oBAOS);
            try {
                for (int i = 0; i < abyRawData.length; ++i) {
                    oIDOS.writeBE32(abyRawData[i]);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return oBAOS.toByteArray();
        }

        public String getOwnerIdentifier() {
            return "expand";
        }
    }

    public class ROTCryptoAgent
    implements ICryptoAgent {
        public byte[] decrypt(byte[] abyEncryptedData, byte[] abyEncryptionData) throws ID3CryptException {
            byte iDiff = abyEncryptionData[0];
            byte[] abyDecrypted = new byte[abyEncryptedData.length];
            for (int i = 0; i < abyEncryptedData.length; ++i) {
                abyDecrypted[i] = (byte)(abyEncryptedData[i] - iDiff);
            }
            return abyDecrypted;
        }

        public byte[] encrypt(byte[] abyRawData, byte[] abyEncryptionData) throws ID3CryptException {
            byte iDiff = abyEncryptionData[0];
            byte[] abyEncrypted = new byte[abyRawData.length];
            for (int i = 0; i < abyRawData.length; ++i) {
                abyEncrypted[i] = (byte)(abyRawData[i] + iDiff);
            }
            return abyEncrypted;
        }

        public String getOwnerIdentifier() {
            return "jid3-rot1";
        }
    }
}

