/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.blinkenlights.jid3.ID3Exception;

public class ID3DataOutputStream
extends DataOutputStream {
    public ID3DataOutputStream(OutputStream oOS) {
        super(oOS);
    }

    public void writeUnsignedByte(int iValue) throws IOException {
        this.writeByte(iValue);
    }

    public void writeBEUnsigned16(int iValue) throws IOException {
        int iLo = iValue & 0xFF;
        int iHi = iValue >> 8;
        this.write(iHi);
        this.write(iLo);
    }

    public void writeBE24(int iValue) throws IOException {
        int iOne = iValue & 0xFF;
        int iTwo = iValue >> 8 & 0xFF;
        int iThree = iValue >> 16 & 0xFF;
        this.write(iThree);
        this.write(iTwo);
        this.write(iOne);
    }

    public void writeBE32(int iValue) throws IOException {
        int iOne = iValue & 0xFF;
        int iTwo = iValue >> 8 & 0xFF;
        int iThree = iValue >> 16 & 0xFF;
        int iFour = iValue >> 24 & 0xFF;
        this.write(iFour);
        this.write(iThree);
        this.write(iTwo);
        this.write(iOne);
    }

    public void writeUnsignedBE32(long lValue) throws IOException {
        int iOne = (int)(lValue & 0xFFL);
        int iTwo = (int)(lValue >> 8 & 0xFFL);
        int iThree = (int)(lValue >> 16 & 0xFFL);
        int iFour = (int)(lValue >> 24 & 0xFFL);
        this.write(iFour);
        this.write(iThree);
        this.write(iTwo);
        this.write(iOne);
    }

    public void writeID3Four(int iValue) throws IOException, ID3Exception {
        if (iValue >= 0x10000000) {
            throw new ID3Exception("Cannot write an encoded value greater than 28-bit unsigned.");
        }
        int iOne = iValue >> 21 & 0x7F;
        int iTwo = iValue >> 14 & 0x7F;
        int iThree = iValue >> 7 & 0x7F;
        int iFour = iValue & 0x7F;
        this.write(iOne);
        this.write(iTwo);
        this.write(iThree);
        this.write(iFour);
    }
}

