/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.atmosphere.container.TomcatWebSocketHandler;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocketUtil.class);
    private static final Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();
    private static byte[] WS_ACCEPT;

    public static Action doService(AtmosphereRequest req, AtmosphereResponse res, Delegate delegate, AtmosphereConfig config) throws IOException, ServletException {
        if (req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
            String subProtocol = null;
            if (!TomcatWebSocketUtil.headerContainsToken((HttpServletRequest)req, "Upgrade", "websocket")) {
                return delegate.doService(req, res);
            }
            if (!TomcatWebSocketUtil.headerContainsToken((HttpServletRequest)req, "Connection", "upgrade")) {
                return delegate.doService(req, res);
            }
            if (!TomcatWebSocketUtil.headerContainsToken((HttpServletRequest)req, "sec-websocket-version", "13")) {
                logger.debug("WebSocket version not supported. Downgrading to Comet");
                res.sendError(501, "Websocket protocol not supported");
                return new Action(Action.TYPE.CANCELLED);
            }
            String key = req.getHeader("Sec-WebSocket-Key");
            if (key == null) {
                return delegate.doService(req, res);
            }
            res.setHeader("Upgrade", "websocket");
            res.setHeader("Connection", "upgrade");
            res.setHeader("Sec-WebSocket-Accept", TomcatWebSocketUtil.getWebSocketAccept(key));
            if (subProtocol != null) {
                res.setHeader("Sec-WebSocket-Protocol", subProtocol);
            }
            HttpServletRequest hsr = req.wrappedRequest();
            while (hsr instanceof HttpServletRequestWrapper) {
                hsr = (HttpServletRequest)((HttpServletRequestWrapper)hsr).getRequest();
            }
            RequestFacade facade = (RequestFacade)hsr;
            TomcatWebSocketHandler inbound = new TomcatWebSocketHandler(AtmosphereRequest.cloneRequest((HttpServletRequest)req, true, config.isSupportSession()), config.framework(), config.framework().getWebSocketProtocol());
            facade.doUpgrade((UpgradeInbound)inbound);
            return new Action(Action.TYPE.CREATED);
        }
        Action action = delegate.suspended(req, res);
        if (action.type() == Action.TYPE.RESUME) {
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action;
    }

    private static boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private static String getWebSocketAccept(String key) throws ServletException {
        MessageDigest sha1Helper = sha1Helpers.poll();
        if (sha1Helper == null) {
            try {
                sha1Helper = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        sha1Helper.reset();
        try {
            sha1Helper.update(key.getBytes("ISO_8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        String result = Base64.encode((byte[])sha1Helper.digest(WS_ACCEPT));
        sha1Helpers.add(sha1Helper);
        return result;
    }

    static {
        try {
            WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO_8859_1");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static interface Delegate {
        public Action doService(AtmosphereRequest var1, AtmosphereResponse var2) throws IOException, ServletException;

        public Action suspended(AtmosphereRequest var1, AtmosphereResponse var2) throws IOException, ServletException;
    }
}

