/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketUtil.class);

    public static final Action doService(AsynchronousProcessor cometSupport, AtmosphereRequest req, AtmosphereResponse res, WebSocketFactory webSocketFactory) throws IOException, ServletException {
        Boolean b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED);
        if (b == null) {
            b = Boolean.FALSE;
        }
        if (!Utils.webSocketEnabled((HttpServletRequest)req) && req.getAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE) == null) {
            if (req.resource() != null && req.resource().transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                logger.trace("Invalid WebSocket Specification {}", (Object)req);
                res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                res.sendError(501, "Websocket protocol not supported");
                return Action.CANCELLED;
            }
            return null;
        }
        if (webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, true);
            webSocketFactory.acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            req.setAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE, true);
            return new Action();
        }
        Action action = cometSupport.suspended(req, res);
        if (action.type() != Action.TYPE.SUSPEND && action.type() == Action.TYPE.RESUME) {
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action;
    }

    public static final WebSocketFactory getFactory(final AtmosphereConfig config) {
        WebSocketFactory webSocketFactory = new WebSocketFactory(new WebSocketFactory.Acceptor(){

            public boolean checkOrigin(HttpServletRequest request, String origin) {
                logger.trace("WebSocket-checkOrigin request {} with origin {}", (Object)request.getRequestURI(), (Object)origin);
                return true;
            }

            public org.eclipse.jetty.websocket.WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                logger.trace("WebSocket-connect request {} with protocol {}", (Object)request.getRequestURI(), (Object)protocol);
                return new JettyWebSocketHandler(AtmosphereRequest.cloneRequest(request, false, config.isSupportSession()), config.framework(), config.framework().getWebSocketProtocol());
            }
        });
        int bufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.bufferSize") != null) {
            bufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.bufferSize"));
        }
        logger.debug("WebSocket Buffer side {}", (Object)bufferSize);
        webSocketFactory.setBufferSize(bufferSize);
        int timeOut = 300000;
        if (config.getInitParameter("org.atmosphere.websocket.maxIdleTime") != null) {
            timeOut = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxIdleTime"));
        }
        logger.debug("WebSocket idle timeout {}", (Object)timeOut);
        webSocketFactory.setMaxIdleTime(timeOut);
        int maxTextBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize") != null) {
            maxTextBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize"));
        }
        logger.debug("WebSocket maxTextBufferSize {}", (Object)maxTextBufferSize);
        webSocketFactory.setMaxTextMessageSize(maxTextBufferSize);
        int maxBinaryBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize") != null) {
            maxBinaryBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize"));
        }
        logger.debug("WebSocket maxBinaryBufferSize {}", (Object)maxBinaryBufferSize);
        webSocketFactory.setMaxBinaryMessageSize(maxBinaryBufferSize);
        return webSocketFactory;
    }
}

