/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.SafeMode;

public class AsciidoctorUtils {
    private static final String RUNNER = "asciidoctor";

    private AsciidoctorUtils() {
    }

    public static boolean isOptionWithAttribute(Map<String, Object> options, String attributeName, String attributeValue) {
        String configuredAttributeValue;
        Map attributes;
        return options.containsKey("attributes") && (attributes = (Map)options.get("attributes")).containsKey(attributeName) && (configuredAttributeValue = (String)attributes.get(attributeName)).equals(attributeValue);
    }

    public static String toAsciidoctorCommand(Map<String, Object> options, String inputPath) {
        String command = "asciidoctor " + AsciidoctorUtils.getOptions(options) + inputPath;
        return command;
    }

    private static String getOptions(Map<String, Object> options) {
        StringBuilder optionsAndAttributes = new StringBuilder();
        if (options.containsKey("destination_dir")) {
            optionsAndAttributes.append("-D").append(" ").append(options.get("destination_dir")).append(" ");
        }
        if (options.containsKey("base_dir")) {
            optionsAndAttributes.append("-B").append(" ").append(options.get("base_dir")).append(" ");
        }
        if (options.containsKey("template_dirs")) {
            List templates = (List)options.get("template_dirs");
            for (String template : templates) {
                optionsAndAttributes.append("-T").append(" ").append(template).append(" ");
            }
        }
        if (options.containsKey("template_engine")) {
            optionsAndAttributes.append("-E").append(" ").append(options.get("template_engine")).append(" ");
        }
        if (options.containsKey("compact")) {
            optionsAndAttributes.append("-C").append(" ");
        }
        if (options.containsKey("eruby")) {
            optionsAndAttributes.append("-e").append(" ").append(options.get("eruby")).append(" ");
        }
        if (options.containsKey("header_footer")) {
            optionsAndAttributes.append("-s").append(" ");
        }
        if (options.containsKey("safe")) {
            Integer level = (Integer)options.get("safe");
            SafeMode getSafeMode = SafeMode.safeMode(level);
            optionsAndAttributes.append("-S").append(" ").append((Object)getSafeMode).append(" ");
        }
        if (options.containsKey("to_file")) {
            optionsAndAttributes.append("-o").append(" ").append(options.get("to_file")).append(" ");
        }
        if (options.containsKey("doctype")) {
            optionsAndAttributes.append("-d").append(" ").append(options.get("doctype")).append(" ");
        }
        if (options.containsKey("backend")) {
            optionsAndAttributes.append("-b").append(" ").append(options.get("backend")).append(" ");
        }
        if (options.containsKey("attributes")) {
            optionsAndAttributes.append(AsciidoctorUtils.getAttributesSyntax((Map)options.get("attributes")));
        }
        return optionsAndAttributes.toString();
    }

    private static String getAttributesSyntax(Map<String, Object> attributes) {
        StringBuilder attributesOutput = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            attributesOutput.append(AsciidoctorUtils.getAttributeSyntax(entry.getKey(), entry.getValue())).append(" ");
        }
        return attributesOutput.toString();
    }

    private static String getAttributeSyntax(String attributeName, Object attributeValue) {
        String attribute = "-a " + attributeName;
        if (attributeValue != null && !"".equals(attributeValue.toString().trim())) {
            attribute = attribute + "=" + attributeValue.toString();
        }
        if (attributeValue == null) {
            attribute = attribute + "!";
        }
        return attribute;
    }
}

