/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnitPart;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

class ActiveCell {
    private PrimaryGridUnit pgu;
    private List elementList;
    private boolean prevIsBox = false;
    private int startRow;
    private int start;
    private int end;
    private int width;
    private int remainingLength;
    private int baseWidth;
    private int totalLength;
    private int includedLength;
    private int borderBefore;
    private int borderAfter;
    private int paddingBefore;
    private int paddingAfter;
    private boolean keepWithNextSignal;
    private int lastPenaltyLength;

    ActiveCell(PrimaryGridUnit pgu, EffRow row, int rowIndex, EffRow[] rowGroup, TableLayoutManager tableLM) {
        boolean contentsSmaller;
        this.pgu = pgu;
        boolean makeBoxForWholeRow = false;
        if (row.getExplicitHeight().min > 0 && (contentsSmaller = ElementListUtils.removeLegalBreaks(pgu.getElements(), row.getExplicitHeight()))) {
            makeBoxForWholeRow = true;
        }
        if (pgu.isLastGridUnitRowSpan() && pgu.getRow() != null) {
            makeBoxForWholeRow |= pgu.getRow().mustKeepTogether();
            makeBoxForWholeRow |= pgu.getTable().mustKeepTogether();
        }
        if (makeBoxForWholeRow) {
            this.elementList = new ArrayList(1);
            int height = row.getExplicitHeight().opt;
            if (height == 0) {
                height = row.getHeight().opt;
            }
            this.elementList.add(new KnuthBoxCellWithBPD(height));
        } else {
            this.elementList = pgu.getElements();
        }
        this.totalLength = ElementListUtils.calcContentLength(this.elementList);
        if (pgu.getTable().isSeparateBorderModel()) {
            this.borderBefore = pgu.getBorders().getBorderBeforeWidth(false) + tableLM.getHalfBorderSeparationBPD();
            this.borderAfter = pgu.getBorders().getBorderAfterWidth(false) + tableLM.getHalfBorderSeparationBPD();
        } else {
            this.borderBefore = pgu.getHalfMaxBeforeBorderWidth();
            this.borderAfter = pgu.getHalfMaxAfterBorderWidth();
        }
        this.paddingBefore = pgu.getBorders().getPaddingBefore(false, pgu.getCellLM());
        this.paddingAfter = pgu.getBorders().getPaddingAfter(false, pgu.getCellLM());
        this.start = 0;
        this.end = -1;
        this.startRow = rowIndex;
        this.keepWithNextSignal = false;
        this.computeBaseWidth(rowGroup);
        this.remainingLength = this.totalLength;
        this.goToNextLegalBreak();
    }

    private void computeBaseWidth(EffRow[] rowGroup) {
        this.width = 0;
        this.includedLength = -1;
        for (int prevRow = 0; prevRow < this.startRow; ++prevRow) {
            this.width += rowGroup[prevRow].getHeight().opt;
        }
        this.baseWidth = this.width;
    }

    boolean endsOnRow(int rowIndex) {
        return rowIndex == this.startRow + this.pgu.getCell().getNumberRowsSpanned() - 1;
    }

    int getRemainingHeight(int activeRowIndex, EffRow[] rowGroup) {
        if (!this.endsOnRow(activeRowIndex)) {
            return 0;
        }
        if (this.includedLength == this.totalLength) {
            return 0;
        }
        return this.remainingLength + this.borderBefore + this.borderAfter + this.paddingBefore + this.paddingAfter;
    }

    private void goToNextLegalBreak() {
        this.lastPenaltyLength = 0;
        boolean breakFound = false;
        while (!breakFound && this.end + 1 < this.elementList.size()) {
            ++this.end;
            KnuthElement el = (KnuthElement)this.elementList.get(this.end);
            if (el.isPenalty()) {
                this.prevIsBox = false;
                if (el.getP() >= 1000) continue;
                this.lastPenaltyLength = el.getW();
                breakFound = true;
                continue;
            }
            if (el.isGlue()) {
                if (this.prevIsBox) {
                    breakFound = true;
                } else {
                    this.width += el.getW();
                }
                this.prevIsBox = false;
                continue;
            }
            this.prevIsBox = true;
            this.width += el.getW();
        }
    }

    int getNextStep() {
        if (!this.includedInLastStep()) {
            return this.width + this.lastPenaltyLength + this.borderBefore + this.borderAfter + this.paddingBefore + this.paddingAfter;
        }
        this.start = this.end + 1;
        if (this.end < this.elementList.size() - 1) {
            this.goToNextLegalBreak();
            return this.width + this.lastPenaltyLength + this.borderBefore + this.borderAfter + this.paddingBefore + this.paddingAfter;
        }
        return 0;
    }

    private boolean includedInLastStep() {
        return this.includedLength == this.width;
    }

    boolean signalMinStep(int minStep) {
        if (this.width + this.lastPenaltyLength + this.borderBefore + this.borderAfter + this.paddingBefore + this.paddingAfter <= minStep) {
            this.includedLength = this.width;
            this.computeRemainingLength();
            return false;
        }
        return this.baseWidth + this.borderBefore + this.borderAfter + this.paddingBefore + this.paddingAfter > minStep;
    }

    private void computeRemainingLength() {
        KnuthElement el;
        this.remainingLength = this.totalLength - this.width;
        for (int index = this.end + 1; index < this.elementList.size() && !(el = (KnuthElement)this.elementList.get(index)).isBox(); ++index) {
            if (!el.isGlue()) continue;
            this.remainingLength -= el.getW();
        }
    }

    boolean contributesContent() {
        return this.includedInLastStep() && this.end >= this.start;
    }

    boolean hasStarted() {
        return this.includedLength > 0;
    }

    boolean isFinished() {
        return this.includedInLastStep() && this.end == this.elementList.size() - 1;
    }

    GridUnitPart createGridUnitPart() {
        if (this.end + 1 == this.elementList.size()) {
            if (this.pgu.getFlag(6)) {
                this.keepWithNextSignal = true;
            }
            if (this.pgu.getRow() != null && this.pgu.getRow().mustKeepWithNext()) {
                this.keepWithNextSignal = true;
            }
        }
        if (this.start == 0 && this.end == 0 && this.elementList.size() == 1 && this.elementList.get(0) instanceof KnuthBoxCellWithBPD) {
            return new GridUnitPart(this.pgu, 0, this.pgu.getElements().size() - 1);
        }
        return new GridUnitPart(this.pgu, this.start, this.end);
    }

    boolean isLastForcedBreak() {
        return ((KnuthElement)this.elementList.get(this.end)).isForcedBreak();
    }

    int getLastBreakClass() {
        return ((KnuthPenalty)this.elementList.get(this.end)).getBreakClass();
    }

    boolean keepWithNextSignal() {
        return this.keepWithNextSignal;
    }

    private static class KnuthBoxCellWithBPD
    extends KnuthBox {
        public KnuthBoxCellWithBPD(int w) {
            super(w, null, true);
        }
    }
}

