/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.DummyPolicyAsserter;
import org.apache.wss4j.policy.stax.PolicyAsserter;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class AlgorithmSuiteAssertionState
extends AssertionState
implements Assertable {
    private PolicyAsserter policyAsserter;

    public AlgorithmSuiteAssertionState(AbstractSecurityAssertion assertion, PolicyAsserter policyAsserter, boolean asserted) {
        super((Assertion)assertion, asserted);
        this.policyAsserter = policyAsserter;
        if (this.policyAsserter == null) {
            this.policyAsserter = new DummyPolicyAsserter();
        }
        if (asserted) {
            AlgorithmSuite algorithmSuite = (AlgorithmSuite)this.getAssertion();
            policyAsserter.assertPolicy(this.getAssertion());
            String namespace = algorithmSuite.getAlgorithmSuiteType().getNamespace();
            String name = algorithmSuite.getAlgorithmSuiteType().getName();
            policyAsserter.assertPolicy(new QName(namespace, name));
        }
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{SecurityEventConstants.AlgorithmSuite};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        AlgorithmSuiteSecurityEvent algorithmSuiteSecurityEvent = (AlgorithmSuiteSecurityEvent)securityEvent;
        AlgorithmSuite algorithmSuite = (AlgorithmSuite)this.getAssertion();
        XMLSecurityConstants.AlgorithmUsage keyUsage = algorithmSuiteSecurityEvent.getAlgorithmUsage();
        if (WSSConstants.Sym_Sig.equals((Object)keyUsage)) {
            if (algorithmSuite.getSymmetricSignature() != null && !algorithmSuite.getSymmetricSignature().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric signature algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null) {
                if (!(algorithmSuiteSecurityEvent.isDerivedKey() || algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() <= algorithmSuiteSecurityEvent.getKeyLength() && algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() >= algorithmSuiteSecurityEvent.getKeyLength())) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric signature algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                    this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
                } else if (algorithmSuiteSecurityEvent.isDerivedKey() && algorithmSuite.getAlgorithmSuiteType().getSignatureDerivedKeyLength() != algorithmSuiteSecurityEvent.getKeyLength()) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric signature algorithm derived key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                    this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
                }
            }
        } else if (WSSConstants.Asym_Sig.equals((Object)keyUsage)) {
            if (algorithmSuite.getAsymmetricSignature() != null && !algorithmSuite.getAsymmetricSignature().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumAsymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumAsymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric signature algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.SigDig.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getDigest().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Digest algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Enc.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getEncryption().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Encryption algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null) {
                if (!(algorithmSuiteSecurityEvent.isDerivedKey() || algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() <= algorithmSuiteSecurityEvent.getKeyLength() && algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() >= algorithmSuiteSecurityEvent.getKeyLength())) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric encryption algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                    this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
                } else if (algorithmSuiteSecurityEvent.isDerivedKey() && algorithmSuite.getAlgorithmSuiteType().getEncryptionDerivedKeyLength() != algorithmSuiteSecurityEvent.getKeyLength()) {
                    this.setAsserted(false);
                    this.setErrorMessage("Symmetric encryption algorithm derived key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                    this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
                }
            }
        } else if (WSSConstants.Sym_Key_Wrap.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getSymmetricKeyWrap().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric key wrap algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumSymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumSymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Symmetric key wrap algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Asym_Key_Wrap.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getAsymmetricKeyWrap().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric key wrap algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
            if (algorithmSuite.getAlgorithmSuiteType() != null && (algorithmSuite.getAlgorithmSuiteType().getMinimumAsymmetricKeyLength() > algorithmSuiteSecurityEvent.getKeyLength() || algorithmSuite.getAlgorithmSuiteType().getMaximumAsymmetricKeyLength() < algorithmSuiteSecurityEvent.getKeyLength())) {
                this.setAsserted(false);
                this.setErrorMessage("Asymmetric key wrap algorithm key length " + algorithmSuiteSecurityEvent.getKeyLength() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Comp_Key.equals((Object)keyUsage)) {
            if (algorithmSuite.getComputedKey() != null && !algorithmSuite.getComputedKey().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Computed key algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Enc_KD.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getEncryptionKeyDerivation().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Encryption key derivation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Sig_KD.equals((Object)keyUsage)) {
            if (algorithmSuite.getAlgorithmSuiteType() != null && !algorithmSuite.getAlgorithmSuiteType().getSignatureKeyDerivation().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Signature key derivation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.SigC14n.equals((Object)keyUsage)) {
            if (algorithmSuite.getC14n() != null && !algorithmSuite.getC14n().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("C14N algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.SigTransform.equals((Object)keyUsage)) {
            if (!(algorithmSuite.getC14n() == null || algorithmSuite.getC14n().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmSuiteSecurityEvent.getAlgorithmURI()) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(algorithmSuiteSecurityEvent.getAlgorithmURI()) || "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform".equals(algorithmSuiteSecurityEvent.getAlgorithmURI()))) {
                this.setAsserted(false);
                this.setErrorMessage("Transform C14N algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.Soap_Norm.equals((Object)keyUsage)) {
            if (algorithmSuite.getSoapNormType() != null && !algorithmSuite.getSoapNormType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("Soap normalization algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.STR_Trans.equals((Object)keyUsage)) {
            if (algorithmSuite.getStrType() != null && !algorithmSuite.getStrType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                this.setAsserted(false);
                this.setErrorMessage("STR transformation algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
                this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
            }
        } else if (WSSConstants.XPath.equals((Object)keyUsage) && algorithmSuite.getXPathType() != null && !algorithmSuite.getXPathType().getValue().equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
            this.setAsserted(false);
            this.setErrorMessage("XPath algorithm " + algorithmSuiteSecurityEvent.getAlgorithmURI() + " does not meet policy");
            this.policyAsserter.unassertPolicy(this.getAssertion(), this.getErrorMessage());
        }
        if (this.isAsserted()) {
            this.policyAsserter.assertPolicy(this.getAssertion());
            String namespace = algorithmSuite.getAlgorithmSuiteType().getNamespace();
            String name = algorithmSuite.getAlgorithmSuiteType().getName();
            this.policyAsserter.assertPolicy(new QName(namespace, name));
        }
        return this.isAsserted();
    }
}

