/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

public class UsernameTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$UsernameTokenProcessor == null ? (class$org$apache$ws$security$processor$UsernameTokenProcessor = UsernameTokenProcessor.class$("org.apache.ws.security.processor.UsernameTokenProcessor")) : class$org$apache$ws$security$processor$UsernameTokenProcessor).getName());
    private String utId;
    private UsernameToken ut;
    private boolean handleCustomPasswordTypes;
    static /* synthetic */ Class class$org$apache$ws$security$processor$UsernameTokenProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found UsernameToken list element");
        }
        this.handleCustomPasswordTypes = wsc.getHandleCustomPasswordTypes();
        WSUsernameTokenPrincipal lastPrincipalFound = this.handleUsernameToken(elem, cb);
        returnResults.add(0, new WSSecurityEngineResult(1, lastPrincipalFound, null, null, null));
        this.utId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb;
        this.ut = new UsernameToken(token);
        String user = this.ut.getName();
        String password = this.ut.getPassword();
        String nonce = this.ut.getNonce();
        String createdTime = this.ut.getCreated();
        String pwType = this.ut.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + user));
            log.debug((Object)("UsernameToken password " + password));
        }
        Callback[] callbacks = new Callback[1];
        String origPassword = null;
        if (this.ut.isHashed()) {
            if (cb == null) {
                throw new WSSecurityException(0, "noCallback");
            }
            pwCb = new WSPasswordCallback(user, 2);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5);
            }
            catch (UnsupportedCallbackException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5);
            }
            origPassword = pwCb.getPassword();
            if (log.isDebugEnabled()) {
                log.debug((Object)("UsernameToken callback password " + origPassword));
            }
            if (origPassword == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{user});
            }
            String passDigest = UsernameToken.doPasswordDigest(nonce, createdTime, origPassword);
            if (!passDigest.equals(password)) {
                throw new WSSecurityException(5);
            }
            this.ut.setRawPassword(origPassword);
        } else {
            if (cb == null) {
                throw new WSSecurityException(0, "noCallback");
            }
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType) && !this.handleCustomPasswordTypes) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failed as handleCustomUsernameTokenTypes is false");
                }
                throw new WSSecurityException(5);
            }
            pwCb = new WSPasswordCallback(user, password, pwType, 5);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5);
            }
            catch (UnsupportedCallbackException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5);
            }
            this.ut.setRawPassword(password);
        }
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, this.ut.isHashed());
        principal.setNonce(nonce);
        principal.setPassword(password);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(pwType);
        return principal;
    }

    public String getId() {
        return this.utId;
    }

    public UsernameToken getUt() {
        return this.ut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

