/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.wicket.util.crypt.AbstractCrypt;

public class SunJceCrypt
extends AbstractCrypt {
    private static final int COUNT = 17;
    private static final String CRYPT_METHOD = "PBEWithMD5AndDES";
    private static final byte[] salt = new byte[]{21, -116, -93, 74, 102, 81, 42, -68};

    public SunJceCrypt() {
        if (Security.getProviders("Cipher.PBEWithMD5AndDES").length > 0) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.crypto.provider.SunJCE");
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load SunJCE service provider", ex);
        }
    }

    @Override
    protected final byte[] crypt(byte[] input, int mode) throws GeneralSecurityException {
        SecretKey key = this.generateSecretKey();
        PBEParameterSpec spec = new PBEParameterSpec(salt, 17);
        Cipher ciph = Cipher.getInstance(CRYPT_METHOD);
        ciph.init(mode, (Key)key, spec);
        return ciph.doFinal(input);
    }

    private SecretKey generateSecretKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(this.getKey().toCharArray());
        return SecretKeyFactory.getInstance(CRYPT_METHOD).generateSecret(spec);
    }
}

