/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultMessageHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.MUCStanzaBuilder;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.dataforms.VoiceRequestForm;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCHandlerHelper;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Conference;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.MucUserItem;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.X;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.MessageStanza;
import org.apache.vysper.xmpp.stanza.MessageStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUCMessageHandler
extends DefaultMessageHandler {
    final Logger logger = LoggerFactory.getLogger(MUCMessageHandler.class);
    private Conference conference;
    private Entity moduleDomain;

    public MUCMessageHandler(Conference conference, Entity moduleDomain) {
        this.conference = conference;
        this.moduleDomain = moduleDomain;
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return true;
    }

    private Stanza createMessageErrorStanza(Entity from, Entity to, String id, StanzaErrorType type, StanzaErrorCondition errorCondition, Stanza stanza) {
        return MUCHandlerHelper.createErrorStanza("message", "jabber:client", from, to, id, type.value(), errorCondition.value(), stanza.getInnerElements());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Stanza executeMessageLogic(MessageStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.debug("Received message for MUC");
        Entity from = stanza.getFrom();
        Entity roomWithNickJid = stanza.getTo();
        Entity roomJid = roomWithNickJid.getBareJID();
        MessageStanzaType type = stanza.getMessageType();
        if (type != null && type == MessageStanzaType.GROUPCHAT) {
            if (roomWithNickJid.getResource() != null) {
                return this.createMessageErrorStanza(roomJid, from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.BAD_REQUEST, (Stanza)stanza);
            }
            this.logger.debug("Received groupchat message to {}", (Object)roomJid);
            Room room = this.conference.findRoom(roomJid);
            if (room == null) return this.createMessageErrorStanza(this.moduleDomain, from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.ITEM_NOT_FOUND, (Stanza)stanza);
            Occupant sendingOccupant = room.findOccupantByJID(from);
            if (sendingOccupant == null) return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.NOT_ACCEPTABLE, (Stanza)stanza);
            EntityImpl roomAndSendingNick = new EntityImpl(room.getJID(), sendingOccupant.getNick());
            if (!sendingOccupant.hasVoice()) return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.FORBIDDEN, (Stanza)stanza);
            try {
                if (!(stanza.getSubjects() == null || stanza.getSubjects().isEmpty() || room.isRoomType(RoomType.OpenSubject) || sendingOccupant.isModerator())) {
                    return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.AUTH, StanzaErrorCondition.FORBIDDEN, (Stanza)stanza);
                }
            }
            catch (XMLSemanticError e) {
                // empty catch block
            }
            this.logger.debug("Relaying message to all room occupants");
            Iterator<Occupant> i$ = room.getOccupants().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    room.getHistory().append((Stanza)stanza, sendingOccupant);
                    return null;
                }
                Occupant occupent = i$.next();
                this.logger.debug("Relaying message to  {}", (Object)occupent);
                ArrayList<Attribute> replaceAttributes = new ArrayList<Attribute>();
                replaceAttributes.add(new Attribute("from", roomAndSendingNick.getFullQualifiedName()));
                replaceAttributes.add(new Attribute("to", occupent.getJid().getFullQualifiedName()));
                this.relayStanza(occupent.getJid(), (Stanza)StanzaBuilder.createClone((XMLElement)stanza, (boolean)true, replaceAttributes).build(), serverRuntimeContext);
            }
        }
        if (type != null && type != MessageStanzaType.CHAT) {
            if (type != MessageStanzaType.NORMAL) return null;
        }
        this.logger.debug("Received direct message to {}", (Object)roomWithNickJid);
        Room room = this.conference.findRoom(roomJid);
        if (room == null) return this.createMessageErrorStanza(this.moduleDomain, from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.ITEM_NOT_FOUND, (Stanza)stanza);
        Occupant sendingOccupant = room.findOccupantByJID(from);
        if (!roomWithNickJid.equals(roomJid)) {
            if (!roomWithNickJid.isResourceSet()) return null;
            if (sendingOccupant == null) return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.NOT_ACCEPTABLE, (Stanza)stanza);
            Occupant receivingOccupant = room.findOccupantByNick(roomWithNickJid.getResource());
            if (receivingOccupant == null) return this.createMessageErrorStanza(this.moduleDomain, from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.ITEM_NOT_FOUND, (Stanza)stanza);
            EntityImpl roomAndSendingNick = new EntityImpl(room.getJID(), sendingOccupant.getNick());
            this.logger.debug("Relaying message to  {}", (Object)receivingOccupant);
            ArrayList<Attribute> replaceAttributes = new ArrayList<Attribute>();
            replaceAttributes.add(new Attribute("from", roomAndSendingNick.getFullQualifiedName()));
            replaceAttributes.add(new Attribute("to", receivingOccupant.getJid().getFullQualifiedName()));
            this.relayStanza(receivingOccupant.getJid(), (Stanza)StanzaBuilder.createClone((XMLElement)stanza, (boolean)true, replaceAttributes).build(), serverRuntimeContext);
            return null;
        }
        if (stanza.getVerifier().onlySubelementEquals("x", "jabber:x:data")) {
            this.logger.debug("Received voice request for room {}", (Object)roomJid);
            this.handleVoiceRequest(from, sendingOccupant, room, (Stanza)stanza, serverRuntimeContext);
            return null;
        }
        if (!stanza.getVerifier().onlySubelementEquals("x", "http://jabber.org/protocol/muc#user")) return null;
        return this.handleInvites(stanza, from, sendingOccupant, room, serverRuntimeContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stanza handleInvites(MessageStanza stanza, Entity from, Occupant sendingOccupant, Room room, ServerRuntimeContext serverRuntimeContext) {
        X x = X.fromStanza((Stanza)stanza);
        if (x != null && x.getInvite() != null) {
            if (sendingOccupant == null) return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.NOT_ACCEPTABLE, (Stanza)stanza);
            try {
                Stanza invite = MUCHandlerHelper.createInviteMessageStanza((Stanza)stanza, room.getPassword());
                this.relayStanza(invite.getTo(), invite, serverRuntimeContext);
                return null;
            }
            catch (EntityFormatException e) {
                return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.JID_MALFORMED, (Stanza)stanza);
            }
        }
        if (x == null || x.getDecline() == null) return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.UNEXPECTED_REQUEST, (Stanza)stanza);
        try {
            Stanza decline = MUCHandlerHelper.createDeclineMessageStanza((Stanza)stanza);
            this.relayStanza(decline.getTo(), decline, serverRuntimeContext);
            return null;
        }
        catch (EntityFormatException e) {
            return this.createMessageErrorStanza(room.getJID(), from, stanza.getID(), StanzaErrorType.MODIFY, StanzaErrorCondition.JID_MALFORMED, (Stanza)stanza);
        }
    }

    private void handleVoiceRequest(Entity from, Occupant sendingOccupant, Room room, Stanza stanza, ServerRuntimeContext serverRuntimeContext) {
        block4: {
            String requestAllow;
            block3: {
                List dataXs = stanza.getInnerElementsNamed("x", "jabber:x:data");
                XMLElement dataX = (XMLElement)dataXs.get(0);
                List fields = dataX.getInnerElementsNamed("field", "jabber:x:data");
                requestAllow = this.getFieldValue(fields, "muc#request_allow");
                if (!"true".equals(requestAllow)) break block3;
                if (!sendingOccupant.isModerator()) break block4;
                String requestNick = this.getFieldValue(fields, "muc#roomnick");
                Occupant requestor = room.findOccupantByNick(requestNick);
                requestor.setRole(Role.Participant);
                MucUserItem presenceItem = new MucUserItem(requestor.getAffiliation(), requestor.getRole());
                for (Occupant occupant : room.getOccupants()) {
                    Stanza presenceToRemaining = MUCStanzaBuilder.createPresenceStanza(requestor.getJidInRoom(), occupant.getJid(), null, "http://jabber.org/protocol/muc#user", presenceItem);
                    this.relayStanza(occupant.getJid(), presenceToRemaining, serverRuntimeContext);
                }
                break block4;
            }
            if (requestAllow == null) {
                VoiceRequestForm requestForm = new VoiceRequestForm(from, sendingOccupant.getNick());
                for (Occupant moderator : room.getModerators()) {
                    Stanza request = (Stanza)((StanzaBuilder)StanzaBuilder.createMessageStanza((Entity)room.getJID(), (Entity)moderator.getJid(), null, null).addPreparedElement(requestForm.createFormXML())).build();
                    this.relayStanza(moderator.getJid(), request, serverRuntimeContext);
                }
            }
        }
    }

    private String getFieldValue(List<XMLElement> fields, String var) {
        for (XMLElement field : fields) {
            if (!var.equals(field.getAttributeValue("var"))) continue;
            try {
                return field.getSingleInnerElementsNamed("value", "jabber:x:data").getInnerText().getText();
            }
            catch (XMLSemanticError e) {
                return null;
            }
        }
        return null;
    }

    protected void relayStanza(Entity receiver, Stanza stanza, ServerRuntimeContext serverRuntimeContext) {
        try {
            serverRuntimeContext.getStanzaRelay().relay(receiver, stanza, (DeliveryFailureStrategy)new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            this.logger.warn("presence relaying failed ", (Throwable)e);
        }
    }
}

