/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSslX509Certificate;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Base64 BASE64_ENCODER = new Base64(64, new byte[]{10});
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager netSm = StringManager.getManager(AbstractEndpoint.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final String defaultProtocol = "TLS";
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private OpenSSLSessionContext sessionContext;
    private final List<String> negotiableProtocols;
    private List<String> jsseCipherNames = new ArrayList<String>();
    private String enabledProtocol;
    private final long aprPool;
    private final AtomicInteger aprPoolDestroyed = new AtomicInteger(0);
    protected final long ctx;
    static final CertificateFactory X509_CERT_FACTORY;
    private static final String BEGIN_KEY = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final Object END_KEY;
    private boolean initialized = false;

    public List<String> getJsseCipherNames() {
        return this.jsseCipherNames;
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String protocol) {
        this.enabledProtocol = protocol == null ? defaultProtocol : protocol;
    }

    public OpenSSLContext(SSLHostConfigCertificate certificate, List<String> negotiableProtocols) throws SSLException {
        this.sslHostConfig = certificate.getSSLHostConfig();
        this.certificate = certificate;
        this.aprPool = Pool.create((long)0L);
        boolean success = false;
        try {
            int value = 0;
            if (this.sslHostConfig.getProtocols().size() == 0) {
                value = 28;
            } else {
                for (String protocol : this.sslHostConfig.getEnabledProtocols()) {
                    if ("SSLv2Hello".equalsIgnoreCase(protocol)) continue;
                    if ("SSLv2".equalsIgnoreCase(protocol)) {
                        value |= 1;
                        continue;
                    }
                    if ("SSLv3".equalsIgnoreCase(protocol)) {
                        value |= 2;
                        continue;
                    }
                    if ("TLSv1".equalsIgnoreCase(protocol)) {
                        value |= 4;
                        continue;
                    }
                    if ("TLSv1.1".equalsIgnoreCase(protocol)) {
                        value |= 8;
                        continue;
                    }
                    if ("TLSv1.2".equalsIgnoreCase(protocol)) {
                        value |= 0x10;
                        continue;
                    }
                    if ("all".equalsIgnoreCase(protocol)) {
                        value |= 0x1C;
                        continue;
                    }
                    throw new Exception(netSm.getString("endpoint.apr.invalidSslProtocol", new Object[]{protocol}));
                }
            }
            try {
                this.ctx = org.apache.tomcat.jni.SSLContext.make((long)this.aprPool, (int)value, (int)1);
            }
            catch (Exception e) {
                throw new Exception(netSm.getString("endpoint.apr.failSslContextMake"), e);
            }
            this.negotiableProtocols = negotiableProtocols;
            success = true;
        }
        catch (Exception e) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), e);
        }
        finally {
            if (!success) {
                this.destroy();
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.aprPoolDestroyed.compareAndSet(0, 1)) {
            if (this.ctx != 0L) {
                org.apache.tomcat.jni.SSLContext.free((long)this.ctx);
            }
            if (this.aprPool != 0L) {
                Pool.destroy((long)this.aprPool);
            }
        }
    }

    @Override
    public synchronized void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) {
        if (this.initialized) {
            log.warn((Object)sm.getString("openssl.doubleInit"));
            return;
        }
        try {
            if (this.sslHostConfig.getInsecureRenegotiation()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)262144);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)262144);
            }
            String honorCipherOrderStr = this.sslHostConfig.getHonorCipherOrder();
            if (honorCipherOrderStr != null) {
                if (Boolean.parseBoolean(honorCipherOrderStr)) {
                    org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)0x400000);
                } else {
                    org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)0x400000);
                }
            }
            if (this.sslHostConfig.getDisableCompression()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)131072);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)131072);
            }
            if (this.sslHostConfig.getDisableSessionTickets()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)16384);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)16384);
            }
            if (this.sslHostConfig.getSessionCacheSize() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)this.sslHostConfig.getSessionCacheSize());
            } else {
                long sessionCacheSize = org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
            }
            if (this.sslHostConfig.getSessionTimeout() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)this.sslHostConfig.getSessionTimeout());
            } else {
                long sessionTimeout = org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
            }
            String opensslCipherConfig = this.sslHostConfig.getCiphers();
            this.jsseCipherNames = OpenSSLCipherConfigurationParser.parseExpression(opensslCipherConfig);
            org.apache.tomcat.jni.SSLContext.setCipherSuite((long)this.ctx, (String)opensslCipherConfig);
            if (this.certificate.getCertificateFile() != null) {
                org.apache.tomcat.jni.SSLContext.setCertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()), (String)SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile()), (String)this.certificate.getCertificateKeyPassword(), (int)0);
                org.apache.tomcat.jni.SSLContext.setCertificateChainFile((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.certificate.getCertificateChainFile()), (boolean)false);
                org.apache.tomcat.jni.SSLContext.setCACertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificateFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificatePath()));
                org.apache.tomcat.jni.SSLContext.setCARevocation((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListPath()));
            } else {
                X509KeyManager keyManager = OpenSSLContext.chooseKeyManager(kms);
                String alias = this.certificate.getCertificateKeyAlias();
                if (alias == null) {
                    alias = "tomcat";
                }
                X509Certificate[] chain = keyManager.getCertificateChain(alias);
                PrivateKey key = keyManager.getPrivateKey(alias);
                StringBuilder sb = new StringBuilder(BEGIN_KEY);
                String encoded = BASE64_ENCODER.encodeToString(key.getEncoded());
                if (encoded.endsWith("\n")) {
                    encoded = encoded.substring(0, encoded.length() - 1);
                }
                sb.append(encoded);
                sb.append(END_KEY);
                org.apache.tomcat.jni.SSLContext.setCertificateRaw((long)this.ctx, (byte[])chain[0].getEncoded(), (byte[])sb.toString().getBytes(StandardCharsets.US_ASCII), (int)0);
                for (int i = 1; i < chain.length; ++i) {
                    org.apache.tomcat.jni.SSLContext.addChainCertificateRaw((long)this.ctx, (byte[])chain[i].getEncoded());
                }
            }
            int value = 0;
            switch (this.sslHostConfig.getCertificateVerification()) {
                case NONE: {
                    value = 0;
                    break;
                }
                case OPTIONAL: {
                    value = 1;
                    break;
                }
                case OPTIONAL_NO_CA: {
                    value = 3;
                    break;
                }
                case REQUIRED: {
                    value = 2;
                }
            }
            org.apache.tomcat.jni.SSLContext.setVerify((long)this.ctx, (int)value, (int)this.sslHostConfig.getCertificateVerificationDepth());
            if (tms != null) {
                final X509TrustManager manager = OpenSSLContext.chooseTrustManager(tms);
                org.apache.tomcat.jni.SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new CertificateVerifier(){

                    public boolean verify(long ssl, byte[][] chain, String auth) {
                        X509Certificate[] peerCerts = OpenSSLContext.certificates(chain);
                        try {
                            manager.checkClientTrusted(peerCerts, auth);
                            return true;
                        }
                        catch (Exception e) {
                            log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)e);
                            return false;
                        }
                    }
                });
            }
            if (this.negotiableProtocols != null && this.negotiableProtocols.size() > 0) {
                ArrayList<String> protocols = new ArrayList<String>();
                protocols.addAll(this.negotiableProtocols);
                protocols.add("http/1.1");
                String[] protocolsArray = protocols.toArray(new String[0]);
                org.apache.tomcat.jni.SSLContext.setAlpnProtos((long)this.ctx, (String[])protocolsArray, (int)0);
                org.apache.tomcat.jni.SSLContext.setNpnProtos((long)this.ctx, (String[])protocolsArray, (int)0);
            }
            this.sessionContext = new OpenSSLSessionContext(this.ctx);
            this.sslHostConfig.setOpenSslContext(this.ctx);
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("openssl.errorSSLCtxInit"), (Throwable)e);
            this.destroy();
        }
    }

    private static X509KeyManager chooseKeyManager(KeyManager[] managers) throws Exception {
        for (KeyManager manager : managers) {
            if (!(manager instanceof JSSEKeyManager)) continue;
            return (JSSEKeyManager)manager;
        }
        for (KeyManager manager : managers) {
            if (!(manager instanceof X509KeyManager)) continue;
            return (X509KeyManager)manager;
        }
        throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSslX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(this.ctx, defaultProtocol, false, this.sessionContext, this.negotiableProtocols != null && this.negotiableProtocols.size() > 0);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    static {
        END_KEY = "\n-----END RSA PRIVATE KEY-----";
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), e);
        }
    }
}

