/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.HandshakeRequest;

public class WsHandshakeRequest
implements HandshakeRequest {
    private final URI requestUri;
    private final Map<String, List<String>> parameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final Map<String, List<String>> headers;
    private final Object httpSession;
    private volatile HttpServletRequest request;

    public WsHandshakeRequest(HttpServletRequest request) {
        this.request = request;
        this.queryString = request.getQueryString();
        this.userPrincipal = request.getUserPrincipal();
        this.httpSession = request.getSession(false);
        StringBuilder sb = new StringBuilder(request.getRequestURI());
        if (this.queryString != null) {
            sb.append("?");
            sb.append(this.queryString);
        }
        try {
            this.requestUri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        Map originalParameters = request.getParameterMap();
        HashMap newParameters = new HashMap(originalParameters.size());
        for (Map.Entry entry : originalParameters.entrySet()) {
            newParameters.put(entry.getKey(), Collections.unmodifiableList(Arrays.asList((Object[])entry.getValue())));
        }
        this.parameterMap = Collections.unmodifiableMap(newParameters);
        HashMap newHeaders = new HashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            newHeaders.put(headerName, Collections.unmodifiableList(Collections.list(request.getHeaders(headerName))));
        }
        this.headers = Collections.unmodifiableMap(newHeaders);
    }

    @Override
    public URI getRequestURI() {
        return this.requestUri;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.request == null) {
            throw new IllegalStateException();
        }
        return this.request.isUserInRole(role);
    }

    @Override
    public Object getHttpSession() {
        return this.httpSession;
    }

    void finished() {
        this.request = null;
    }
}

