/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.ognl;

import ognl.PropertyAccessor;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.util.CombinedBeanInfo;

public class TilesContextPropertyAccessorDelegateFactory
implements PropertyAccessorDelegateFactory<Request> {
    private PropertyAccessor objectPropertyAccessor;
    private PropertyAccessor applicationContextPropertyAccessor;
    private PropertyAccessor anyScopePropertyAccessor;
    private PropertyAccessor scopePropertyAccessor;
    private CombinedBeanInfo beanInfo = new CombinedBeanInfo(new Class[]{Request.class, ApplicationContext.class});

    public TilesContextPropertyAccessorDelegateFactory(PropertyAccessor objectPropertyAccessor, PropertyAccessor applicationContextPropertyAccessor, PropertyAccessor anyScopePropertyAccessor, PropertyAccessor scopePropertyAccessor) {
        this.objectPropertyAccessor = objectPropertyAccessor;
        this.applicationContextPropertyAccessor = applicationContextPropertyAccessor;
        this.anyScopePropertyAccessor = anyScopePropertyAccessor;
        this.scopePropertyAccessor = scopePropertyAccessor;
    }

    @Override
    public PropertyAccessor getPropertyAccessor(String propertyName, Request request) {
        PropertyAccessor retValue;
        String scopeName;
        if (propertyName.endsWith("Scope") && request.getContext(scopeName = propertyName.substring(0, propertyName.length() - 5)) != null) {
            return this.scopePropertyAccessor;
        }
        if (this.beanInfo.getMappedDescriptors(Request.class).containsKey(propertyName)) {
            retValue = this.objectPropertyAccessor;
        } else if (this.beanInfo.getMappedDescriptors(ApplicationContext.class).containsKey(propertyName)) {
            retValue = this.applicationContextPropertyAccessor;
        } else {
            return this.anyScopePropertyAccessor;
        }
        return retValue;
    }
}

