/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends PDFTextStripper {
    private final XHTMLContentHandler handler;

    public static void process(PDDocument document, ContentHandler handler, Metadata metadata) throws SAXException, TikaException {
        try {
            new PDF2XHTML(handler, metadata).writeText(document, new Writer(){

                public void write(char[] cbuf, int off, int len) {
                }

                public void flush() {
                }

                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
    }

    private PDF2XHTML(ContentHandler handler, Metadata metadata) throws IOException {
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.setForceParsing(true);
        this.setSortByPosition(true);
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), (Throwable)e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.handler.characters(" ");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", (Throwable)e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.handler.characters("\n");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", (Throwable)e);
        }
    }
}

