/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.image.xmp.XMPPacketScanner;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JempboxExtractor {
    private XMPPacketScanner scanner = new XMPPacketScanner();
    private Metadata metadata;
    private static final String DEFAULT_XMP_CHARSET = "UTF-8";

    public JempboxExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parse(InputStream file) throws IOException, TikaException {
        ByteArrayOutputStream xmpraw = new ByteArrayOutputStream();
        boolean found = this.scanner.parse(file, xmpraw);
        file.close();
        if (!found) {
            return;
        }
        InputStreamReader decoded = new InputStreamReader((InputStream)new ByteArrayInputStream(xmpraw.toByteArray()), DEFAULT_XMP_CHARSET);
        XMPMetadata xmp = XMPMetadata.load((InputSource)new InputSource(decoded));
        XMPSchemaDublinCore dc = xmp.getDublinCoreSchema();
        if (dc != null) {
            if (dc.getTitle() != null) {
                this.metadata.set("title", dc.getTitle());
            }
            if (dc.getDescription() != null) {
                this.metadata.set("description", dc.getDescription());
            }
            if (dc.getCreators() != null && dc.getCreators().size() > 0) {
                this.metadata.set("creator", this.joinCreators(dc.getCreators()));
            }
            if (dc.getSubjects() != null && dc.getSubjects().size() > 0) {
                Iterator keywords = dc.getSubjects().iterator();
                while (keywords.hasNext()) {
                    this.metadata.add("subject", (String)keywords.next());
                }
            }
        }
    }

    protected String joinCreators(List<String> creators) {
        if (creators == null || creators.size() == 0) {
            return "";
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        StringBuffer c = new StringBuffer();
        for (String s : creators) {
            c.append(", ").append(s);
        }
        return c.substring(2);
    }
}

