/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class PackageParser
extends DelegatingParser {
    protected void parseArchive(ArchiveInputStream archive, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        ArchiveEntry entry = archive.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                xhtml.startElement("div", "class", "package-entry");
                Metadata entrydata = new Metadata();
                String name = entry.getName();
                if (name != null && name.length() > 0) {
                    entrydata.set("resourceName", name);
                    xhtml.element("h1", name);
                }
                try {
                    super.parse((InputStream)new CloseShieldInputStream((InputStream)archive), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), entrydata, context);
                }
                catch (TikaException e) {
                    // empty catch block
                }
                xhtml.endElement("div");
            }
            entry = archive.getNextEntry();
        }
        xhtml.endDocument();
    }
}

