/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentDirectory;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.image.MetadataFields;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMetadataExtractor {
    private final org.apache.tika.metadata.Metadata metadata;
    private DirectoryHandler[] handlers;

    public ImageMetadataExtractor(org.apache.tika.metadata.Metadata metadata) {
        this(metadata, new CopyUnknownFieldsHandler(), new JpegCommentHandler(), new ExifHandler(), new DimensionsHandler(), new GeotagHandler(), new IptcHandler());
    }

    public ImageMetadataExtractor(org.apache.tika.metadata.Metadata metadata, DirectoryHandler ... handlers) {
        this.metadata = metadata;
        this.handlers = handlers;
    }

    public void parseJpeg(File file) throws IOException, SAXException, TikaException {
        try {
            JpegSegmentReader reader = new JpegSegmentReader(file);
            this.extractMetadataFromSegment(reader, (byte)-31, ExifReader.class);
            this.extractMetadataFromSegment(reader, (byte)-19, IptcReader.class);
            this.extractMetadataFromSegment(reader, (byte)-64, JpegReader.class);
            this.extractMetadataFromSegment(reader, (byte)-2, JpegCommentReader.class);
        }
        catch (JpegProcessingException e) {
            throw new TikaException("Can't read JPEG metadata", e);
        }
    }

    private void extractMetadataFromSegment(JpegSegmentReader reader, byte marker, Class<? extends MetadataReader> klass) {
        try {
            Constructor<? extends MetadataReader> constructor = klass.getConstructor(byte[].class);
            int n = reader.getSegmentCount(marker);
            for (int i = 0; i < n; ++i) {
                byte[] segment = reader.readSegment(marker, i);
                Metadata metadata = new Metadata();
                constructor.newInstance(new Object[]{segment}).extract(metadata);
                this.handle(metadata);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void parseTiff(InputStream stream) throws IOException, SAXException, TikaException {
        try {
            Metadata tiffMetadata = TiffMetadataReader.readMetadata(stream);
            this.handle(tiffMetadata);
        }
        catch (TiffProcessingException e) {
            throw new TikaException("Can't read TIFF metadata", e);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't read TIFF metadata", e);
        }
    }

    protected void handle(Metadata metadataExtractor) throws MetadataException {
        this.handle(metadataExtractor.getDirectoryIterator());
    }

    protected void handle(Iterator<Directory> directories) throws MetadataException {
        while (directories.hasNext()) {
            Directory directory = directories.next();
            for (int i = 0; i < this.handlers.length; ++i) {
                if (!this.handlers[i].supports(directory.getClass())) continue;
                this.handlers[i].handle(directory, this.metadata);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GeotagHandler
    implements DirectoryHandler {
        private static final Pattern HOURS_MINUTES_SECONDS = Pattern.compile("(-?\\d+)\"(\\d+)'(\\d+\\.?\\d*)");
        private static final DecimalFormat LAT_LONG_FORMAT = new DecimalFormat("##0.0####", new DecimalFormatSymbols(Locale.US));

        GeotagHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == GpsDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            Double longitude;
            Double latitude;
            String lat = directory.getDescription(2);
            String latNS = directory.getDescription(1);
            if (lat != null && (latitude = this.parseHMS(lat)) != null) {
                if (latNS != null && latNS.equalsIgnoreCase("S") && latitude > 0.0) {
                    latitude = latitude * -1.0;
                }
                metadata.set(org.apache.tika.metadata.Metadata.LATITUDE, LAT_LONG_FORMAT.format(latitude));
            }
            String lng = directory.getDescription(4);
            String lngEW = directory.getDescription(3);
            if (lng != null && (longitude = this.parseHMS(lng)) != null) {
                if (lngEW != null && lngEW.equalsIgnoreCase("W") && longitude > 0.0) {
                    longitude = longitude * -1.0;
                }
                metadata.set(org.apache.tika.metadata.Metadata.LONGITUDE, LAT_LONG_FORMAT.format(longitude));
            }
        }

        private Double parseHMS(String hms) {
            Matcher m = HOURS_MINUTES_SECONDS.matcher(hms);
            if (m.matches()) {
                double value = (double)Integer.parseInt(m.group(1)) + (double)Integer.parseInt(m.group(2)) / 60.0 + Double.parseDouble(m.group(3)) / 60.0 / 60.0;
                return value;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IptcHandler
    implements DirectoryHandler {
        IptcHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == IptcDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.containsTag(537)) {
                String[] keywords;
                for (String k : keywords = directory.getStringArray(537)) {
                    metadata.add("Keywords", k);
                }
            }
            if (directory.containsTag(617)) {
                metadata.set("title", directory.getString(617));
            } else if (directory.containsTag(517)) {
                metadata.set("title", directory.getString(517));
            }
            if (directory.containsTag(592)) {
                metadata.set("Author", directory.getString(592));
            }
            if (directory.containsTag(632)) {
                metadata.set("description", directory.getString(632).replaceAll("\r\n?", "\n"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExifHandler
    implements DirectoryHandler {
        private static final SimpleDateFormat DATE_UNSPECIFIED_TZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

        ExifHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == ExifDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            try {
                this.handleDateTags(directory, metadata);
                this.handlePhotoTags(directory, metadata);
                this.handleCommentTags(directory, metadata);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }

        public void handleCommentTags(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            if (metadata.get("description") == null && directory.containsTag(270)) {
                metadata.set("description", directory.getString(270));
            }
        }

        public void handlePhotoTags(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            Object resolution;
            Object length;
            if (directory.containsTag(33434)) {
                Object exposure = directory.getObject(33434);
                if (exposure instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, ((Rational)exposure).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, directory.getString(33434));
                }
            }
            if (directory.containsTag(37385)) {
                String flash = "";
                try {
                    flash = directory.getDescription(37385);
                }
                catch (MetadataException e) {
                    // empty catch block
                }
                if (flash.indexOf("Flash fired") > -1) {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.TRUE.toString());
                } else if (flash.indexOf("Flash did not fire") > -1) {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.FALSE.toString());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, flash);
                }
            }
            if (directory.containsTag(33437)) {
                Object fnumber = directory.getObject(33437);
                if (fnumber instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, ((Rational)fnumber).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, directory.getString(33437));
                }
            }
            if (directory.containsTag(37386)) {
                length = directory.getObject(37386);
                if (length instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, ((Rational)length).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, directory.getString(37386));
                }
            }
            if (directory.containsTag(34855)) {
                metadata.set(org.apache.tika.metadata.Metadata.ISO_SPEED_RATINGS, directory.getString(34855));
            }
            if (directory.containsTag(271)) {
                metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MAKE, directory.getString(271));
            }
            if (directory.containsTag(272)) {
                metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MODEL, directory.getString(272));
            }
            if (directory.containsTag(274)) {
                length = directory.getObject(274);
                if (length instanceof Integer) {
                    metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, Integer.toString((Integer)length));
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, directory.getString(274));
                }
            }
            if (directory.containsTag(305)) {
                metadata.set(org.apache.tika.metadata.Metadata.SOFTWARE, directory.getString(305));
            }
            if (directory.containsTag(282)) {
                resolution = directory.getObject(282);
                if (resolution instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, ((Rational)resolution).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, directory.getString(282));
                }
            }
            if (directory.containsTag(283)) {
                resolution = directory.getObject(283);
                if (resolution instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, ((Rational)resolution).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, directory.getString(283));
                }
            }
            if (directory.containsTag(296)) {
                try {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_UNIT, directory.getDescription(296));
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
            }
        }

        public void handleDateTags(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            Date original = null;
            if (directory.containsTag(36867)) {
                original = directory.getDate(36867);
                String datetimeNoTimeZone = DATE_UNSPECIFIED_TZ.format(original);
                metadata.set(org.apache.tika.metadata.Metadata.DATE, datetimeNoTimeZone);
                metadata.set(org.apache.tika.metadata.Metadata.ORIGINAL_DATE, datetimeNoTimeZone);
            }
            if (directory.containsTag(306)) {
                Date datetime = directory.getDate(306);
                String datetimeNoTimeZone = DATE_UNSPECIFIED_TZ.format(datetime);
                metadata.set(org.apache.tika.metadata.Metadata.LAST_MODIFIED, datetimeNoTimeZone);
                if (original == null) {
                    metadata.set(org.apache.tika.metadata.Metadata.DATE, datetimeNoTimeZone);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpegCommentHandler
    implements DirectoryHandler {
        JpegCommentHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == JpegCommentDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.containsTag(0)) {
                metadata.add("comment", directory.getString(0));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DimensionsHandler
    implements DirectoryHandler {
        private final Pattern LEADING_NUMBERS = Pattern.compile("(\\d+)\\s*.*");

        DimensionsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == JpegDirectory.class || directoryType == ExifDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            this.set(directory, metadata, 256, org.apache.tika.metadata.Metadata.IMAGE_WIDTH);
            this.set(directory, metadata, 3, org.apache.tika.metadata.Metadata.IMAGE_WIDTH);
            this.set(directory, metadata, 257, org.apache.tika.metadata.Metadata.IMAGE_LENGTH);
            this.set(directory, metadata, 1, org.apache.tika.metadata.Metadata.IMAGE_LENGTH);
            this.set(directory, metadata, 0, org.apache.tika.metadata.Metadata.BITS_PER_SAMPLE);
            this.set(directory, metadata, 258, org.apache.tika.metadata.Metadata.BITS_PER_SAMPLE);
            this.set(directory, metadata, 277, org.apache.tika.metadata.Metadata.SAMPLES_PER_PIXEL);
        }

        private void set(Directory directory, org.apache.tika.metadata.Metadata metadata, int extractTag, Property metadataField) {
            Matcher m;
            if (directory.containsTag(extractTag) && (m = this.LEADING_NUMBERS.matcher(directory.getString(extractTag))).matches()) {
                metadata.set(metadataField, m.group(1));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CopyUnknownFieldsHandler
    implements DirectoryHandler {
        CopyUnknownFieldsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return true;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            Iterator tags = directory.getTagIterator();
            while (tags.hasNext()) {
                Tag tag = (Tag)tags.next();
                String name = tag.getTagName();
                if (MetadataFields.isMetadataField(name)) continue;
                try {
                    String value = tag.getDescription().trim();
                    if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                        value = Boolean.TRUE.toString();
                    } else if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                        value = Boolean.FALSE.toString();
                    }
                    metadata.set(name, value);
                }
                catch (MetadataException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CopyAllFieldsHandler
    implements DirectoryHandler {
        CopyAllFieldsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return true;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            Iterator tags = directory.getTagIterator();
            while (tags.hasNext()) {
                Tag tag = (Tag)tags.next();
                metadata.set(tag.getTagName(), tag.getDescription());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface DirectoryHandler {
        public boolean supports(Class<? extends Directory> var1);

        public void handle(Directory var1, org.apache.tika.metadata.Metadata var2) throws MetadataException;
    }
}

