/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.threegpp26245;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontTableBox
extends AbstractBox {
    List<FontRecord> entries = new LinkedList<FontRecord>();

    public FontTableBox() {
        super(IsoFile.fourCCtoBytes("ftab"));
    }

    public void parse(IsoBufferWrapper in) {
    }

    @Override
    public void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt16(this.entries.size());
        for (FontRecord record : this.entries) {
            record.getContent(isos);
        }
    }

    @Override
    protected long getContentSize() {
        int size = 2;
        for (FontRecord fontRecord : this.entries) {
            size += fontRecord.getSize();
        }
        return size;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        int numberOfRecords = in.readUInt16();
        for (int i = 0; i < numberOfRecords; ++i) {
            FontRecord fr = new FontRecord();
            fr.parse(in);
            this.entries.add(fr);
        }
    }

    public List<FontRecord> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FontRecord> entries) {
        this.entries = entries;
    }

    public static class FontRecord {
        int fontId;
        String fontname;

        public FontRecord() {
        }

        public FontRecord(int fontId, String fontname) {
            this.fontId = fontId;
            this.fontname = fontname;
        }

        public void parse(IsoBufferWrapper in) throws IOException {
            this.fontId = in.readUInt16();
            int length = in.readUInt8();
            this.fontname = in.readString(length);
        }

        public void getContent(IsoOutputStream isos) throws IOException {
            isos.writeUInt16(this.fontId);
            isos.writeUInt8(this.fontname.length());
            isos.writeStringNoTerm(this.fontname);
        }

        public int getSize() {
            return AbstractBox.utf8StringLengthInBytes(this.fontname) + 3;
        }

        public String toString() {
            return "FontRecord{fontId=" + this.fontId + ", fontname='" + this.fontname + '\'' + '}';
        }
    }
}

