/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.UnknownDescriptor;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

public class ObjectDescriptorFactory {
    protected static Logger log = Logger.getLogger(ObjectDescriptorFactory.class.getName());
    protected static Map<Integer, Map<Integer, Class<? extends BaseDescriptor>>> descriptorRegistry = new HashMap<Integer, Map<Integer, Class<? extends BaseDescriptor>>>();

    public static BaseDescriptor createFrom(int objectTypeIndication, IsoBufferWrapper in, long size) throws IOException {
        BaseDescriptor baseDescriptor;
        Class<? extends BaseDescriptor> aClass;
        int tag = in.readUInt8();
        Map<Integer, Class<? extends BaseDescriptor>> tagMap = descriptorRegistry.get(objectTypeIndication);
        if (tagMap == null) {
            tagMap = descriptorRegistry.get(-1);
        }
        if ((aClass = tagMap.get(tag)) == null || aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers())) {
            log.warning("No ObjectDescriptor found for objectTypeIndication " + Integer.toHexString(objectTypeIndication) + " and tag " + Integer.toHexString(tag) + " found: " + aClass);
            baseDescriptor = new UnknownDescriptor();
        } else {
            try {
                baseDescriptor = aClass.newInstance();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Couldn't instantiate BaseDescriptor class " + aClass + " for objectTypeIndication " + objectTypeIndication + " and tag " + tag, e);
                throw new RuntimeException(e);
            }
        }
        baseDescriptor.parse(tag, in, (int)size - 1);
        return baseDescriptor;
    }

    static {
        URL url = ClasspathUrlFinder.findClassBase(BaseDescriptor.class);
        AnnotationDB db = new AnnotationDB();
        try {
            db.scanArchives(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, Set<String>> annotationIndex = db.getAnnotationIndex();
        Set<String> annotated = annotationIndex.get(Descriptor.class.getName());
        for (String aClass : annotated) {
            Descriptor descriptor;
            Class<?> clazz;
            try {
                clazz = Class.forName(aClass);
                descriptor = clazz.getAnnotation(Descriptor.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException();
            }
            int[] tags = descriptor.tags();
            int objectTypeInd = descriptor.objectTypeIndication();
            Map<Integer, Class<? extends BaseDescriptor>> tagMap = descriptorRegistry.get(objectTypeInd);
            if (tagMap == null) {
                tagMap = new HashMap<Integer, Class<? extends BaseDescriptor>>();
            }
            for (int tag : tags) {
                tagMap.put(tag, clazz);
            }
            descriptorRegistry.put(objectTypeInd, tagMap);
        }
    }
}

