/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.vodafone;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AlbumArtistBox
extends AbstractFullBox {
    public static final String TYPE = "albr";
    private String language;
    private String albumArtist;

    public AlbumArtistBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAlbumArtist(String albumArtist) {
        this.albumArtist = albumArtist;
    }

    protected long getContentSize() {
        return 2 + AlbumArtistBox.utf8StringLengthInBytes(this.albumArtist) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.albumArtist = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.albumArtist);
    }

    public String toString() {
        return "AlbumArtistBox[language=" + this.getLanguage() + ";albumArtist=" + this.getAlbumArtist() + "]";
    }
}

