/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Arrays;

public class HintPacketsSentBox
extends AbstractBox {
    private long packetsSent;
    public static final String TYPE1 = "nump";
    public static final String TYPE2 = "npck";

    public HintPacketsSentBox(byte[] type) {
        super(type);
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    protected long getContentSize() {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1))) {
            return 8L;
        }
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2))) {
            return 4L;
        }
        throw new UnsupportedOperationException();
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1))) {
            this.packetsSent = in.readUInt64();
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2))) {
            this.packetsSent = in.readUInt32();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE1))) {
            isos.writeUInt64(this.packetsSent);
        } else if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes(TYPE2))) {
            isos.writeUInt32((int)this.packetsSent);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String toString() {
        return "HintPacketsSentBox[packetsSent=" + this.getPacketsSent() + "]";
    }
}

